/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.toolbox;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.LruCache;
import androidx.annotation.NonNull;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.DownLoadRequest;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.hisavana.common.toolbox.interfacez.ResponseListener;
import com.hisavana.common.utils.AdLogUtil;
import com.transsion.core.CoreUtil;
import com.transsion.http.util.MD5;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public class AdImageLoadHelper {
    private static final String TAG = "AdImageLoadHelper";
    private static AdImageLoadHelper loader;
    private static LruCache<String, WeakReference<AdImage>> cache;
    private ReferenceQueue<AdImage> queue;
    private static final int MB = 0x100000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AdImageLoadHelper with() {
        if (loader != null) return loader;
        Class<AdImageLoadHelper> clazz = AdImageLoadHelper.class;
        synchronized (AdImageLoadHelper.class) {
            if (loader != null) return loader;
            loader = new AdImageLoadHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return loader;
        }
    }

    private AdImageLoadHelper() {
        long l = Runtime.getRuntime().maxMemory() / 8L;
        int n = Math.min(Math.max(0x1400000, (int)l), 0xC800000);
        cache = new LruCache<String, WeakReference<AdImage>>(n){

            protected int sizeOf(String string, WeakReference<AdImage> weakReference) {
                if (weakReference.get() != null) {
                    ((AdImage)weakReference.get()).getByteSize();
                }
                return super.size();
            }
        };
        this.queue = new ReferenceQueue();
    }

    public void loadImage(@NonNull String string, ResponseListener responseListener) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.dispatchResult("", null, responseListener);
            return;
        }
        String string2 = MD5.MD5Encode((String)string);
        WeakReference weakReference = (WeakReference)cache.get((Object)string2);
        if (weakReference != null && weakReference.get() != null && ((AdImage)weakReference.get()).isAdImageRecycled()) {
            this.dispatchResult(null, (AdImage)weakReference.get(), responseListener);
        } else {
            this.downloadBitmap(string2, string, responseListener);
        }
    }

    private void downloadBitmap(final String string, String string2, final ResponseListener responseListener) {
        DownLoadRequest downLoadRequest = new DownLoadRequest().setListener(new DrawableResponseListener(){

            public void onRequestSuccess(int n, byte[] byArray, AdImage adImage) {
                try {
                    AdImageLoadHelper.this.dispatchResult(string, adImage, responseListener);
                }
                catch (Throwable throwable) {
                    AdImageLoadHelper.this.dispatchResult(string, null, responseListener);
                }
            }

            protected void onRequestError(TaErrorCode taErrorCode) {
                AdLogUtil.Log().w(AdImageLoadHelper.TAG, "download fail code:" + taErrorCode.toString());
                AdImageLoadHelper.this.dispatchResult(string, null, responseListener);
            }
        }).setUrl(string2);
        downLoadRequest.netRequestPreExecute();
    }

    private void dispatchResult(final String string, final AdImage adImage, final ResponseListener responseListener) {
        Preconditions.runOnMainThread((Preconditions.Callback)new Preconditions.Callback(){

            public void onRun() {
                if (adImage == null) {
                    if (responseListener != null) {
                        responseListener.onFail();
                    }
                    return;
                }
                if (!adImage.isAdImageRecycled() && !TextUtils.isEmpty((CharSequence)string)) {
                    cache.put((Object)string, new WeakReference<AdImage>(adImage, AdImageLoadHelper.this.queue));
                }
                if (responseListener != null) {
                    if (adImage.isAdImageRecycled()) {
                        responseListener.onFail();
                    } else {
                        responseListener.onSuccess(adImage);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Drawable transform(@NonNull Bitmap bitmap) {
        BitmapDrawable bitmapDrawable = null;
        if (bitmap == null) {
            return null;
        }
        try {
            bitmapDrawable = new BitmapDrawable(CoreUtil.getContext().getResources(), bitmap);
            return bitmapDrawable;
        }
        catch (Throwable throwable) {
            AdLogUtil.Log().e(TAG, "transform bitmap to drawable exception");
        }
        finally {
            return bitmapDrawable;
        }
    }
}

