/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.mediation.ad;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.cloud.hisavana.sdk.common.util.TimeUtil;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.interfacz.ICacheAd;
import com.hisavana.common.interfacz.OnSkipListener;
import com.hisavana.common.interfacz.TAdListener;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.mediation.ad.TBaseAd;
import com.hisavana.mediation.bean.CloudControlConfig;
import com.hisavana.mediation.config.ConfigContentHelper;
import com.hisavana.mediation.config.a;
import com.hisavana.mediation.config.f;
import com.transsion.core.log.LogUtils;
import java.util.ArrayList;
import java.util.List;

public class TAdListenerAdapter
extends TAdListener {
    private static final String TAG = "TAdListenerAdapter";
    private TBaseAd tBaseAd;
    private TAdListener tadListener;
    private OnSkipListener skipListener;
    private int mFillSource;

    public void setFillSource(int n) {
        this.mFillSource = n;
    }

    public TAdListenerAdapter(@NonNull TBaseAd tBaseAd) {
        this.tBaseAd = tBaseAd;
    }

    public void setDispatchListener(TAdListener tAdListener) {
        this.tadListener = tAdListener;
    }

    public TAdListener getDispatchListener() {
        return this.tadListener;
    }

    public void setSkipListener(OnSkipListener onSkipListener) {
        this.skipListener = onSkipListener;
    }

    public void onSkipClick() {
        if (this.skipListener != null) {
            this.skipListener.onClick();
        }
    }

    public void onTimeReach() {
        if (this.skipListener != null) {
            this.skipListener.onTimeReach();
        }
    }

    public void onAdLoad(Object object) {
        AdLogUtil.Log().d("ad_flow", "*----> TAdListenerAdapter --> on alliance ad load");
        if (this.tBaseAd == null || this.tadListener == null) {
            return;
        }
        AdLogUtil.Log().d("ad_flow", "*----> TAdListenerAdapter --> >>> onLoad()");
        this.tBaseAd.stopTimer();
        this.tBaseAd.setLoading(false);
        this.tBaseAd.setAdReady(true);
        this.tBaseAd.mFillSource = this.mFillSource;
        int n = -1;
        if (object instanceof ArrayList) {
            TAdNativeInfo tAdNativeInfo;
            ArrayList arrayList = (ArrayList)object;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            TAdNativeInfo tAdNativeInfo2 = tAdNativeInfo = arrayList.isEmpty() ? null : (TAdNativeInfo)arrayList.get(0);
            if (tAdNativeInfo != null) {
                tAdNativeInfo.setFillSource(this.mFillSource);
                if ("Hotapps".equals(tAdNativeInfo.getAdSeatType()) && arrayList.size() > 0) {
                    for (TAdNativeInfo tAdNativeInfo3 : arrayList) {
                        if (tAdNativeInfo3 == null || TextUtils.isEmpty((CharSequence)tAdNativeInfo3.getAdCreateId())) continue;
                        arrayList2.add(tAdNativeInfo3.getAdCreateId());
                    }
                }
                n = tAdNativeInfo.getAdSource();
            }
            this.tBaseAd.trackingAdLoaded((ICacheAd)tAdNativeInfo, 0, "", this.mFillSource, arrayList2);
            this.onLoad(arrayList, n);
        } else if (object instanceof ICacheAd) {
            this.tBaseAd.trackingAdLoaded((ICacheAd)object, 0, "", this.mFillSource, null);
            n = ((ICacheAd)object).getAdSource();
            this.onLoad(n);
        }
        a.b(3);
    }

    public void onLoad(int n) {
        AdLogUtil.Log().d(TAG, "onLoad " + n);
        if (this.tadListener != null) {
            this.tadListener.onLoad(n);
        }
        if (this.tBaseAd != null) {
            this.tBaseAd.a();
        }
    }

    public void onLoad(List<TAdNativeInfo> list, int n) {
        AdLogUtil.Log().d(TAG, "onLoad native " + n);
        if (this.tadListener != null) {
            this.tadListener.onLoad(list, n);
        }
    }

    public void onError(TAdErrorCode tAdErrorCode) {
        if (this.tBaseAd == null || this.tadListener == null) {
            return;
        }
        int n = tAdErrorCode != null ? tAdErrorCode.getErrorCode() : -1;
        String string2 = tAdErrorCode != null ? tAdErrorCode.getErrorMessage() : "";
        AdLogUtil.Log().d("ad_flow", "TAdListenerAdapter --> on alliance error: " + string2);
        this.tBaseAd.stopTimer();
        this.tBaseAd.setLoading(false);
        this.tBaseAd.setAdReady(false);
        this.tBaseAd.trackingAdLoaded(null, n, string2, this.mFillSource, null);
        this.tadListener.onError(tAdErrorCode);
        if (n == 9035) {
            a.b(3);
        }
    }

    public void onShow(int n) {
        AdLogUtil.Log().d("ad_flow", "TAdListenerAdapter --> on show");
        this.updateConfigShowInfo();
        if (this.tadListener != null) {
            LogUtils.d((String)"ad_flow", (Object[])new Object[]{"TAdListenerAdapter --> >>> onShow()"});
            this.tadListener.onShow(n);
        }
    }

    public void onClicked(int n) {
        AdLogUtil.Log().d("ad_flow", "TAdListenerAdapter --> on click");
        if (this.tadListener != null) {
            LogUtils.d((String)"ad_flow", (Object[])new Object[]{"TAdListenerAdapter --> >>> onClicked()"});
            this.tadListener.onClicked(n);
        }
    }

    public void onClosed(int n) {
        AdLogUtil.Log().d("ad_flow", "TAdListenerAdapter --> on close");
        if (this.tadListener != null) {
            LogUtils.d((String)"ad_flow", (Object[])new Object[]{"TAdListenerAdapter --> >>> onClosed()"});
            this.tadListener.onClosed(n);
        }
    }

    public void onClosed(TAdNativeInfo tAdNativeInfo) {
        AdLogUtil.Log().d("ad_flow", "TAdListenerAdapter --> on close");
        if (this.tadListener != null) {
            LogUtils.d((String)"ad_flow", (Object[])new Object[]{"TAdListenerAdapter --> >>> onClosed()"});
            this.tadListener.onClosed(tAdNativeInfo);
        }
    }

    public void onRewarded() {
        AdLogUtil.Log().d("ad_flow", "TAdListenerAdapter --> on rewarded");
        if (this.tadListener != null) {
            LogUtils.d((String)"ad_flow", (Object[])new Object[]{"TAdListenerAdapter --> >>> onRewarded()"});
            this.tadListener.onRewarded();
        }
    }

    private void updateConfigShowInfo() {
        if (this.tBaseAd != null && !TextUtils.isEmpty((CharSequence)this.tBaseAd.mAdUnit)) {
            long l = System.currentTimeMillis();
            CloudControlConfig.CodeSeat codeSeat = f.f(this.tBaseAd.mAdUnit);
            if (codeSeat == null) {
                return;
            }
            codeSeat.setLastShowTime(l);
            long l2 = TimeUtil.getZeroClockTimestamp((long)l);
            long l3 = TimeUtil.getZeroClockForHour((long)l);
            if (codeSeat.getCurrentHourZeroClock() == l3) {
                codeSeat.setCurrentHourShowTimes(codeSeat.getCurrentHourShowTimes() + 1);
            } else {
                codeSeat.setCurrentHourShowTimes(1);
                codeSeat.setCurrentHourZeroClock(l3);
            }
            if (codeSeat.getTodayZeroClock() == l2) {
                codeSeat.setTodayShowTimes(codeSeat.getTodayShowTimes() + 1);
            } else {
                codeSeat.setTodayShowTimes(1);
                codeSeat.setTodayZeroClock(l2);
            }
            ConfigContentHelper.getInstance().updateConfig(codeSeat);
        }
    }
}

