/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.mediation.ad;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.cloud.hisavana.sdk.api.view.MediaView;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.hisavana.common.base.BaseNativeViewHolder;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.mediation.R;

public class TMediaView
extends FrameLayout {
    private static final ImageView.ScaleType[] v = new ImageView.ScaleType[]{ImageView.ScaleType.MATRIX, ImageView.ScaleType.FIT_XY, ImageView.ScaleType.FIT_START, ImageView.ScaleType.FIT_CENTER, ImageView.ScaleType.FIT_END, ImageView.ScaleType.CENTER, ImageView.ScaleType.CENTER_CROP, ImageView.ScaleType.CENTER_INSIDE};
    private ImageView.ScaleType w = ImageView.ScaleType.FIT_CENTER;

    public TMediaView(@NonNull Context context) {
        this(context, null);
    }

    public TMediaView(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public TMediaView(@NonNull Context context, @Nullable AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TMediaView, n, 0);
        int n2 = typedArray.getInt(R.styleable.TMediaView_sspScaleType, 3);
        if (n2 >= 0 && n2 < v.length) {
            this.w = v[n2];
        }
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        this.w = scaleType;
    }

    public void attachLayout(@NonNull BaseNativeViewHolder baseNativeViewHolder, TAdNativeInfo tAdNativeInfo) {
        if (baseNativeViewHolder == null) {
            return;
        }
        this.removeAllViews();
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        View view = baseNativeViewHolder.getMediaView(this.getContext(), tAdNativeInfo);
        layoutParams.gravity = 17;
        if (view != null) {
            this.addView(view, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void setMediaView(AdImage adImage) {
        View view = this.getMediaView();
        if (view == null) {
            AdLogUtil.Log().w("TMediaView", "childView is null");
            return;
        }
        if (view instanceof MediaView) {
            ((MediaView)view).setMediaView(adImage, this.w, false);
        }
        if (view instanceof com.google.android.gms.ads.nativead.MediaView) {
            ((com.google.android.gms.ads.nativead.MediaView)view).setImageScaleType(this.w);
        }
    }

    public View getMediaView() {
        if (this.getChildCount() > 0) {
            View view = this.getChildAt(0);
            return view;
        }
        return null;
    }
}

