/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.mediation.ad;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.cloud.hisavana.sdk.common.util.TimeUtil;
import com.cloud.hisavana.sdk.manager.NetStateManager;
import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.cloud.sdk.commonutil.util.RunTimer;
import com.hisavana.common.bean.AdCache;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.bean.TAdRequestBody;
import com.hisavana.common.constant.ComConstants;
import com.hisavana.common.interfacz.Iad;
import com.hisavana.common.manager.AdCacheManager;
import com.hisavana.common.mock.RecordTestInfo;
import com.hisavana.common.tracking.TrackingManager;
import com.hisavana.common.tracking.TrackingUtil;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.common.utils.MediaLogUtil;
import com.hisavana.mediation.ad.TAdListenerAdapter;
import com.hisavana.mediation.bean.CloudControlConfig;
import com.hisavana.mediation.config.TAdManager;
import com.hisavana.mediation.config.a;
import com.hisavana.mediation.config.f;
import com.hisavana.mediation.handler.CacheHandler;
import java.util.List;
import java.util.Random;

public abstract class TBaseAd<T extends Iad> {
    protected String mAdUnit = "";
    protected Context mContext = null;
    private RunTimer l;
    private CacheHandler m;
    private boolean n = false;
    private boolean isLoaded = false;
    protected CloudControlConfig.CodeSeat o;
    protected TAdListenerAdapter p;
    public int mFillSource;
    private boolean q;
    int r = 60000;
    private int s = 0;
    private long t = 0L;
    protected boolean u = false;
    private RunTimer.TimeOutCallback timeOutCallback = new RunTimer.TimeOutCallback(){

        public void isTimeOut() {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> Load ad is time out ");
            TBaseAd.this.clearCurrentAd();
            if (TBaseAd.this.p != null) {
                TBaseAd.this.p.onError(TAdErrorCode.MEDIAITON_TIME_OUT_ERROR);
            }
        }
    };
    private String v;
    private long time;
    private Bundle mBundle;

    protected TBaseAd(@NonNull Context context, String string2) {
        this.mAdUnit = string2;
        this.mContext = context.getApplicationContext();
        this.h();
    }

    protected TBaseAd(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
        this.h();
    }

    protected TBaseAd() {
    }

    public final void loadAd() {
        this.q = false;
        TrackingManager.trackTriggerStart((int)0);
        Preconditions.runOnMainThread((Preconditions.Callback)new Preconditions.Callback(){

            public void onRun() {
                TBaseAd.this.c();
            }
        });
    }

    public final void preload() {
        this.loadAd();
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setLoaded(boolean bl) {
        this.isLoaded = bl;
    }

    public int getSupportFlag() {
        return this.s;
    }

    private void c() {
        this.isLoaded = false;
        this.clearCurrentAd();
        this.n = true;
        if (this.u) {
            this.n = false;
            this.a(TAdErrorCode.ERROR_CURRENT_OBJECT_IS_DESTROYED);
            AdLogUtil.Log().w("ad_flow", "TBaseAd -->current object haved been destroyed");
            MediaLogUtil.e((String)"TBaseAd", (Object)"current object haved been destroyed");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)TAdManager.getAppId())) {
            this.n = false;
            this.a(TAdErrorCode.INVALID_AD_REQUESST);
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> Network request is invalid, the appId or appToken must be valid ----- Current app id is:" + TAdManager.getAppId());
            MediaLogUtil.e((String)"TBaseAd", (Object)"loadAdInternal,appId is empty");
            return;
        }
        this.o = f.g(this.mAdUnit);
        if (this.o == null) {
            MediaLogUtil.e((String)"TBaseAd", (Object)("loadAdInternal,config is null\uff1bcodeSeatId = " + this.mAdUnit));
            this.n = false;
            a.d(6);
            this.a(false, 2);
            int n = AdxPreferencesHelper.getInstance().getInt("cloud_config_error_code");
            if (n != 0) {
                this.a(ComConstants.transferCloudErrorCode((int)n));
            } else {
                this.a(TAdErrorCode.AD_UNIT_CONFIG_EMPTY);
            }
            return;
        }
        if (Boolean.FALSE.equals(this.o.getCloudControlEnable())) {
            MediaLogUtil.e((String)"TBaseAd", (Object)"loadAdInternal,config is closed");
            this.n = false;
            this.a(false, 2);
            this.a(TAdErrorCode.MEDIATION_CLOSE_ERROR);
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> current ad unit is close ");
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = TimeUtil.getZeroClockTimestamp((long)l);
        long l3 = TimeUtil.getZeroClockForHour((long)l);
        if (this.o.getAdShowCountLimitDay() == 0 || this.o.getAdShowCountLimitDay() != -1 && l2 == this.o.getTodayZeroClock() && this.o.getTodayShowTimes() >= this.o.getAdShowCountLimitDay()) {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> ad show times can not exceed day show max");
            MediaLogUtil.e((String)"TBaseAd", (Object)("ad show times reach the limit of day,day showTimes " + this.o.getAdShowCountLimitDay()));
            this.n = false;
            this.a(false, 3);
            this.a(TAdErrorCode.MEDIATION_AD_SHOW_TIMES_OUT_OF_DAY);
            return;
        }
        if (this.o.getAdShowCountLimitHour() == 0 || this.o.getAdShowCountLimitHour() != -1 && l3 == this.o.getCurrentHourZeroClock() && this.o.getCurrentHourShowTimes() >= this.o.getAdShowCountLimitHour()) {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> ad display has reached the limit of hours");
            MediaLogUtil.e((String)"TBaseAd", (Object)("ad display has reached the limit of hour,hour showTimes " + this.o.getAdShowCountLimitHour()));
            this.n = false;
            this.a(false, 4);
            this.a(TAdErrorCode.MEDIATION_AD_SHOW_TIMES_OUT_OF_HOUR);
            return;
        }
        long l4 = l - this.o.getLastShowTime();
        long l5 = l4 = l4 > 0L ? l4 : -l4;
        if ((long)this.o.getAdShowTimeInterval().intValue() != -1000L && l4 <= (long)this.o.getAdShowTimeInterval().intValue()) {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> ad display did not reach the interval");
            MediaLogUtil.e((String)"TBaseAd", (Object)("ad display did not reach the interval,time " + this.o.getAdShowTimeInterval()));
            this.n = false;
            this.a(false, 5);
            this.a(TAdErrorCode.MEDIATION_AD_SHOW_NOT_IN_INTERVAL);
            return;
        }
        this.s = this.a(this.o);
        this.e();
        if (!this.b(this.getAdType())) {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> code seat type does not match request type");
            MediaLogUtil.e((String)"TBaseAd", (Object)("code seat type does not match request type ---> " + this.o.getCodeSeatType()));
            this.n = false;
            this.a(false, 6);
            this.a(TAdErrorCode.ERROR_AD_TYPE_LOAD_INCONSISTENCY);
            return;
        }
        this.o = com.hisavana.mediation.c.a.d(this.o);
        if (!NetStateManager.checkNetworkState()) {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> net error ");
            MediaLogUtil.e((String)"TBaseAd", (Object)"net error");
            this.n = false;
            this.a(false, 1);
            Network network = this.d();
            CacheHandler cacheHandler = this.i();
            if (network != null && cacheHandler != null && cacheHandler.I()) {
                cacheHandler.setBundle(this.mBundle);
                cacheHandler.g(this.o.getAdRequestCount());
                boolean bl = cacheHandler.a(this.o, network);
                if (!bl) {
                    this.a(TAdErrorCode.NETWORK_ERROR);
                }
            } else {
                this.a(TAdErrorCode.NETWORK_ERROR);
            }
            return;
        }
        this.runTimerTask();
        this.f();
    }

    protected int a(CloudControlConfig.CodeSeat codeSeat) {
        int n = 0;
        if (codeSeat == null) {
            return n;
        }
        int n2 = codeSeat.getAdxShowRate();
        int n3 = codeSeat.getEwShowRate();
        Random random = new Random(System.currentTimeMillis());
        int n4 = Math.abs(random.nextInt() % 100);
        int n5 = Math.abs(random.nextInt() % 100);
        n = n4 < n2 && n5 < n3 ? 3 : (n4 < n2 ? 1 : (n5 < n3 ? 2 : 0));
        AdLogUtil.Log().d("TBaseAd", "randomSupportFlag nextInt1 " + n4 + " nextInt2 " + n5 + " adxShowRate " + n2 + " ewShowRate " + n3 + " hisavanaAdSupportFlag " + n);
        return n;
    }

    private Network d() {
        if (this.o != null && this.o.getNetworks() != null) {
            for (Network network : this.o.getNetworks()) {
                if (network == null || network.getSource() != 0) continue;
                return network;
            }
        }
        return null;
    }

    private final void e() {
        if (this.p == null) {
            this.m = null;
            return;
        }
        this.m = this.b();
        if (this.m != null) {
            this.m.a(this.p);
            this.m.a(this.l);
            this.m.setSupportFlag(this.s);
        }
    }

    private void f() {
        if (this.o == null) {
            MediaLogUtil.e((String)"TBaseAd", (Object)"startLoadMediation codeSeat is null");
            this.a(TAdErrorCode.AD_UNIT_CONFIG_EMPTY);
            return;
        }
        AdLogUtil.Log().i("ad_flow", "*----> TBaseAd - current cloudConfig is " + this.o.toString());
        List<Network> list = this.o.getNetworks();
        if (list == null || list.isEmpty()) {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> ad is empty ");
            MediaLogUtil.e((String)"TBaseAd", (Object)"startLoadMediation,network is empty");
            this.a(false, 7);
            this.a(TAdErrorCode.AD_IS_EMPTY);
            return;
        }
        this.a(false, 0);
        CacheHandler cacheHandler = this.i();
        if (cacheHandler != null) {
            cacheHandler.setBundle(this.mBundle);
            cacheHandler.a(this.mContext, this.o, 1);
        }
    }

    private void runTimerTask() {
        if (null != this.o) {
            this.r = this.o.getAdRequestTimeout() * 1000;
        }
        if (this.r > 0) {
            if (this.l == null) {
                this.l = new RunTimer();
            }
            this.l.resetTimerTask();
            this.l.setTimeOutCallback(this.timeOutCallback);
            this.l.setScheduleTime(this.r);
            this.l.runTimerTask();
        }
    }

    protected void clearCurrentAd() {
        if (this.n && this.m != null && this.m.K() == 1) {
            this.k();
        }
        this.stopTimer();
        if (this.m != null) {
            this.m.clearCurrentAd();
        }
        if (this.n) {
            AdLogUtil.Log().d("ad_flow", "cancel request ad ");
        }
    }

    protected TAdErrorCode b(CloudControlConfig.CodeSeat codeSeat) {
        if (codeSeat == null) {
            return TAdErrorCode.AD_UNIT_CONFIG_EMPTY;
        }
        if (!codeSeat.getCloudControlEnable().booleanValue()) {
            return TAdErrorCode.MEDIATION_CLOSE_ERROR;
        }
        if (!this.b(this.getAdType())) {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> code seat type does not match request type");
            MediaLogUtil.e((String)"TBaseAd", (Object)("code seat type does not match request type ---> " + this.o.getCodeSeatType()));
            return TAdErrorCode.ERROR_AD_TYPE_LOAD_INCONSISTENCY;
        }
        long l = System.currentTimeMillis();
        long l2 = TimeUtil.getZeroClockTimestamp((long)l);
        long l3 = TimeUtil.getZeroClockForHour((long)l);
        if (codeSeat.getAdShowCountLimitDay() == 0 || codeSeat.getAdShowCountLimitDay() != -1 && l2 == codeSeat.getTodayZeroClock() && codeSeat.getTodayShowTimes() >= codeSeat.getAdShowCountLimitDay()) {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> ad show times can not exceed day show max");
            MediaLogUtil.e((String)"TBaseAd", (Object)("ad show times reach the limit of day,day showTimes " + codeSeat.getAdShowCountLimitDay()));
            return TAdErrorCode.MEDIATION_AD_SHOW_TIMES_OUT_OF_DAY;
        }
        if (codeSeat.getAdShowCountLimitHour() == 0 || codeSeat.getAdShowCountLimitHour() != -1 && l3 == codeSeat.getCurrentHourZeroClock() && codeSeat.getCurrentHourShowTimes() >= codeSeat.getAdShowCountLimitHour()) {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> ad display has reached the limit of hours");
            MediaLogUtil.e((String)"TBaseAd", (Object)("ad display has reached the limit of hour,hour showTimes " + codeSeat.getAdShowCountLimitHour()));
            return TAdErrorCode.MEDIATION_AD_SHOW_TIMES_OUT_OF_HOUR;
        }
        long l4 = l - codeSeat.getLastShowTime();
        long l5 = l4 = l4 > 0L ? l4 : -l4;
        if ((long)codeSeat.getAdShowTimeInterval().intValue() != -1000L && l4 <= (long)codeSeat.getAdShowTimeInterval().intValue()) {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> ad display did not reach the interval");
            MediaLogUtil.e((String)"TBaseAd", (Object)("ad display did not reach the interval,time " + codeSeat.getAdShowTimeInterval()));
            return TAdErrorCode.MEDIATION_AD_SHOW_NOT_IN_INTERVAL;
        }
        return null;
    }

    public void setRequestBody(TAdRequestBody tAdRequestBody) {
        if (tAdRequestBody == null) {
            return;
        }
        this.h();
        this.r = tAdRequestBody.getScheduleTime();
        if (this.p != null) {
            this.p.setDispatchListener(tAdRequestBody.getAdListener());
        }
    }

    public void destroy() {
        Preconditions.runOnMainThread((Preconditions.Callback)new Preconditions.Callback(){

            public void onRun() {
                TBaseAd.this.onDestroy();
            }
        });
    }

    public void resume() {
        if (null != this.m) {
            this.m.resume();
        }
    }

    public void pause() {
        if (null != this.m) {
            this.m.pause();
        }
    }

    private void onDestroy() {
        if (this.p != null) {
            this.p.setDispatchListener(null);
            this.p.setSkipListener(null);
        }
        this.p = null;
        this.o = null;
        RecordTestInfo.destroy();
        this.clearCurrentAd();
        if (null != this.m) {
            this.m.destroy();
            this.m = null;
        }
        if (this.n) {
            this.trackingAdLoaded(TAdErrorCode.ERROR_DESTROY_REQUEST.getErrorCode(), TAdErrorCode.ERROR_DESTROY_REQUEST.getErrorMessage(), -1);
        }
        this.n = false;
        this.u = true;
    }

    public void stopTimer() {
        Preconditions.runOnMainThread((Preconditions.Callback)new Preconditions.Callback(){

            public void onRun() {
                TBaseAd.this.g();
            }
        });
    }

    private void g() {
        if (this.l != null) {
            this.l.resetTimerTask();
            this.l = null;
        }
    }

    public void setLoading(boolean bl) {
        this.n = bl;
    }

    protected void a(TAdErrorCode tAdErrorCode) {
        if (this.p != null) {
            this.p.onError(tAdErrorCode);
        }
    }

    protected void b(TAdErrorCode tAdErrorCode) {
        if (this.p != null) {
            this.p.onShowError(tAdErrorCode);
        }
    }

    protected void h() {
        if (this.p == null) {
            this.p = new TAdListenerAdapter(this);
        }
    }

    protected void a() {
    }

    protected abstract boolean b(int var1);

    protected abstract CacheHandler b();

    protected final CacheHandler i() {
        if (this.p == null) {
            return null;
        }
        if (this.m == null) {
            this.m = this.b();
            this.m.setSupportFlag(this.a(this.o));
        }
        return this.m;
    }

    public void enterScene(String string2) {
        this.a(string2);
    }

    public boolean hasAd() {
        if (this.u) {
            this.b(false, 3);
            AdLogUtil.Log().d("TBaseAd", "current object is destroyed");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.mAdUnit)) {
            this.b(false, 4);
            AdLogUtil.Log().d("TBaseAd", "isReady,mAdUnit is null");
            return false;
        }
        if (this.o == null) {
            this.o = f.g(this.mAdUnit);
        }
        if (this.o == null) {
            this.b(false, 5);
            AdLogUtil.Log().d("TBaseAd", "isReady,mCodeSeatConfig is null");
            return false;
        }
        AdCache adCache = AdCacheManager.getCache((int)this.o.getCodeSeatType());
        if (adCache == null) {
            this.b(false, 6);
            AdLogUtil.Log().d("TBaseAd", "isReady,no ad cache");
            return false;
        }
        boolean bl = adCache.hasAds(this.mAdUnit);
        AdLogUtil.Log().d("TBaseAd", "isReady key " + this.mAdUnit + " hasAd " + bl);
        this.b(bl, 0);
        return bl;
    }

    protected int getAdType() {
        return this.o == null ? -1 : this.o.getCodeSeatType();
    }

    protected void j() {
        if (null != this.p) {
            boolean bl = NetStateManager.checkNetworkState();
            if (bl) {
                this.trackingTriggerShowError(TAdErrorCode.ERROR_SHOW_ONLINE_NO_AD);
                this.p.onShowError(TAdErrorCode.ERROR_SHOW_ONLINE_NO_AD);
            } else {
                this.trackingTriggerShowError(TAdErrorCode.ERROR_SHOW_OFFLINE_NO_AD);
                this.p.onShowError(TAdErrorCode.ERROR_SHOW_OFFLINE_NO_AD);
            }
        }
    }

    private void a(boolean bl, int n) {
        this.v = TrackingUtil.getTriggerId();
        this.mBundle = new Bundle();
        this.mBundle.putString("trigger_id", this.v);
        this.time = System.currentTimeMillis();
        this.mBundle.putLong("trigger_ts", this.time);
        if (this.o != null) {
            int[] nArray;
            this.mBundle.putInt("ad_type", this.o.getCodeSeatType().intValue());
            int n2 = this.o.getCodeSeatType();
            AdCache adCache = AdCacheManager.getCache((int)n2);
            if (adCache != null && (nArray = adCache.getValidAndInvalidAdNum(this.mAdUnit)) != null && nArray.length >= 2) {
                int n3 = nArray[0];
                int n4 = nArray[1];
                this.mBundle.putInt("cache_valid_ads", n3);
                this.mBundle.putInt("cache_expire_ads", n4);
            }
            this.mBundle.putInt("multi_count", this.o.getAdRequestConcurrentCount().intValue());
            this.mBundle.putInt("bidding_duration", this.o.getBiddingWaitTime().intValue());
            this.mBundle.putString("traffic_group_id", this.o.getTrafficGroupId());
            this.mBundle.putString("experiment_group_id", this.o.getExperimentGroupId());
            this.mBundle.putInt("request_num", this.o.getCodeSeatType() == 6 ? this.o.getAdRequestCount() : 1);
        }
        this.mBundle.putString("app_id", TAdManager.getAppId());
        this.mBundle.putString("code_seat_id", this.mAdUnit);
        this.mBundle.putInt("is_pre_trigger", bl ? 1 : 0);
        this.mBundle.putString("cld_app_id", TAdManager.getAppId());
        this.mBundle.putString("cld_code_seat_id", this.mAdUnit);
        this.mBundle.putInt("ad_trigger_status", n);
        this.mBundle.putInt("priority_code", this.s);
        TrackingManager.trackingADTrigger((Bundle)this.mBundle);
    }

    public void trackingAdLoaded(int n, String string2, int n2) {
        if (this.mBundle == null) {
            AdLogUtil.Log().w("ad_flow", "mBundle is null");
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("trigger_id", this.mBundle.getString("trigger_id"));
        bundle.putLong("trigger_ts", this.mBundle.getLong("trigger_ts"));
        bundle.putInt("ad_type", this.mBundle.getInt("ad_type"));
        bundle.putInt("ad_trigger_status", this.mBundle.getInt("ad_trigger_status"));
        RecordTestInfo.record((String)"adTrackingFilling");
        bundle.putString("cld_app_id", this.mBundle.getString("app_id"));
        bundle.putString("cld_code_seat_id", this.mBundle.getString("code_seat_id"));
        bundle.putInt("is_timeout", 0);
        bundle.putInt("error_code", n);
        bundle.putString("error_message", string2);
        bundle.putInt("filling_source", n2);
        bundle.putLong("filling_ts", System.currentTimeMillis());
        bundle.putInt("installed_facebook", ComConstants.isFbAppExist ? 1 : 0);
        bundle.putInt("filter_count", this.m == null ? 0 : this.m.J());
        bundle.putInt("optimize_status", this.mBundle.getInt("optimize_status"));
        bundle.putInt("priority_code", this.mBundle.getInt("priority_code"));
        if (this.m != null) {
            bundle.putDouble("max_price", this.m.getMaxPrice());
        }
        if (AdLogUtil.isLogSwitchDebug()) {
            RecordTestInfo.LogMsg((String)("fill result code : " + n), (int)RecordTestInfo.LOG_CODE7);
        }
        TrackingManager.trackingAdLoaded((Bundle)bundle);
    }

    private void k() {
        if (null == this.mBundle) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("request_type", 1);
        bundle.putString("trigger_id", this.mBundle.getString("trigger_id"));
        bundle.putLong("trigger_ts", this.mBundle.getLong("trigger_ts"));
        bundle.putInt("ad_type", this.mBundle.getInt("ad_type"));
        bundle.putString("cld_app_id", this.mBundle.getString("cld_app_id"));
        bundle.putString("cld_code_seat_id", this.mBundle.getString("cld_code_seat_id"));
        bundle.putString("app_id", this.mBundle.getString("app_id"));
        bundle.putString("code_seat_id", this.mBundle.getString("code_seat_id"));
        bundle.putInt("is_retreatad", this.mBundle.getInt("is_retreatad"));
        bundle.putString("cld_configure_id", AdxPreferencesHelper.getInstance().getString("cloudControlVersion"));
        bundle.putInt("is_preload", this.mBundle.getInt("is_preload"));
        bundle.putString("traffic_group_id", this.mBundle.getString("traffic_group_id"));
        bundle.putString("experiment_group_id", this.mBundle.getString("experiment_group_id"));
        TrackingManager.trackingAdCancel((Bundle)bundle);
    }

    public void trackingTriggerShowError(TAdErrorCode tAdErrorCode) {
        Bundle bundle = new Bundle();
        try {
            if (this.mBundle != null) {
                bundle.putString("trigger_id", this.mBundle.getString("trigger_id"));
                bundle.putLong("trigger_ts", this.mBundle.getLong("trigger_ts"));
                bundle.putDouble("bidding_price", this.mBundle.getDouble("bidding_price"));
                bundle.putInt("platform", this.mBundle.getInt("platform"));
            }
            if (this.o == null) {
                this.o = f.g(this.mAdUnit);
            }
            bundle.putString("cld_app_id", TAdManager.getAppId());
            bundle.putString("app_id", TAdManager.getAppId());
            bundle.putString("code_seat_id", this.mAdUnit);
            bundle.putString("cld_code_seat_id", this.mAdUnit);
            bundle.putInt("ad_type", this.getAdType());
            if (this.o != null) {
                bundle.putString("traffic_group_id", this.o.getTrafficGroupId());
                bundle.putString("experiment_group_id", this.o.getExperimentGroupId());
            }
            if (tAdErrorCode != null) {
                bundle.putString("error_code", String.valueOf(tAdErrorCode.getErrorCode()));
                bundle.putString("error_message", tAdErrorCode.getErrorMessage());
            }
            TrackingManager.trackingTrigerShow((Bundle)bundle);
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("ad_flow", Log.getStackTraceString((Throwable)exception));
        }
    }

    private void a(String string2) {
        Bundle bundle = new Bundle();
        bundle.putString("scene_id", string2 == null ? "" : string2);
        if (this.o == null) {
            this.o = f.g(this.mAdUnit);
        }
        if (this.o == null) {
            bundle.putInt("cache_status", 1);
        } else {
            AdCache adCache = AdCacheManager.getCache((int)this.o.getCodeSeatType());
            if (adCache != null) {
                boolean bl = adCache.hasAds(this.mAdUnit);
                if (bl) {
                    bundle.putInt("cache_status", 0);
                } else {
                    bundle.putInt("cache_status", this.n ? 2 : 1);
                }
            }
        }
        bundle.putString("cld_code_seat_id", this.mAdUnit);
        bundle.putString("cld_app_id", TAdManager.getAppId());
        bundle.putLong("ts", System.currentTimeMillis());
        TrackingManager.trackEnterScene((Bundle)bundle);
    }

    private void b(boolean bl, int n) {
        long l = System.currentTimeMillis();
        if (l - this.t < 1000L) {
            AdLogUtil.Log().e("TBaseAd", "isReady interval time is not fit");
            return;
        }
        this.t = l;
        Bundle bundle = new Bundle();
        if (bl) {
            n = this.isLoaded ? 1 : 2;
        }
        bundle.putInt("is_ready_status", n);
        bundle.putString("cld_code_seat_id", this.mAdUnit);
        bundle.putString("cld_app_id", TAdManager.getAppId());
        bundle.putLong("ts", System.currentTimeMillis());
        TrackingManager.trackIsReady((Bundle)bundle);
    }
}

