/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.mediation.ad;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.cloud.hisavana.sdk.common.util.TimeUtil;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.interfacz.OnSkipListener;
import com.hisavana.common.interfacz.TAdListener;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.mediation.ad.TBaseAd;
import com.hisavana.mediation.bean.CloudControlConfig;
import com.hisavana.mediation.config.ConfigContentHelper;
import com.hisavana.mediation.config.a;
import com.hisavana.mediation.config.f;
import com.hisavana.mediation.handler.CacheHandler;
import com.transsion.core.log.LogUtils;

public class TAdListenerAdapter
extends TAdListener {
    private static final String TAG = "TAdListenerAdapter";
    private TBaseAd tBaseAd;
    private TAdListener tadListener;
    private OnSkipListener skipListener;
    private int mFillSource;

    public void setFillSource(int n) {
        this.mFillSource = n;
    }

    public TAdListenerAdapter(@NonNull TBaseAd tBaseAd) {
        this.tBaseAd = tBaseAd;
    }

    public void setDispatchListener(TAdListener tAdListener) {
        this.tadListener = tAdListener;
    }

    public TAdListener getDispatchListener() {
        return this.tadListener;
    }

    public void setSkipListener(OnSkipListener onSkipListener) {
        this.skipListener = onSkipListener;
    }

    public void onSkipClick() {
        if (this.skipListener != null) {
            this.skipListener.onClick();
        }
        if (this.tBaseAd != null) {
            this.tBaseAd.setIsShowing(false);
        }
    }

    public void onTimeReach() {
        if (this.skipListener != null) {
            this.skipListener.onTimeReach();
        }
        if (this.tBaseAd != null) {
            this.tBaseAd.setIsShowing(false);
        }
    }

    public void onAdLoad() {
        AdLogUtil.Log().d("ad_flow", "*----> TAdListenerAdapter --> on alliance ad load");
        if (this.tBaseAd == null || this.tadListener == null) {
            return;
        }
        AdLogUtil.Log().d("ad_flow", "*----> TAdListenerAdapter --> >>> onLoad()");
        this.tBaseAd.stopTimer();
        this.tBaseAd.setLoading(false);
        this.tBaseAd.mFillSource = this.mFillSource;
        CacheHandler cacheHandler = this.tBaseAd.m();
        double d2 = 0.0;
        if (cacheHandler != null) {
            d2 = cacheHandler.ae();
        }
        this.tBaseAd.trackingAdLoaded(0, "", this.mFillSource);
        this.onLoad();
        a.d(3);
    }

    public void onLoad() {
        if (this.tadListener != null) {
            this.tadListener.onLoad();
        }
        if (this.tBaseAd != null) {
            this.tBaseAd.a();
            this.tBaseAd.setLoaded(true);
        }
    }

    public void onError(TAdErrorCode tAdErrorCode) {
        if (this.tBaseAd == null || this.tadListener == null) {
            return;
        }
        int n = tAdErrorCode != null ? tAdErrorCode.getErrorCode() : -1;
        String string2 = tAdErrorCode != null ? tAdErrorCode.getErrorMessage() : "";
        AdLogUtil.Log().d("ad_flow", "TAdListenerAdapter --> on alliance error: " + string2);
        this.tBaseAd.stopTimer();
        this.tBaseAd.setLoading(false);
        this.tBaseAd.setLoaded(false);
        this.tBaseAd.trackingAdLoaded(n, string2, this.mFillSource);
        this.tadListener.onError(tAdErrorCode);
        if (n == 20001) {
            a.d(3);
        }
    }

    public void onShow(int n) {
        AdLogUtil.Log().d(TAG, "onShow");
    }

    public void onNativeFeedShow(int n, TAdNativeInfo tAdNativeInfo) {
        AdLogUtil.Log().d("ad_flow", "TAdListenerAdapter --> on show");
        this.updateConfigShowInfo();
        if (this.tadListener != null) {
            LogUtils.d((String)"ad_flow", (Object[])new Object[]{"TAdListenerAdapter --> >>> onShow()"});
            this.tadListener.onNativeFeedShow(n, tAdNativeInfo);
            this.tadListener.onShow(n);
        }
        if (this.tBaseAd != null) {
            this.tBaseAd.setIsShowing(true);
        }
    }

    public void onShowError(TAdErrorCode tAdErrorCode) {
        AdLogUtil.Log().d("ad_flow", "TAdListenerAdapter --> on onAdShowError\uff0cerrorCode" + tAdErrorCode != null ? tAdErrorCode.getErrorMessage() : "");
        if (this.tadListener != null) {
            LogUtils.d((String)"ad_flow", (Object[])new Object[]{"TAdListenerAdapter --> >>> onAdShowError()"});
            this.tadListener.onShowError(tAdErrorCode);
        }
        if (this.tBaseAd != null) {
            this.tBaseAd.setIsShowing(false);
        }
    }

    public void onClicked(int n) {
        AdLogUtil.Log().d(TAG, "onClicked");
    }

    public void onNativeFeedClicked(int n, TAdNativeInfo tAdNativeInfo) {
        AdLogUtil.Log().d("ad_flow", "TAdListenerAdapter --> on click");
        if (this.tadListener != null) {
            LogUtils.d((String)"ad_flow", (Object[])new Object[]{"TAdListenerAdapter --> >>> onClicked()"});
            this.tadListener.onNativeFeedClicked(n, tAdNativeInfo);
            this.tadListener.onClicked(n);
        }
    }

    public void onClosed(int n) {
        AdLogUtil.Log().d("ad_flow", "TAdListenerAdapter --> on close");
        if (this.tadListener != null) {
            LogUtils.d((String)"ad_flow", (Object[])new Object[]{"TAdListenerAdapter --> >>> onClosed()"});
            this.tadListener.onClosed(n);
        }
        if (this.tBaseAd != null) {
            this.tBaseAd.setIsShowing(false);
        }
    }

    public void onClosed(TAdNativeInfo tAdNativeInfo) {
        AdLogUtil.Log().d("ad_flow", "TAdListenerAdapter --> on close");
        if (this.tadListener != null) {
            LogUtils.d((String)"ad_flow", (Object[])new Object[]{"TAdListenerAdapter --> >>> onClosed()"});
            this.tadListener.onClosed(tAdNativeInfo);
        }
        if (this.tBaseAd != null) {
            this.tBaseAd.setIsShowing(false);
        }
    }

    public void onRewarded() {
        AdLogUtil.Log().d("ad_flow", "TAdListenerAdapter --> on rewarded");
        if (this.tadListener != null) {
            LogUtils.d((String)"ad_flow", (Object[])new Object[]{"TAdListenerAdapter --> >>> onRewarded()"});
            this.tadListener.onRewarded();
        }
    }

    private void updateConfigShowInfo() {
        if (this.tBaseAd != null && !TextUtils.isEmpty((CharSequence)this.tBaseAd.m)) {
            long l = System.currentTimeMillis();
            CloudControlConfig.CodeSeat codeSeat = f.f(this.tBaseAd.m);
            if (codeSeat == null) {
                return;
            }
            codeSeat.setLastShowTime(l);
            long l2 = TimeUtil.getZeroClockTimestamp((long)l);
            long l3 = TimeUtil.getZeroClockForHour((long)l);
            if (codeSeat.getCurrentHourZeroClock() == l3) {
                codeSeat.setCurrentHourShowTimes(codeSeat.getCurrentHourShowTimes() + 1);
            } else {
                codeSeat.setCurrentHourShowTimes(1);
                codeSeat.setCurrentHourZeroClock(l3);
            }
            if (codeSeat.getTodayZeroClock() == l2) {
                codeSeat.setTodayShowTimes(codeSeat.getTodayShowTimes() + 1);
            } else {
                codeSeat.setTodayShowTimes(1);
                codeSeat.setTodayZeroClock(l2);
            }
            ConfigContentHelper.getInstance().updateConfig(codeSeat);
        }
    }
}

