/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.mediation.ad;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.cloud.hisavana.sdk.common.util.TimeUtil;
import com.cloud.hisavana.sdk.manager.NetStateManager;
import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;
import com.cloud.sdk.commonutil.util.DeviceUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.cloud.sdk.commonutil.util.RunTimer;
import com.hisavana.common.base.LogSwitch;
import com.hisavana.common.bean.AdCache;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.bean.TAdRequestBody;
import com.hisavana.common.constant.ComConstants;
import com.hisavana.common.interfacz.Iad;
import com.hisavana.common.manager.AdCacheManager;
import com.hisavana.common.mock.RecordTestInfo;
import com.hisavana.common.tracking.TrackingManager;
import com.hisavana.common.tracking.TrackingUtil;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.common.utils.MediaLogUtil;
import com.hisavana.common.utils.ThreadUtils;
import com.hisavana.mediation.ad.TAdListenerAdapter;
import com.hisavana.mediation.bean.CloudControlConfig;
import com.hisavana.mediation.config.TAdManager;
import com.hisavana.mediation.config.a;
import com.hisavana.mediation.config.f;
import com.hisavana.mediation.handler.CacheHandler;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class TBaseAd<T extends Iad> {
    protected volatile String m = "";
    protected Context n = null;
    private volatile RunTimer o;
    private CacheHandler p;
    private final AtomicBoolean q = new AtomicBoolean(false);
    private final AtomicBoolean r = new AtomicBoolean(false);
    protected volatile TAdListenerAdapter s;
    public int mFillSource;
    private boolean t;
    int u = 60000;
    private int v = 0;
    private long w = 0L;
    protected boolean x = false;
    private final LinkedHashMap<String, String> y = new LinkedHashMap();
    protected int z;
    protected AtomicBoolean A = new AtomicBoolean(false);
    private final RunTimer.TimeOutCallback B = new RunTimer.TimeOutCallback(){

        public void isTimeOut() {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> Load ad is time out ");
            TBaseAd.this.clearCurrentAd();
            if (TBaseAd.this.s != null) {
                TBaseAd.this.s.onError(TAdErrorCode.ERROR_FILL_FAILED_WITH_MEDIATION_TIME_OUT);
            }
        }
    };
    private String C;
    private long D;
    private Bundle E;

    protected TBaseAd(@NonNull Context context, String string2) {
        this.m = string2;
        this.n = context.getApplicationContext();
        this.l();
    }

    protected TBaseAd(@NonNull Context context) {
        this.n = context.getApplicationContext();
        this.l();
    }

    protected TBaseAd() {
    }

    public final void loadAd() {
        this.t = false;
        TrackingManager.trackTriggerStart((int)0);
        ThreadUtils.runOnWorkThread(() -> this.e());
    }

    public final void preload() {
        this.loadAd();
    }

    public boolean isLoaded() {
        return this.r.get();
    }

    public void setLoaded(boolean bl) {
        this.r.set(bl);
    }

    public int getSupportFlag() {
        return this.v;
    }

    private void e() {
        if (this.A.get() && !this.b()) {
            this.a(TAdErrorCode.ERROR_CODE_AD_IS_SHOWING);
            return;
        }
        this.r.set(false);
        this.clearCurrentAd();
        this.q.set(true);
        if (this.x) {
            this.r.set(false);
            this.a(TAdErrorCode.ERROR_CURRENT_OBJECT_IS_DESTROYED);
            AdLogUtil.Log().w("ad_flow", "TBaseAd -->current object haved been destroyed");
            MediaLogUtil.e((String)"TBaseAd", (Object)"current object haved been destroyed");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)TAdManager.getAppId())) {
            this.q.set(false);
            this.a(TAdErrorCode.ERROR_INVALID_APP_ID);
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> Network request is invalid, the appId or appToken must be valid ----- Current app id is:" + TAdManager.getAppId());
            MediaLogUtil.e((String)"TBaseAd", (Object)"loadAdInternal,appId is empty");
            return;
        }
        CloudControlConfig.CodeSeat codeSeat = f.f(this.m);
        if (codeSeat == null) {
            MediaLogUtil.e((String)"TBaseAd", (Object)("loadAdInternal,config is null\uff1bcodeSeatId = " + this.m));
            this.q.set(false);
            a.d(6);
            this.a(false, 2);
            int n = AdxPreferencesHelper.getInstance().getInt("cloud_config_error_code");
            if (n != 0) {
                this.a(ComConstants.transferCloudErrorCode((int)n));
            } else {
                this.a(TAdErrorCode.ERROR_AD_UNIT_CONFIG_EMPTY);
            }
            return;
        }
        this.z = codeSeat.getCodeSeatType();
        if (Boolean.FALSE.equals(codeSeat.getCloudControlEnable())) {
            MediaLogUtil.e((String)"TBaseAd", (Object)"loadAdInternal,config is closed");
            this.q.set(false);
            this.a(false, 2);
            this.a(TAdErrorCode.ERROR_CLOUD_AD_SEAT_IS_CLOSED);
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> current ad unit is close ");
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = TimeUtil.getZeroClockTimestamp((long)l);
        long l3 = TimeUtil.getZeroClockForHour((long)l);
        if (codeSeat.getAdShowCountLimitDay() == 0 || codeSeat.getAdShowCountLimitDay() != -1 && l2 == codeSeat.getTodayZeroClock() && codeSeat.getTodayShowTimes() >= codeSeat.getAdShowCountLimitDay()) {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> ad show times can not exceed day show max");
            MediaLogUtil.e((String)"TBaseAd", (Object)("ad show times reach the limit of day,day showTimes " + codeSeat.getAdShowCountLimitDay()));
            this.q.set(false);
            this.a(false, 3);
            this.a(TAdErrorCode.ERROR_AD_SHOW_TIMES_OUT_OF_DAY);
            return;
        }
        if (codeSeat.getAdShowCountLimitHour() == 0 || codeSeat.getAdShowCountLimitHour() != -1 && l3 == codeSeat.getCurrentHourZeroClock() && codeSeat.getCurrentHourShowTimes() >= codeSeat.getAdShowCountLimitHour()) {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> ad display has reached the limit of hours");
            MediaLogUtil.e((String)"TBaseAd", (Object)("ad display has reached the limit of hour,hour showTimes " + codeSeat.getAdShowCountLimitHour()));
            this.q.set(false);
            this.a(false, 4);
            this.a(TAdErrorCode.ERROR_AD_SHOW_TIMES_OUT_OF_HOUR);
            return;
        }
        long l4 = l - codeSeat.getLastShowTime();
        long l5 = l4 = l4 > 0L ? l4 : -l4;
        if ((long)codeSeat.getAdShowTimeInterval().intValue() != -1000L && l4 <= (long)codeSeat.getAdShowTimeInterval().intValue()) {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> ad display did not reach the interval");
            MediaLogUtil.e((String)"TBaseAd", (Object)("ad display did not reach the interval,time " + codeSeat.getAdShowTimeInterval()));
            this.q.set(false);
            this.a(false, 5);
            this.a(TAdErrorCode.ERROR_AD_SHOW_NOT_IN_INTERVAL);
            return;
        }
        this.v = this.a(codeSeat);
        this.g();
        if (!this.b(this.n())) {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> code seat type does not match request type");
            MediaLogUtil.e((String)"TBaseAd", (Object)("code seat type does not match request type ---> " + codeSeat.getCodeSeatType()));
            this.q.set(false);
            this.a(false, 6);
            this.a(TAdErrorCode.ERROR_AD_TYPE_LOAD_INCONSISTENCY);
            return;
        }
        if (!NetStateManager.checkNetworkState()) {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> net error ");
            MediaLogUtil.e((String)"TBaseAd", (Object)"net error");
            this.q.set(false);
            this.a(false, 1);
            Network network = this.f();
            CacheHandler cacheHandler = this.m();
            if (network != null && cacheHandler != null && cacheHandler.V()) {
                cacheHandler.a(this.E);
                cacheHandler.g(codeSeat.getAdRequestCount());
                boolean bl = cacheHandler.a(codeSeat, network);
                if (!bl) {
                    this.a(TAdErrorCode.ERROR_FILL_FAILED_WITH_NETWORK_EXCEPTION);
                }
            } else {
                this.a(TAdErrorCode.ERROR_FILL_FAILED_WITH_NETWORK_EXCEPTION);
            }
            return;
        }
        this.i();
        this.h();
    }

    protected int a(CloudControlConfig.CodeSeat codeSeat) {
        int n = 0;
        if (codeSeat == null) {
            return n;
        }
        int n2 = codeSeat.getAdxShowRate();
        int n3 = codeSeat.getEwShowRate();
        Random random = new Random(System.currentTimeMillis());
        int n4 = Math.abs(random.nextInt() % 100);
        int n5 = Math.abs(random.nextInt() % 100);
        n = n4 < n2 && n5 < n3 ? 3 : (n4 < n2 ? 1 : (n5 < n3 ? 2 : 0));
        AdLogUtil.Log().d("TBaseAd", "randomSupportFlag nextInt1 " + n4 + " nextInt2 " + n5 + " adxShowRate " + n2 + " ewShowRate " + n3 + " hisavanaAdSupportFlag " + n);
        return n;
    }

    public void setIsShowing(boolean bl) {
        this.A.set(bl);
    }

    protected abstract boolean b();

    private Network f() {
        CloudControlConfig.CodeSeat codeSeat = f.f(this.m);
        if (codeSeat != null && codeSeat.getNetworks() != null) {
            for (Network network : codeSeat.getNetworks()) {
                if (network == null || network.getSource() != 0) continue;
                return network;
            }
        }
        return null;
    }

    private final void g() {
        if (this.s == null) {
            this.p = null;
            return;
        }
        this.p = this.d();
        if (this.p != null) {
            this.p.a(this.s);
            this.p.a(this.o);
            this.p.k(this.v);
        }
    }

    private void h() {
        CloudControlConfig.CodeSeat codeSeat = f.f(this.m);
        if (codeSeat == null) {
            MediaLogUtil.e((String)"TBaseAd", (Object)"startLoadMediation codeSeat is null");
            this.a(TAdErrorCode.ERROR_AD_UNIT_CONFIG_EMPTY);
            return;
        }
        AdLogUtil.Log().i("ad_flow", "*----> TBaseAd - current cloudConfig is " + codeSeat.toString());
        List<Network> list = codeSeat.getNetworks();
        if (list == null || list.isEmpty()) {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> ad is empty ");
            MediaLogUtil.e((String)"TBaseAd", (Object)"startLoadMediation,network is empty");
            this.a(false, 7);
            this.a(TAdErrorCode.ERROR_AD_SOURCE_LIST_IS_EMPTY);
            return;
        }
        this.a(false, 0);
        CacheHandler cacheHandler = this.m();
        if (cacheHandler != null) {
            cacheHandler.a(this.E);
            cacheHandler.a(this.n, codeSeat, 1);
        }
    }

    private void i() {
        CloudControlConfig.CodeSeat codeSeat = f.f(this.m);
        if (null != codeSeat) {
            this.u = codeSeat.getAdRequestTimeout() * 1000;
        }
        if (this.u > 0) {
            if (this.o == null) {
                this.o = new RunTimer();
            }
            this.o.cancelTimeTask();
            this.o.setTimeOutCallback(this.B);
            this.o.setScheduleTime(this.u);
            this.o.runTimerTask();
        }
    }

    protected void clearCurrentAd() {
        if (this.q.get() && this.p != null && this.p.X() == 1) {
            this.p();
        }
        this.stopTimer();
        if (this.p != null) {
            this.p.clearCurrentAd();
        }
        this.setIsShowing(false);
        if (this.q.get()) {
            AdLogUtil.Log().d("ad_flow", "cancel request ad ");
        }
    }

    protected TAdErrorCode b(CloudControlConfig.CodeSeat codeSeat) {
        if (codeSeat == null) {
            return TAdErrorCode.ERROR_AD_UNIT_CONFIG_EMPTY;
        }
        if (!codeSeat.getCloudControlEnable().booleanValue()) {
            return TAdErrorCode.ERROR_CLOUD_AD_SEAT_IS_CLOSED;
        }
        this.z = codeSeat.getCodeSeatType();
        if (!this.b(codeSeat.getCodeSeatType())) {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> code seat type does not match request type");
            MediaLogUtil.e((String)"TBaseAd", (Object)("code seat type does not match request type ---> " + codeSeat.getCodeSeatType()));
            return TAdErrorCode.ERROR_AD_TYPE_LOAD_INCONSISTENCY;
        }
        long l = System.currentTimeMillis();
        long l2 = TimeUtil.getZeroClockTimestamp((long)l);
        long l3 = TimeUtil.getZeroClockForHour((long)l);
        if (codeSeat.getAdShowCountLimitDay() == 0 || codeSeat.getAdShowCountLimitDay() != -1 && l2 == codeSeat.getTodayZeroClock() && codeSeat.getTodayShowTimes() >= codeSeat.getAdShowCountLimitDay()) {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> ad show times can not exceed day show max");
            MediaLogUtil.e((String)"TBaseAd", (Object)("ad show times reach the limit of day,day showTimes " + codeSeat.getAdShowCountLimitDay()));
            return TAdErrorCode.ERROR_AD_SHOW_TIMES_OUT_OF_DAY;
        }
        if (codeSeat.getAdShowCountLimitHour() == 0 || codeSeat.getAdShowCountLimitHour() != -1 && l3 == codeSeat.getCurrentHourZeroClock() && codeSeat.getCurrentHourShowTimes() >= codeSeat.getAdShowCountLimitHour()) {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> ad display has reached the limit of hours");
            MediaLogUtil.e((String)"TBaseAd", (Object)("ad display has reached the limit of hour,hour showTimes " + codeSeat.getAdShowCountLimitHour()));
            return TAdErrorCode.ERROR_AD_SHOW_TIMES_OUT_OF_HOUR;
        }
        long l4 = l - codeSeat.getLastShowTime();
        long l5 = l4 = l4 > 0L ? l4 : -l4;
        if ((long)codeSeat.getAdShowTimeInterval().intValue() != -1000L && l4 <= (long)codeSeat.getAdShowTimeInterval().intValue()) {
            AdLogUtil.Log().w("ad_flow", "TBaseAd --> ad display did not reach the interval");
            MediaLogUtil.e((String)"TBaseAd", (Object)("ad display did not reach the interval,time " + codeSeat.getAdShowTimeInterval()));
            return TAdErrorCode.ERROR_AD_SHOW_NOT_IN_INTERVAL;
        }
        return null;
    }

    public void setRequestBody(TAdRequestBody tAdRequestBody) {
        if (tAdRequestBody == null) {
            return;
        }
        this.l();
        this.u = tAdRequestBody.getScheduleTime();
        if (this.s != null) {
            this.s.setDispatchListener(tAdRequestBody.getAdListener());
        }
    }

    public void destroy() {
        ThreadUtils.runOnUiThread(() -> this.j());
    }

    public void resume() {
        if (null != this.p) {
            this.p.resume();
        }
    }

    public void pause() {
        if (null != this.p) {
            this.p.pause();
        }
    }

    private void j() {
        if (this.s != null) {
            this.s.setDispatchListener(null);
            this.s.setSkipListener(null);
        }
        this.s = null;
        RecordTestInfo.destroy();
        this.setIsShowing(false);
        this.clearCurrentAd();
        if (null != this.p) {
            this.p.destroy();
            this.p = null;
        }
        if (this.q.get()) {
            this.trackingAdLoaded(60002, TAdErrorCode.ERROR_CURRENT_OBJECT_IS_DESTROYED.getErrorMessage(), -1);
        }
        this.q.set(false);
        this.x = true;
    }

    public void stopTimer() {
        ThreadUtils.runOnWorkThread(() -> this.k());
    }

    private void k() {
        if (this.o != null) {
            this.o.cancelTimeTask();
            this.o = null;
        }
    }

    public void setLoading(boolean bl) {
        this.q.set(bl);
    }

    protected void a(TAdErrorCode tAdErrorCode) {
        if (this.s != null) {
            this.s.onError(tAdErrorCode);
        }
    }

    protected void b(TAdErrorCode tAdErrorCode) {
        if (this.s != null) {
            this.s.onShowError(tAdErrorCode);
        }
    }

    protected void l() {
        if (this.s == null) {
            this.s = new TAdListenerAdapter(this);
        }
    }

    protected void a() {
    }

    protected abstract boolean b(int var1);

    protected abstract CacheHandler d();

    protected final CacheHandler m() {
        if (this.s == null) {
            return null;
        }
        if (this.p == null) {
            this.p = this.d();
            CloudControlConfig.CodeSeat codeSeat = f.f(this.m);
            this.p.k(this.a(codeSeat));
        }
        return this.p;
    }

    public String enterScene(String string2, int n) {
        Iterator<String> iterator;
        Preconditions.checkIsOnMainThread();
        String string3 = DeviceUtil.getUUID();
        this.a(string3, string2, n);
        if (this.y.size() >= 24 && (iterator = this.y.keySet().iterator()).hasNext()) {
            this.y.remove(iterator.next());
        }
        this.y.put(string3, string2);
        return string3;
    }

    public boolean hasAd() {
        if (this.x) {
            this.b(false, 3);
            AdLogUtil.Log().d("TBaseAd", "current object is destroyed");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.m)) {
            this.b(false, 4);
            AdLogUtil.Log().d("TBaseAd", "isReady,mAdUnit is null");
            return false;
        }
        CloudControlConfig.CodeSeat codeSeat = f.f(this.m);
        if (codeSeat == null) {
            this.b(false, 5);
            AdLogUtil.Log().d("TBaseAd", "isReady,mCodeSeatConfig is null");
            return false;
        }
        AdCache adCache = AdCacheManager.getCache((int)codeSeat.getCodeSeatType());
        if (adCache == null) {
            this.b(false, 6);
            AdLogUtil.Log().d("TBaseAd", "isReady,no ad cache");
            return false;
        }
        boolean bl = adCache.hasAds(this.m);
        AdLogUtil.Log().d("TBaseAd", "isReady key " + this.m + " hasAd " + bl);
        this.b(bl, 0);
        return bl;
    }

    protected String a(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        return this.y.get(string2);
    }

    protected int n() {
        return this.z;
    }

    public void setCodeSeatType(int n) {
        this.z = n;
    }

    protected void o() {
        if (null != this.s) {
            boolean bl = NetStateManager.checkNetworkState();
            if (bl) {
                this.trackingTriggerShowError(TAdErrorCode.ERROR_TRIGGER_SHOW_ONLINE_NO_AD);
                this.s.onShowError(TAdErrorCode.ERROR_TRIGGER_SHOW_ONLINE_NO_AD);
            } else {
                this.trackingTriggerShowError(TAdErrorCode.ERROR_RIGGER_SHOW_OFFLINE_NO_AD);
                this.s.onShowError(TAdErrorCode.ERROR_RIGGER_SHOW_OFFLINE_NO_AD);
            }
        }
    }

    private void a(boolean bl, int n) {
        this.C = TrackingUtil.getTriggerId();
        this.E = new Bundle();
        this.E.putString("trigger_id", this.C);
        this.D = System.currentTimeMillis();
        this.E.putLong("trigger_ts", this.D);
        CloudControlConfig.CodeSeat codeSeat = f.f(this.m);
        if (codeSeat != null) {
            int[] nArray;
            CloudControlConfig.CodeSeat codeSeat2 = codeSeat;
            this.E.putInt("ad_type", codeSeat2.getCodeSeatType().intValue());
            int n2 = codeSeat2.getCodeSeatType();
            AdCache adCache = AdCacheManager.getCache((int)n2);
            if (adCache != null && (nArray = adCache.getValidAndInvalidAdNum(this.m)) != null && nArray.length >= 2) {
                int n3 = nArray[0];
                int n4 = nArray[1];
                this.E.putInt("cache_valid_ads", n3);
                this.E.putInt("cache_expire_ads", n4);
            }
            this.E.putInt("multi_count", codeSeat2.getAdRequestConcurrentCount().intValue());
            this.E.putInt("bidding_duration", codeSeat2.getBiddingWaitTime().intValue());
            this.E.putString("traffic_group_id", codeSeat2.getTrafficGroupId());
            this.E.putString("experiment_group_id", codeSeat2.getExperimentGroupId());
            this.E.putInt("request_num", codeSeat2.getCodeSeatType() == 6 ? codeSeat2.getAdRequestCount() : 1);
        }
        this.E.putString("app_id", TAdManager.getAppId());
        this.E.putString("code_seat_id", this.m);
        this.E.putInt("is_pre_trigger", bl ? 1 : 0);
        this.E.putString("cld_app_id", TAdManager.getAppId());
        this.E.putString("cld_code_seat_id", this.m);
        this.E.putInt("ad_trigger_status", n);
        this.E.putInt("priority_code", this.v);
        TrackingManager.trackingADTrigger((Bundle)this.E);
    }

    public void trackingAdLoaded(int n, String string2, int n2) {
        if (this.E == null) {
            AdLogUtil.Log().w("ad_flow", "mBundle is null");
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("trigger_id", this.E.getString("trigger_id"));
        bundle.putLong("trigger_ts", this.E.getLong("trigger_ts"));
        bundle.putInt("ad_type", this.E.getInt("ad_type"));
        bundle.putInt("ad_trigger_status", this.E.getInt("ad_trigger_status"));
        RecordTestInfo.record((String)"adTrackingFilling");
        bundle.putString("cld_app_id", this.E.getString("app_id"));
        bundle.putString("cld_code_seat_id", this.E.getString("code_seat_id"));
        bundle.putInt("is_timeout", 0);
        bundle.putInt("error_code", n);
        bundle.putString("error_message", string2);
        bundle.putInt("filling_source", n2);
        bundle.putLong("filling_ts", System.currentTimeMillis());
        bundle.putInt("installed_facebook", ComConstants.isFbAppExist ? 1 : 0);
        bundle.putInt("filter_count", this.p == null ? 0 : this.p.W());
        bundle.putInt("optimize_status", this.E.getInt("optimize_status"));
        bundle.putInt("priority_code", this.E.getInt("priority_code"));
        if (this.p != null) {
            bundle.putDouble("max_price", this.p.ah());
        }
        if (LogSwitch.isDebug) {
            RecordTestInfo.LogMsg((String)("fill result code : " + n), (int)RecordTestInfo.LOG_CODE7);
        }
        TrackingManager.trackingAdLoaded((Bundle)bundle);
    }

    private void p() {
        if (null == this.E) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("request_type", 1);
        bundle.putString("trigger_id", this.E.getString("trigger_id"));
        bundle.putLong("trigger_ts", this.E.getLong("trigger_ts"));
        bundle.putInt("ad_type", this.E.getInt("ad_type"));
        bundle.putString("cld_app_id", this.E.getString("cld_app_id"));
        bundle.putString("cld_code_seat_id", this.E.getString("cld_code_seat_id"));
        bundle.putString("app_id", this.E.getString("app_id"));
        bundle.putString("code_seat_id", this.E.getString("code_seat_id"));
        bundle.putInt("is_retreatad", this.E.getInt("is_retreatad"));
        bundle.putString("cld_configure_id", AdxPreferencesHelper.getInstance().getString("cloudControlVersion"));
        bundle.putInt("is_preload", this.E.getInt("is_preload"));
        bundle.putString("traffic_group_id", this.E.getString("traffic_group_id"));
        bundle.putString("experiment_group_id", this.E.getString("experiment_group_id"));
        TrackingManager.trackingAdCancel((Bundle)bundle);
    }

    public void trackingTriggerShowError(TAdErrorCode tAdErrorCode) {
        Bundle bundle = new Bundle();
        try {
            if (this.E != null) {
                bundle.putString("trigger_id", this.E.getString("trigger_id"));
                bundle.putLong("trigger_ts", this.E.getLong("trigger_ts"));
                bundle.putDouble("bidding_price", this.E.getDouble("bidding_price"));
                bundle.putInt("platform", this.E.getInt("platform"));
            } else {
                bundle.putString("trigger_id", TrackingUtil.getTriggerId());
                bundle.putLong("trigger_ts", System.currentTimeMillis());
            }
            CloudControlConfig.CodeSeat codeSeat = f.f(this.m);
            bundle.putString("cld_app_id", TAdManager.getAppId());
            bundle.putString("app_id", TAdManager.getAppId());
            bundle.putString("code_seat_id", this.m);
            bundle.putString("cld_code_seat_id", this.m);
            bundle.putInt("ad_type", this.n());
            if (codeSeat != null) {
                bundle.putString("traffic_group_id", codeSeat.getTrafficGroupId());
                bundle.putString("experiment_group_id", codeSeat.getExperimentGroupId());
            }
            if (tAdErrorCode != null) {
                bundle.putString("error_code", String.valueOf(tAdErrorCode.getErrorCode()));
                bundle.putString("error_message", tAdErrorCode.getErrorMessage());
            }
            bundle.putInt("is_offline", NetStateManager.checkNetworkState() ? 0 : 1);
            TrackingManager.trackingTrigerShow((Bundle)bundle);
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("ad_flow", Log.getStackTraceString((Throwable)exception));
        }
    }

    private void a(String string2, String string3, int n) {
        Bundle bundle = new Bundle();
        bundle.putString("scene_id", string3);
        bundle.putString("scene_token", string2);
        bundle.putInt("is_offline", NetStateManager.checkNetworkState() ? 0 : 1);
        CloudControlConfig.CodeSeat codeSeat = f.f(this.m);
        if (codeSeat == null) {
            bundle.putInt("cache_status", 1);
        } else {
            AdCache adCache = AdCacheManager.getCache((int)codeSeat.getCodeSeatType());
            if (adCache != null) {
                boolean bl = adCache.hasAds(this.m);
                if (bl) {
                    bundle.putInt("cache_status", 0);
                } else {
                    bundle.putInt("cache_status", this.q.get() ? 2 : 1);
                }
            }
        }
        bundle.putString("cld_code_seat_id", this.m);
        bundle.putString("cld_app_id", TAdManager.getAppId());
        bundle.putLong("ts", System.currentTimeMillis());
        bundle.putInt("ad_count", n);
        TrackingManager.trackEnterScene((Bundle)bundle);
    }

    private void b(boolean bl, int n) {
        long l = System.currentTimeMillis();
        if (l - this.w < 1000L) {
            AdLogUtil.Log().e("TBaseAd", "isReady interval time is not fit");
            return;
        }
        this.w = l;
        Bundle bundle = new Bundle();
        if (bl) {
            n = this.r.get() ? 1 : 2;
        }
        bundle.putInt("is_ready_status", n);
        bundle.putString("cld_code_seat_id", this.m);
        bundle.putString("cld_app_id", TAdManager.getAppId());
        bundle.putLong("ts", System.currentTimeMillis());
        TrackingManager.trackIsReady((Bundle)bundle);
    }
}

