/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation;

import com.applovin.adview.AppLovinAdView;
import com.applovin.adview.AppLovinAdViewDisplayErrorCode;
import com.applovin.adview.AppLovinAdViewEventListener;
import com.applovin.mediation.AppLovinUtils;
import com.applovin.mediation.ApplovinAdapter;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinSdkUtils;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;

class AppLovinBannerAdListener
implements AppLovinAdLoadListener,
AppLovinAdDisplayListener,
AppLovinAdClickListener,
AppLovinAdViewEventListener {
    private final ApplovinAdapter adapter;
    private final MediationBannerListener mediationBannerListener;
    private final AppLovinAdView adView;
    private final String zoneId;

    AppLovinBannerAdListener(String zoneId, AppLovinAdView adView, ApplovinAdapter adapter, MediationBannerListener mediationBannerListener) {
        this.adapter = adapter;
        this.mediationBannerListener = mediationBannerListener;
        this.adView = adView;
        this.zoneId = zoneId;
    }

    public void adReceived(AppLovinAd ad) {
        ApplovinAdapter.log(3, "Banner did load ad: " + ad.getAdIdNumber() + " for zone: " + this.zoneId);
        this.adView.renderAd(ad);
        AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AppLovinBannerAdListener.this.mediationBannerListener.onAdLoaded((MediationBannerAdapter)AppLovinBannerAdListener.this.adapter);
            }
        });
    }

    public void failedToReceiveAd(int code) {
        final AdError error = AppLovinUtils.getAdError(code);
        ApplovinAdapter.log(5, "Failed to load banner ad with error: " + code);
        AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AppLovinBannerAdListener.this.mediationBannerListener.onAdFailedToLoad((MediationBannerAdapter)AppLovinBannerAdListener.this.adapter, error);
            }
        });
    }

    public void adDisplayed(AppLovinAd ad) {
        ApplovinAdapter.log(3, "Banner displayed.");
    }

    public void adHidden(AppLovinAd ad) {
        ApplovinAdapter.log(3, "Banner dismissed.");
    }

    public void adClicked(AppLovinAd ad) {
        ApplovinAdapter.log(3, "Banner clicked.");
        this.mediationBannerListener.onAdClicked((MediationBannerAdapter)this.adapter);
    }

    public void adOpenedFullscreen(AppLovinAd ad, AppLovinAdView adView) {
        ApplovinAdapter.log(3, "Banner opened fullscreen.");
        this.mediationBannerListener.onAdOpened((MediationBannerAdapter)this.adapter);
    }

    public void adClosedFullscreen(AppLovinAd ad, AppLovinAdView adView) {
        ApplovinAdapter.log(3, "Banner closed fullscreen.");
        this.mediationBannerListener.onAdClosed((MediationBannerAdapter)this.adapter);
    }

    public void adLeftApplication(AppLovinAd ad, AppLovinAdView adView) {
        ApplovinAdapter.log(3, "Banner left application.");
        this.mediationBannerListener.onAdLeftApplication((MediationBannerAdapter)this.adapter);
    }

    public void adFailedToDisplay(AppLovinAd ad, AppLovinAdView adView, AppLovinAdViewDisplayErrorCode code) {
        ApplovinAdapter.log(5, "Banner failed to display: " + code);
    }
}

