/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.rtb;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.adview.AppLovinInterstitialAdDialog;
import com.applovin.mediation.AppLovinUtils;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinSdk;
import com.google.ads.mediation.applovin.AppLovinAdFactory;
import com.google.ads.mediation.applovin.AppLovinInitializer;
import com.google.ads.mediation.applovin.AppLovinInterstitialRenderer;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAd;
import com.google.android.gms.ads.mediation.MediationInterstitialAdCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAdConfiguration;

public final class AppLovinRtbInterstitialRenderer
extends AppLovinInterstitialRenderer
implements MediationInterstitialAd {
    private final AppLovinSdk sdk;
    @Nullable
    private AppLovinInterstitialAdDialog interstitialAd;

    public AppLovinRtbInterstitialRenderer(@NonNull MediationInterstitialAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> callback, @NonNull AppLovinInitializer appLovinInitializer, @NonNull AppLovinAdFactory appLovinAdFactory) {
        super(adConfiguration, callback, appLovinInitializer, appLovinAdFactory);
        this.sdk = appLovinInitializer.retrieveSdk(adConfiguration.getServerParameters(), adConfiguration.getContext());
    }

    @Override
    public void loadAd() {
        this.interstitialAd = this.appLovinAdFactory.createInterstitialAdDialog(this.sdk, this.interstitialAdConfiguration.getContext());
        this.interstitialAd.setAdDisplayListener((AppLovinAdDisplayListener)this);
        this.interstitialAd.setAdClickListener((AppLovinAdClickListener)this);
        this.interstitialAd.setAdVideoPlaybackListener((AppLovinAdVideoPlaybackListener)this);
        this.interstitialAd.setExtraInfo("google_watermark", (Object)this.interstitialAdConfiguration.getWatermark());
        this.sdk.getAdService().loadNextAdForAdToken(this.interstitialAdConfiguration.getBidResponse(), (AppLovinAdLoadListener)this);
    }

    public void showAd(@NonNull Context context) {
        boolean muted = AppLovinUtils.shouldMuteAudio(this.interstitialAdConfiguration.getMediationExtras());
        this.sdk.getSettings().setMuted(muted);
        this.interstitialAd.showAndRender(this.appLovinInterstitialAd);
    }
}

