/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.adview.AppLovinAdView;
import com.applovin.adview.AppLovinAdViewEventListener;
import com.applovin.adview.AppLovinInterstitialAd;
import com.applovin.adview.AppLovinInterstitialAdDialog;
import com.applovin.mediation.AppLovinBannerAdListener;
import com.applovin.mediation.AppLovinInterstitialAdListener;
import com.applovin.mediation.AppLovinUtils;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.google.ads.mediation.applovin.AppLovinInitializer;
import com.google.ads.mediation.applovin.AppLovinMediationAdapter;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.OnContextChangedListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class ApplovinAdapter
extends AppLovinMediationAdapter
implements MediationBannerAdapter,
MediationInterstitialAdapter,
OnContextChangedListener {
    private static final boolean LOGGING_ENABLED = true;
    private static final HashMap<String, WeakReference<ApplovinAdapter>> appLovinInterstitialAds = new HashMap();
    private AppLovinAd appLovinInterstitialAd;
    private AppLovinSdk sdk;
    private Context context;
    private Bundle networkExtras;
    private MediationInterstitialListener mediationInterstitialListener;
    private AppLovinAdView adView;
    private String zoneId;
    private boolean enableMultipleAdLoading = false;

    public void requestInterstitialAd(final @NonNull Context context, final @NonNull MediationInterstitialListener interstitialListener, final @NonNull Bundle serverParameters, @NonNull MediationAdRequest mediationAdRequest, final @Nullable Bundle networkExtras) {
        String sdkKey = serverParameters.getString("sdkKey");
        if (TextUtils.isEmpty((CharSequence)sdkKey)) {
            AdError error = new AdError(110, "Missing or invalid SDK Key.", "com.google.ads.mediation.applovin");
            ApplovinAdapter.log(6, error.getMessage());
            interstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)this, error);
            return;
        }
        if (AppLovinUtils.isMultiAdsEnabled(serverParameters)) {
            this.enableMultipleAdLoading = true;
        }
        AppLovinInitializer.getInstance().initialize(context, sdkKey, new AppLovinInitializer.OnInitializeSuccessListener(){

            @Override
            public void onInitializeSuccess(@NonNull String sdkKey) {
                ApplovinAdapter.this.zoneId = AppLovinUtils.retrieveZoneId(serverParameters);
                if (appLovinInterstitialAds.containsKey(ApplovinAdapter.this.zoneId) && ((WeakReference)appLovinInterstitialAds.get(ApplovinAdapter.this.zoneId)).get() != null) {
                    AdError error = new AdError(105, " Cannot load multiple interstitial ads with the same Zone ID. Display one ad before attempting to load another. ", "com.google.ads.mediation.applovin");
                    ApplovinAdapter.log(6, error.getMessage());
                    interstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)ApplovinAdapter.this, error);
                    return;
                }
                appLovinInterstitialAds.put(ApplovinAdapter.this.zoneId, new WeakReference<ApplovinAdapter>(ApplovinAdapter.this));
                ApplovinAdapter.this.sdk = AppLovinInitializer.getInstance().retrieveSdk(serverParameters, context);
                ApplovinAdapter.this.context = context;
                ApplovinAdapter.this.networkExtras = networkExtras;
                ApplovinAdapter.this.mediationInterstitialListener = interstitialListener;
                ApplovinAdapter.log(3, "Requesting interstitial for zone: " + ApplovinAdapter.this.zoneId);
                AppLovinAdLoadListener adLoadListener = new AppLovinAdLoadListener(){

                    public void adReceived(AppLovinAd ad) {
                        ApplovinAdapter.log(3, "Interstitial did load ad: " + ad.getAdIdNumber() + " for zone: " + ApplovinAdapter.this.zoneId);
                        ApplovinAdapter.this.appLovinInterstitialAd = ad;
                        if (ApplovinAdapter.this.enableMultipleAdLoading) {
                            ApplovinAdapter.this.unregister();
                        }
                        AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ApplovinAdapter.this.mediationInterstitialListener.onAdLoaded((MediationInterstitialAdapter)ApplovinAdapter.this);
                            }
                        });
                    }

                    public void failedToReceiveAd(int code) {
                        final AdError error = AppLovinUtils.getAdError(code);
                        ApplovinAdapter.log(5, error.getMessage());
                        ApplovinAdapter.this.unregister();
                        AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ApplovinAdapter.this.mediationInterstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)ApplovinAdapter.this, error);
                            }
                        });
                    }
                };
                if (!TextUtils.isEmpty((CharSequence)ApplovinAdapter.this.zoneId)) {
                    ApplovinAdapter.this.sdk.getAdService().loadNextAdForZoneId(ApplovinAdapter.this.zoneId, adLoadListener);
                } else {
                    ApplovinAdapter.this.sdk.getAdService().loadNextAd(AppLovinAdSize.INTERSTITIAL, adLoadListener);
                }
            }
        });
    }

    public void showInterstitial() {
        this.sdk.getSettings().setMuted(AppLovinUtils.shouldMuteAudio(this.networkExtras));
        AppLovinInterstitialAdDialog interstitialAdDialog = AppLovinInterstitialAd.create((AppLovinSdk)this.sdk, (Context)this.context);
        AppLovinInterstitialAdListener listener = new AppLovinInterstitialAdListener(this, this.mediationInterstitialListener);
        interstitialAdDialog.setAdDisplayListener((AppLovinAdDisplayListener)listener);
        interstitialAdDialog.setAdClickListener((AppLovinAdClickListener)listener);
        interstitialAdDialog.setAdVideoPlaybackListener((AppLovinAdVideoPlaybackListener)listener);
        if (this.appLovinInterstitialAd == null) {
            ApplovinAdapter.log(3, "Attempting to show interstitial before one was loaded.");
            if (TextUtils.isEmpty((CharSequence)this.zoneId)) {
                ApplovinAdapter.log(3, "Showing interstitial preloaded by SDK.");
                interstitialAdDialog.show();
            } else {
                this.mediationInterstitialListener.onAdOpened((MediationInterstitialAdapter)this);
                this.mediationInterstitialListener.onAdClosed((MediationInterstitialAdapter)this);
            }
            return;
        }
        ApplovinAdapter.log(3, "Showing interstitial for zone: " + this.zoneId);
        interstitialAdDialog.showAndRender(this.appLovinInterstitialAd);
    }

    public void requestBannerAd(final @NonNull Context context, final @NonNull MediationBannerListener mediationBannerListener, final @NonNull Bundle serverParameters, @NonNull AdSize adSize, @NonNull MediationAdRequest mediationAdRequest, @Nullable Bundle networkExtras) {
        String sdkKey = serverParameters.getString("sdkKey");
        if (TextUtils.isEmpty((CharSequence)sdkKey)) {
            AdError error = new AdError(110, "Missing or invalid SDK Key.", "com.google.ads.mediation.applovin");
            ApplovinAdapter.log(6, error.getMessage());
            mediationBannerListener.onAdFailedToLoad((MediationBannerAdapter)this, error);
            return;
        }
        final AppLovinAdSize appLovinAdSize = AppLovinUtils.appLovinAdSizeFromAdMobAdSize(context, adSize);
        if (appLovinAdSize == null) {
            AdError error = new AdError(101, "Failed to request banner with unsupported size.", "com.google.ads.mediation.applovin");
            ApplovinAdapter.log(6, error.getMessage());
            mediationBannerListener.onAdFailedToLoad((MediationBannerAdapter)this, error);
            return;
        }
        AppLovinInitializer.getInstance().initialize(context, sdkKey, new AppLovinInitializer.OnInitializeSuccessListener(){

            @Override
            public void onInitializeSuccess(@NonNull String sdkKey) {
                ApplovinAdapter.this.sdk = AppLovinInitializer.getInstance().retrieveSdk(serverParameters, context);
                ApplovinAdapter.this.zoneId = AppLovinUtils.retrieveZoneId(serverParameters);
                ApplovinAdapter.log(3, "Requesting banner of size " + appLovinAdSize + " for zone: " + ApplovinAdapter.this.zoneId);
                ApplovinAdapter.this.adView = new AppLovinAdView(ApplovinAdapter.this.sdk, appLovinAdSize, context);
                AppLovinBannerAdListener listener = new AppLovinBannerAdListener(ApplovinAdapter.this.zoneId, ApplovinAdapter.this.adView, ApplovinAdapter.this, mediationBannerListener);
                ApplovinAdapter.this.adView.setAdDisplayListener((AppLovinAdDisplayListener)listener);
                ApplovinAdapter.this.adView.setAdClickListener((AppLovinAdClickListener)listener);
                ApplovinAdapter.this.adView.setAdViewEventListener((AppLovinAdViewEventListener)listener);
                if (!TextUtils.isEmpty((CharSequence)ApplovinAdapter.this.zoneId)) {
                    ApplovinAdapter.this.sdk.getAdService().loadNextAdForZoneId(ApplovinAdapter.this.zoneId, (AppLovinAdLoadListener)listener);
                } else {
                    ApplovinAdapter.this.sdk.getAdService().loadNextAd(appLovinAdSize, (AppLovinAdLoadListener)listener);
                }
            }
        });
    }

    @NonNull
    public View getBannerView() {
        return this.adView;
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onDestroy() {
    }

    public void onContextChanged(@NonNull Context context) {
        ApplovinAdapter.log(3, "Context changed: " + context);
        this.context = context;
    }

    public static void log(int priority, String message) {
        Log.println((int)priority, (String)"AppLovinAdapter", (String)message);
    }

    void unregister() {
        if (!TextUtils.isEmpty((CharSequence)this.zoneId) && appLovinInterstitialAds.containsKey(this.zoneId) && ((Object)((Object)this)).equals(appLovinInterstitialAds.get(this.zoneId).get())) {
            appLovinInterstitialAds.remove(this.zoneId);
        }
    }
}

