/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.rtb;

import android.content.Context;
import androidx.annotation.NonNull;
import com.applovin.mediation.AppLovinUtils;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.google.ads.mediation.applovin.AppLovinAdFactory;
import com.google.ads.mediation.applovin.AppLovinInitializer;
import com.google.ads.mediation.applovin.AppLovinRewardedRenderer;
import com.google.ads.mediation.applovin.AppLovinSdkUtilsWrapper;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;

public final class AppLovinRtbRewardedRenderer
extends AppLovinRewardedRenderer {
    private AppLovinAd appLovinAd;

    public AppLovinRtbRewardedRenderer(@NonNull MediationRewardedAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> callback, @NonNull AppLovinInitializer appLovinInitializer, @NonNull AppLovinAdFactory appLovinAdFactory, @NonNull AppLovinSdkUtilsWrapper appLovinSdkUtilsWrapper) {
        super(adConfiguration, callback, appLovinInitializer, appLovinAdFactory, appLovinSdkUtilsWrapper);
    }

    @Override
    public void loadAd() {
        Context context = this.adConfiguration.getContext();
        this.appLovinSdk = this.appLovinInitializer.retrieveSdk(this.adConfiguration.getServerParameters(), context);
        this.incentivizedInterstitial = this.appLovinAdFactory.createIncentivizedInterstitial(this.appLovinSdk);
        this.incentivizedInterstitial.setExtraInfo("google_watermark", (Object)this.adConfiguration.getWatermark());
        this.appLovinSdk.getAdService().loadNextAdForAdToken(this.adConfiguration.getBidResponse(), (AppLovinAdLoadListener)this);
    }

    public void showAd(@NonNull Context context) {
        this.appLovinSdk.getSettings().setMuted(AppLovinUtils.shouldMuteAudio(this.adConfiguration.getMediationExtras()));
        this.incentivizedInterstitial.show(this.appLovinAd, context, (AppLovinAdRewardListener)this, (AppLovinAdVideoPlaybackListener)this, (AppLovinAdDisplayListener)this, (AppLovinAdClickListener)this);
    }

    @Override
    public void adReceived(@NonNull AppLovinAd appLovinAd) {
        this.appLovinAd = appLovinAd;
        super.adReceived(this.appLovinAd);
    }
}

