/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.applovin;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.applovin.mediation.AppLovinUtils;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.google.ads.mediation.applovin.AppLovinAdFactory;
import com.google.ads.mediation.applovin.AppLovinInitializer;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAd;
import com.google.android.gms.ads.mediation.MediationInterstitialAdCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAdConfiguration;

public abstract class AppLovinInterstitialRenderer
implements MediationInterstitialAd,
AppLovinAdDisplayListener,
AppLovinAdClickListener,
AppLovinAdVideoPlaybackListener,
AppLovinAdLoadListener {
    protected static final String TAG = AppLovinInterstitialRenderer.class.getSimpleName();
    @VisibleForTesting
    public static final String ERROR_MSG_MULTIPLE_INTERSTITIAL_AD = " Cannot load multiple interstitial ads with the same Zone ID. Display one ad before attempting to load another. ";
    protected final MediationInterstitialAdConfiguration interstitialAdConfiguration;
    protected final MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> interstitialAdLoadCallback;
    protected final AppLovinInitializer appLovinInitializer;
    protected final AppLovinAdFactory appLovinAdFactory;
    @Nullable
    private MediationInterstitialAdCallback interstitialAdCallback;
    @Nullable
    protected AppLovinAd appLovinInterstitialAd;
    @Nullable
    protected String zoneId;

    public AppLovinInterstitialRenderer(@NonNull MediationInterstitialAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> callback, @NonNull AppLovinInitializer appLovinInitializer, @NonNull AppLovinAdFactory appLovinAdFactory) {
        this.interstitialAdConfiguration = adConfiguration;
        this.interstitialAdLoadCallback = callback;
        this.appLovinInitializer = appLovinInitializer;
        this.appLovinAdFactory = appLovinAdFactory;
    }

    public abstract void loadAd();

    public void adReceived(AppLovinAd ad) {
        Log.d((String)TAG, (String)("Interstitial did load ad: " + ad.getAdIdNumber() + " for zone: " + this.zoneId));
        this.appLovinInterstitialAd = ad;
        this.interstitialAdCallback = (MediationInterstitialAdCallback)this.interstitialAdLoadCallback.onSuccess((Object)this);
    }

    public void failedToReceiveAd(int code) {
        AdError error = AppLovinUtils.getAdError(code);
        Log.w((String)TAG, (String)error.getMessage());
        this.interstitialAdLoadCallback.onFailure(error);
    }

    public void adDisplayed(AppLovinAd ad) {
        Log.d((String)TAG, (String)"Interstitial displayed.");
        this.interstitialAdCallback.onAdOpened();
    }

    public void adHidden(AppLovinAd ad) {
        Log.d((String)TAG, (String)"Interstitial dismissed.");
        this.interstitialAdCallback.onAdClosed();
    }

    public void adClicked(AppLovinAd ad) {
        Log.d((String)TAG, (String)"Interstitial clicked.");
        this.interstitialAdCallback.reportAdClicked();
        this.interstitialAdCallback.onAdLeftApplication();
    }

    public void videoPlaybackBegan(AppLovinAd ad) {
        Log.d((String)TAG, (String)"Interstitial video playback began.");
    }

    public void videoPlaybackEnded(AppLovinAd ad, double percentViewed, boolean fullyWatched) {
        Log.d((String)TAG, (String)("Interstitial video playback ended at playback percent: " + percentViewed + "%."));
    }
}

