/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.applovin;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.applovin.mediation.AppLovinUtils;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.google.ads.mediation.applovin.AppLovinAdFactory;
import com.google.ads.mediation.applovin.AppLovinInitializer;
import com.google.ads.mediation.applovin.AppLovinRewardedRenderer;
import com.google.ads.mediation.applovin.AppLovinSdkUtilsWrapper;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Objects;

public class AppLovinWaterfallRewardedRenderer
extends AppLovinRewardedRenderer
implements MediationRewardedAd {
    @VisibleForTesting
    protected static final HashMap<String, WeakReference<AppLovinWaterfallRewardedRenderer>> incentivizedAdsMap = new HashMap();
    private static final String DEFAULT_ZONE = "";
    private String zoneId;
    private boolean enableMultipleAdLoading = false;

    protected AppLovinWaterfallRewardedRenderer(@NonNull MediationRewardedAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> callback, @NonNull AppLovinInitializer appLovinInitializer, @NonNull AppLovinAdFactory appLovinAdFactory, @NonNull AppLovinSdkUtilsWrapper appLovinSdkUtilsWrapper) {
        super(adConfiguration, callback, appLovinInitializer, appLovinAdFactory, appLovinSdkUtilsWrapper);
    }

    @Override
    public void loadAd() {
        final Context context = this.adConfiguration.getContext();
        final Bundle serverParameters = this.adConfiguration.getServerParameters();
        String sdkKey = serverParameters.getString("sdkKey");
        if (TextUtils.isEmpty((CharSequence)sdkKey)) {
            AdError error = new AdError(110, "Missing or invalid SDK Key.", "com.applovin.sdk");
            Log.e((String)TAG, (String)error.toString());
            this.adLoadCallback.onFailure(error);
            return;
        }
        if (AppLovinUtils.isMultiAdsEnabled(serverParameters)) {
            this.enableMultipleAdLoading = true;
        }
        this.appLovinInitializer.initialize(context, sdkKey, new AppLovinInitializer.OnInitializeSuccessListener(){

            @Override
            public void onInitializeSuccess(@NonNull String sdkKey) {
                AppLovinWaterfallRewardedRenderer.this.zoneId = AppLovinUtils.retrieveZoneId(serverParameters);
                AppLovinWaterfallRewardedRenderer.this.appLovinSdk = AppLovinWaterfallRewardedRenderer.this.appLovinInitializer.retrieveSdk(serverParameters, context);
                String logMessage = String.format("Requesting rewarded video for zone '%s'", AppLovinWaterfallRewardedRenderer.this.zoneId);
                Log.d((String)AppLovinRewardedRenderer.TAG, (String)logMessage);
                boolean adAlreadyRequested = false;
                if (incentivizedAdsMap.containsKey(AppLovinWaterfallRewardedRenderer.this.zoneId)) {
                    adAlreadyRequested = true;
                } else {
                    incentivizedAdsMap.put(AppLovinWaterfallRewardedRenderer.this.zoneId, new WeakReference<AppLovinWaterfallRewardedRenderer>(AppLovinWaterfallRewardedRenderer.this));
                }
                if (adAlreadyRequested) {
                    AdError error = new AdError(105, "Cannot load multiple rewarded ads with the same Zone ID. Display one ad before attempting to load another.", "com.google.ads.mediation.applovin");
                    Log.e((String)AppLovinRewardedRenderer.TAG, (String)error.toString());
                    AppLovinWaterfallRewardedRenderer.this.adLoadCallback.onFailure(error);
                    return;
                }
                AppLovinWaterfallRewardedRenderer.this.incentivizedInterstitial = Objects.equals(AppLovinWaterfallRewardedRenderer.this.zoneId, AppLovinWaterfallRewardedRenderer.DEFAULT_ZONE) ? AppLovinWaterfallRewardedRenderer.this.appLovinAdFactory.createIncentivizedInterstitial(AppLovinWaterfallRewardedRenderer.this.appLovinSdk) : AppLovinWaterfallRewardedRenderer.this.appLovinAdFactory.createIncentivizedInterstitial(AppLovinWaterfallRewardedRenderer.this.zoneId, AppLovinWaterfallRewardedRenderer.this.appLovinSdk);
                AppLovinWaterfallRewardedRenderer.this.incentivizedInterstitial.preload((AppLovinAdLoadListener)AppLovinWaterfallRewardedRenderer.this);
            }
        });
    }

    public void showAd(@NonNull Context context) {
        this.appLovinSdk.getSettings().setMuted(AppLovinUtils.shouldMuteAudio(this.adConfiguration.getMediationExtras()));
        if (this.zoneId != null) {
            String logMessage = String.format("Showing rewarded video for zone '%s'", this.zoneId);
            Log.d((String)TAG, (String)logMessage);
        }
        if (!this.incentivizedInterstitial.isAdReadyToDisplay()) {
            AdError error = new AdError(106, "Ad not ready to show.", "com.google.ads.mediation.applovin");
            Log.e((String)TAG, (String)error.toString());
            this.rewardedAdCallback.onAdFailedToShow(error);
            return;
        }
        this.incentivizedInterstitial.show(context, (AppLovinAdRewardListener)this, (AppLovinAdVideoPlaybackListener)this, (AppLovinAdDisplayListener)this, (AppLovinAdClickListener)this);
    }

    @Override
    public void adReceived(@NonNull AppLovinAd appLovinAd) {
        if (this.enableMultipleAdLoading) {
            incentivizedAdsMap.remove(this.zoneId);
        }
        super.adReceived(appLovinAd);
    }

    @Override
    public void failedToReceiveAd(int code) {
        incentivizedAdsMap.remove(this.zoneId);
        super.failedToReceiveAd(code);
    }

    @Override
    public void adHidden(@NonNull AppLovinAd ad) {
        incentivizedAdsMap.remove(this.zoneId);
        super.adHidden(ad);
    }
}

