/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.applovin;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import com.applovin.adview.AppLovinAdView;
import com.applovin.adview.AppLovinAdViewDisplayErrorCode;
import com.applovin.adview.AppLovinAdViewEventListener;
import com.applovin.mediation.AppLovinUtils;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinSdk;
import com.google.ads.mediation.applovin.AppLovinAdFactory;
import com.google.ads.mediation.applovin.AppLovinAdViewWrapper;
import com.google.ads.mediation.applovin.AppLovinInitializer;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationBannerAd;
import com.google.android.gms.ads.mediation.MediationBannerAdCallback;
import com.google.android.gms.ads.mediation.MediationBannerAdConfiguration;

public class AppLovinBannerAd
implements MediationBannerAd,
AppLovinAdLoadListener,
AppLovinAdDisplayListener,
AppLovinAdClickListener,
AppLovinAdViewEventListener {
    private AppLovinAdViewWrapper appLovinAdViewWrapper;
    private AppLovinSdk sdk;
    private Context context;
    private String zoneId;
    private final AppLovinInitializer appLovinInitializer;
    private final AppLovinAdFactory appLovinAdFactory;
    private final MediationBannerAdConfiguration mediationBannerAdConfiguration;
    private final MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> mediationAdLoadCallback;
    private MediationBannerAdCallback bannerAdCallback;
    private static final String TAG = AppLovinBannerAd.class.getSimpleName();

    private AppLovinBannerAd(@NonNull MediationBannerAdConfiguration mediationBannerAdConfiguration, @NonNull MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> mediationAdLoadCallback, @NonNull AppLovinInitializer appLovinInitializer, @NonNull AppLovinAdFactory appLovinAdFactory) {
        this.mediationBannerAdConfiguration = mediationBannerAdConfiguration;
        this.mediationAdLoadCallback = mediationAdLoadCallback;
        this.appLovinInitializer = appLovinInitializer;
        this.appLovinAdFactory = appLovinAdFactory;
    }

    public static AppLovinBannerAd newInstance(@NonNull MediationBannerAdConfiguration mediationBannerAdConfiguration, @NonNull MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> mediationAdLoadCallback, @NonNull AppLovinInitializer appLovinInitializer, @NonNull AppLovinAdFactory appLovinAdFactory) {
        return new AppLovinBannerAd(mediationBannerAdConfiguration, mediationAdLoadCallback, appLovinInitializer, appLovinAdFactory);
    }

    public void loadAd() {
        this.context = this.mediationBannerAdConfiguration.getContext();
        final Bundle serverParameters = this.mediationBannerAdConfiguration.getServerParameters();
        AdSize adSize = this.mediationBannerAdConfiguration.getAdSize();
        String sdkKey = serverParameters.getString("sdkKey");
        if (TextUtils.isEmpty((CharSequence)sdkKey)) {
            AdError error = new AdError(110, "Missing or invalid SDK Key.", "com.google.ads.mediation.applovin");
            Log.e((String)TAG, (String)error.getMessage());
            this.mediationAdLoadCallback.onFailure(error);
            return;
        }
        final AppLovinAdSize appLovinAdSize = AppLovinUtils.appLovinAdSizeFromAdMobAdSize(this.context, adSize);
        if (appLovinAdSize == null) {
            AdError error = new AdError(101, "Failed to request banner with unsupported size.", "com.google.ads.mediation.applovin");
            Log.e((String)TAG, (String)error.getMessage());
            this.mediationAdLoadCallback.onFailure(error);
            return;
        }
        this.appLovinInitializer.initialize(this.context, sdkKey, new AppLovinInitializer.OnInitializeSuccessListener(){

            @Override
            public void onInitializeSuccess(@NonNull String sdkKey) {
                AppLovinBannerAd.this.sdk = AppLovinBannerAd.this.appLovinInitializer.retrieveSdk(serverParameters, AppLovinBannerAd.this.context);
                AppLovinBannerAd.this.zoneId = AppLovinUtils.retrieveZoneId(serverParameters);
                Log.d((String)TAG, (String)("Requesting banner of size " + appLovinAdSize + " for zone: " + AppLovinBannerAd.this.zoneId));
                AppLovinBannerAd.this.appLovinAdViewWrapper = AppLovinBannerAd.this.appLovinAdFactory.createAdView(AppLovinBannerAd.this.sdk, appLovinAdSize, AppLovinBannerAd.this.context);
                AppLovinBannerAd.this.appLovinAdViewWrapper.setAdDisplayListener(AppLovinBannerAd.this);
                AppLovinBannerAd.this.appLovinAdViewWrapper.setAdClickListener(AppLovinBannerAd.this);
                AppLovinBannerAd.this.appLovinAdViewWrapper.setAdViewEventListener(AppLovinBannerAd.this);
                if (!TextUtils.isEmpty((CharSequence)AppLovinBannerAd.this.zoneId)) {
                    AppLovinBannerAd.this.sdk.getAdService().loadNextAdForZoneId(AppLovinBannerAd.this.zoneId, (AppLovinAdLoadListener)AppLovinBannerAd.this);
                } else {
                    AppLovinBannerAd.this.sdk.getAdService().loadNextAd(appLovinAdSize, (AppLovinAdLoadListener)AppLovinBannerAd.this);
                }
            }
        });
    }

    @NonNull
    public View getView() {
        return this.appLovinAdViewWrapper.getAppLovinAdView();
    }

    public void adReceived(AppLovinAd ad) {
        Log.d((String)TAG, (String)("Banner did load ad: " + ad.getAdIdNumber() + " for zone: " + this.zoneId));
        this.appLovinAdViewWrapper.renderAd(ad);
        this.bannerAdCallback = (MediationBannerAdCallback)this.mediationAdLoadCallback.onSuccess((Object)this);
    }

    public void failedToReceiveAd(int code) {
        AdError error = AppLovinUtils.getAdError(code);
        Log.w((String)TAG, (String)("Failed to load banner ad with error: " + code));
        this.mediationAdLoadCallback.onFailure(error);
    }

    public void adDisplayed(AppLovinAd ad) {
        Log.d((String)TAG, (String)"Banner displayed.");
        if (this.bannerAdCallback != null) {
            this.bannerAdCallback.onAdOpened();
        }
    }

    public void adHidden(AppLovinAd ad) {
        Log.d((String)TAG, (String)"Banner dismissed.");
    }

    public void adClicked(AppLovinAd ad) {
        Log.d((String)TAG, (String)"Banner clicked.");
        if (this.bannerAdCallback != null) {
            this.bannerAdCallback.reportAdClicked();
        }
    }

    public void adOpenedFullscreen(AppLovinAd ad, AppLovinAdView adView) {
        Log.d((String)TAG, (String)"Banner opened fullscreen.");
        if (this.bannerAdCallback != null) {
            this.bannerAdCallback.onAdOpened();
        }
    }

    public void adClosedFullscreen(AppLovinAd ad, AppLovinAdView adView) {
        Log.d((String)TAG, (String)"Banner closed fullscreen.");
        if (this.bannerAdCallback != null) {
            this.bannerAdCallback.onAdClosed();
        }
    }

    public void adLeftApplication(AppLovinAd ad, AppLovinAdView adView) {
        Log.d((String)TAG, (String)"Banner left application.");
        if (this.bannerAdCallback != null) {
            this.bannerAdCallback.onAdLeftApplication();
        }
    }

    public void adFailedToDisplay(AppLovinAd ad, AppLovinAdView adView, AppLovinAdViewDisplayErrorCode code) {
        Log.w((String)TAG, (String)("Banner failed to display: " + code));
    }
}

