/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.applovin;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.applovin.sdk.AppLovinSdkSettings;
import com.google.ads.mediation.applovin.AppLovinSdkWrapper;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;

public class AppLovinInitializer {
    private static final String TAG = AppLovinInitializer.class.getSimpleName();
    private static AppLovinInitializer instance;
    private final AppLovinSdkWrapper appLovinSdkWrapper;
    public static final int UNINITIALIZED = 0;
    public static final int INITIALIZING = 1;
    public static final int INITIALIZED = 2;
    private final HashMap<String, Integer> initializationStatus = new HashMap();
    private final HashMap<String, ArrayList<OnInitializeSuccessListener>> initializerListeners = new HashMap();

    private AppLovinInitializer() {
        this.appLovinSdkWrapper = new AppLovinSdkWrapper();
    }

    @VisibleForTesting
    AppLovinInitializer(AppLovinSdkWrapper appLovinSdkWrapper) {
        this.appLovinSdkWrapper = appLovinSdkWrapper;
    }

    public static AppLovinInitializer getInstance() {
        if (instance == null) {
            instance = new AppLovinInitializer();
        }
        return instance;
    }

    public void initialize(@NonNull Context context, final @NonNull String sdkKey, @NonNull OnInitializeSuccessListener onInitializeSuccessListener) {
        if (!this.initializationStatus.containsKey(sdkKey)) {
            this.initializationStatus.put(sdkKey, 0);
            this.initializerListeners.put(sdkKey, new ArrayList());
        }
        if (Integer.valueOf(2).equals(this.initializationStatus.get(sdkKey))) {
            onInitializeSuccessListener.onInitializeSuccess(sdkKey);
            return;
        }
        this.initializerListeners.get(sdkKey).add(onInitializeSuccessListener);
        if (Integer.valueOf(1).equals(this.initializationStatus.get(sdkKey))) {
            return;
        }
        this.initializationStatus.put(sdkKey, 1);
        String logMessage = String.format("Attempting to initialize SDK with SDK Key: %s", sdkKey);
        Log.d((String)TAG, (String)logMessage);
        AppLovinSdkSettings sdkSettings = this.appLovinSdkWrapper.getSdkSettings(context);
        AppLovinSdk sdk = this.appLovinSdkWrapper.getInstance(sdkKey, sdkSettings, context);
        sdk.setPluginVersion("12.6.0.0");
        sdk.setMediationProvider("admob");
        sdk.initializeSdk(new AppLovinSdk.SdkInitializationListener(){

            public void onSdkInitialized(AppLovinSdkConfiguration config) {
                AppLovinInitializer.this.initializationStatus.put(sdkKey, 2);
                ArrayList listeners = (ArrayList)AppLovinInitializer.this.initializerListeners.get(sdkKey);
                if (listeners != null) {
                    for (OnInitializeSuccessListener onInitializeSuccessListener : listeners) {
                        onInitializeSuccessListener.onInitializeSuccess(sdkKey);
                    }
                    listeners.clear();
                }
            }
        });
    }

    public AppLovinSdk retrieveSdk(Bundle serverParameters, Context context) {
        String sdkKey = serverParameters != null ? serverParameters.getString("sdkKey") : null;
        AppLovinSdkSettings sdkSettings = this.appLovinSdkWrapper.getSdkSettings(context);
        AppLovinSdk sdk = !TextUtils.isEmpty((CharSequence)sdkKey) ? this.appLovinSdkWrapper.getInstance(sdkKey, sdkSettings, context) : this.appLovinSdkWrapper.getInstance(sdkSettings, context);
        sdk.setPluginVersion("12.6.0.0");
        sdk.setMediationProvider("admob");
        return sdk;
    }

    public static interface OnInitializeSuccessListener {
        public void onInitializeSuccess(@NonNull String var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InitializationStatus {
    }
}

