/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.applovin;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.applovin.adview.AppLovinIncentivizedInterstitial;
import com.applovin.mediation.AppLovinUtils;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinSdk;
import com.google.ads.mediation.applovin.AppLovinAdFactory;
import com.google.ads.mediation.applovin.AppLovinInitializer;
import com.google.ads.mediation.applovin.AppLovinRewardItem;
import com.google.ads.mediation.applovin.AppLovinSdkUtilsWrapper;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;
import com.google.android.gms.ads.rewarded.RewardItem;
import java.util.Map;

public abstract class AppLovinRewardedRenderer
implements MediationRewardedAd,
AppLovinAdLoadListener,
AppLovinAdRewardListener,
AppLovinAdDisplayListener,
AppLovinAdClickListener,
AppLovinAdVideoPlaybackListener {
    protected static final String TAG = AppLovinRewardedRenderer.class.getSimpleName();
    @VisibleForTesting
    protected static final String ERROR_MSG_MULTIPLE_REWARDED_AD = "Cannot load multiple rewarded ads with the same Zone ID. Display one ad before attempting to load another.";
    @VisibleForTesting
    protected static final String ERROR_MSG_AD_NOT_READY = "Ad not ready to show.";
    protected final MediationRewardedAdConfiguration adConfiguration;
    protected final MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> adLoadCallback;
    protected final AppLovinInitializer appLovinInitializer;
    protected final AppLovinAdFactory appLovinAdFactory;
    protected final AppLovinSdkUtilsWrapper appLovinSdkUtilsWrapper;
    @Nullable
    protected MediationRewardedAdCallback rewardedAdCallback;
    @Nullable
    protected AppLovinSdk appLovinSdk;
    @Nullable
    protected AppLovinIncentivizedInterstitial incentivizedInterstitial;
    private boolean fullyWatched;
    private AppLovinRewardItem rewardItem;

    protected AppLovinRewardedRenderer(@NonNull MediationRewardedAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> callback, @NonNull AppLovinInitializer appLovinInitializer, @NonNull AppLovinAdFactory appLovinAdFactory, @NonNull AppLovinSdkUtilsWrapper appLovinSdkUtilsWrapper) {
        this.adConfiguration = adConfiguration;
        this.adLoadCallback = callback;
        this.appLovinInitializer = appLovinInitializer;
        this.appLovinAdFactory = appLovinAdFactory;
        this.appLovinSdkUtilsWrapper = appLovinSdkUtilsWrapper;
    }

    public abstract void loadAd();

    public void adReceived(@NonNull AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)("Rewarded video did load ad: " + appLovinAd.getAdIdNumber()));
        this.appLovinSdkUtilsWrapper.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AppLovinRewardedRenderer.this.rewardedAdCallback = (MediationRewardedAdCallback)AppLovinRewardedRenderer.this.adLoadCallback.onSuccess((Object)AppLovinRewardedRenderer.this);
            }
        });
    }

    public void failedToReceiveAd(int code) {
        final AdError error = AppLovinUtils.getAdError(code);
        Log.w((String)TAG, (String)error.toString());
        this.appLovinSdkUtilsWrapper.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AppLovinRewardedRenderer.this.adLoadCallback.onFailure(error);
            }
        });
    }

    public void adDisplayed(@NonNull AppLovinAd ad) {
        Log.d((String)TAG, (String)"Rewarded video displayed.");
        if (this.rewardedAdCallback == null) {
            return;
        }
        this.rewardedAdCallback.onAdOpened();
        this.rewardedAdCallback.reportAdImpression();
    }

    public void adHidden(@NonNull AppLovinAd ad) {
        Log.d((String)TAG, (String)"Rewarded video dismissed.");
        if (this.rewardedAdCallback == null) {
            return;
        }
        if (this.fullyWatched) {
            this.rewardedAdCallback.onUserEarnedReward((RewardItem)this.rewardItem);
        }
        this.rewardedAdCallback.onAdClosed();
    }

    public void adClicked(@NonNull AppLovinAd ad) {
        Log.d((String)TAG, (String)"Rewarded video clicked.");
        if (this.rewardedAdCallback != null) {
            this.rewardedAdCallback.reportAdClicked();
        }
    }

    public void videoPlaybackBegan(AppLovinAd ad) {
        Log.d((String)TAG, (String)"Rewarded video playback began.");
        if (this.rewardedAdCallback != null) {
            this.rewardedAdCallback.onVideoStart();
        }
    }

    public void videoPlaybackEnded(AppLovinAd ad, double percentViewed, boolean fullyWatched) {
        Log.d((String)TAG, (String)("Rewarded video playback ended at playback percent: " + percentViewed + "%."));
        this.fullyWatched = fullyWatched;
        if (this.rewardedAdCallback != null && fullyWatched) {
            this.rewardedAdCallback.onVideoComplete();
        }
    }

    public void userOverQuota(AppLovinAd ad, Map<String, String> response) {
        Log.e((String)TAG, (String)("Rewarded video validation request for ad did exceed quota with response: " + response));
    }

    public void validationRequestFailed(AppLovinAd ad, int code) {
        Log.e((String)TAG, (String)("Rewarded video validation request for ad failed with error code: " + code));
    }

    public void userRewardRejected(AppLovinAd ad, Map<String, String> response) {
        Log.e((String)TAG, (String)("Rewarded video validation request was rejected with response: " + response));
    }

    public void userRewardVerified(AppLovinAd ad, Map<String, String> response) {
        String currency = response.get("currency");
        String amountStr = response.get("amount");
        int amount = (int)Double.parseDouble(amountStr);
        Log.d((String)TAG, (String)("Rewarded " + amount + " " + currency));
        this.rewardItem = new AppLovinRewardItem(amount, currency);
    }
}

