/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation;

import com.applovin.mediation.ApplovinAdapter;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;

class AppLovinInterstitialAdListener
implements AppLovinAdDisplayListener,
AppLovinAdClickListener,
AppLovinAdVideoPlaybackListener {
    private final ApplovinAdapter adapter;
    private final MediationInterstitialListener mediationInterstitialListener;

    AppLovinInterstitialAdListener(ApplovinAdapter adapter, MediationInterstitialListener mediationInterstitialListener) {
        this.adapter = adapter;
        this.mediationInterstitialListener = mediationInterstitialListener;
    }

    public void adDisplayed(AppLovinAd ad) {
        ApplovinAdapter.log(3, "Interstitial displayed.");
        this.mediationInterstitialListener.onAdOpened((MediationInterstitialAdapter)this.adapter);
    }

    public void adHidden(AppLovinAd ad) {
        ApplovinAdapter.log(3, "Interstitial dismissed.");
        this.adapter.unregister();
        this.mediationInterstitialListener.onAdClosed((MediationInterstitialAdapter)this.adapter);
    }

    public void adClicked(AppLovinAd ad) {
        ApplovinAdapter.log(3, "Interstitial clicked.");
        this.mediationInterstitialListener.onAdClicked((MediationInterstitialAdapter)this.adapter);
        this.mediationInterstitialListener.onAdLeftApplication((MediationInterstitialAdapter)this.adapter);
    }

    public void videoPlaybackBegan(AppLovinAd ad) {
        ApplovinAdapter.log(3, "Interstitial video playback began.");
    }

    public void videoPlaybackEnded(AppLovinAd ad, double percentViewed, boolean fullyWatched) {
        ApplovinAdapter.log(3, "Interstitial video playback ended at playback percent: " + percentViewed + "%.");
    }
}

