/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.applovin.sdk.AppLovinAdSize;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.MediationUtils;
import java.util.ArrayList;

public class AppLovinUtils {
    private static final String DEFAULT_ZONE = "";
    private static final String TRUE = "true";
    @VisibleForTesting
    public static final String ERROR_MSG_REASON_PREFIX = "AppLovin SDK returned a load failure callback with reason: ";

    public static String retrieveZoneId(Bundle serverParameters) {
        if (serverParameters.containsKey("zone_id")) {
            return serverParameters.getString("zone_id");
        }
        return DEFAULT_ZONE;
    }

    public static boolean isMultiAdsEnabled(Bundle serverParameters) {
        if (serverParameters.containsKey("enable_multiple_ads_per_unit")) {
            String multiAdsFlag = serverParameters.getString("enable_multiple_ads_per_unit");
            return multiAdsFlag.equals(TRUE);
        }
        return false;
    }

    public static boolean shouldMuteAudio(Bundle networkExtras) {
        return networkExtras != null && networkExtras.getBoolean("mute_audio");
    }

    public static AdError getAdError(int applovinErrorCode) {
        String reason = "AppLovin error code " + applovinErrorCode;
        switch (applovinErrorCode) {
            case 204: {
                reason = "NO_FILL";
                break;
            }
            case -1001: {
                reason = "FETCH_AD_TIMEOUT";
                break;
            }
            case -300: {
                reason = "INCENTIVIZED_NO_AD_PRELOADED";
                break;
            }
            case -500: {
                reason = "INCENTIVIZED_SERVER_TIMEOUT";
                break;
            }
            case -400: {
                reason = "INCENTIVIZED_UNKNOWN_SERVER_ERROR";
                break;
            }
            case -600: {
                reason = "INCENTIVIZED_USER_CLOSED_VIDEO";
                break;
            }
            case -8: {
                reason = "INVALID_AD_TOKEN";
                break;
            }
            case -800: {
                reason = "INVALID_RESPONSE";
                break;
            }
            case -900: {
                reason = "INVALID_URL";
                break;
            }
            case -7: {
                reason = "INVALID_ZONE";
                break;
            }
            case -1009: {
                reason = "NO_NETWORK";
                break;
            }
            case -22: {
                reason = "SDK_DISABLED";
                break;
            }
            case -201: {
                reason = "UNABLE_TO_PRECACHE_IMAGE_RESOURCES";
                break;
            }
            case -200: {
                reason = "UNABLE_TO_PRECACHE_RESOURCES";
                break;
            }
            case -202: {
                reason = "UNABLE_TO_PRECACHE_VIDEO_RESOURCES";
                break;
            }
            case -6: {
                reason = "UNABLE_TO_RENDER_AD";
                break;
            }
            case -1: {
                reason = "UNSPECIFIED_ERROR";
                break;
            }
        }
        return new AdError(applovinErrorCode, ERROR_MSG_REASON_PREFIX + reason, "com.applovin.sdk");
    }

    @Nullable
    public static AppLovinAdSize appLovinAdSizeFromAdMobAdSize(@NonNull Context context, @NonNull AdSize adSize) {
        ArrayList<AdSize> potentials = new ArrayList<AdSize>();
        potentials.add(AdSize.BANNER);
        potentials.add(AdSize.LEADERBOARD);
        potentials.add(AdSize.MEDIUM_RECTANGLE);
        AdSize closestSize = MediationUtils.findClosestSize((Context)context, (AdSize)adSize, potentials);
        if (AdSize.BANNER.equals((Object)closestSize)) {
            return AppLovinAdSize.BANNER;
        }
        if (AdSize.MEDIUM_RECTANGLE.equals((Object)closestSize)) {
            return AppLovinAdSize.MREC;
        }
        if (AdSize.LEADERBOARD.equals((Object)closestSize)) {
            return AppLovinAdSize.LEADER;
        }
        return null;
    }

    public static class ServerParameterKeys {
        public static final String SDK_KEY = "sdkKey";
        public static final String ZONE_ID = "zone_id";
        public static final String MULTIPLE_ADS_PER_AD_UNIT = "enable_multiple_ads_per_unit";

        private ServerParameterKeys() {
        }
    }
}

