/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.applovin;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.applovin.adview.AppLovinInterstitialAdDialog;
import com.applovin.mediation.AppLovinUtils;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinSdk;
import com.google.ads.mediation.applovin.AppLovinAdFactory;
import com.google.ads.mediation.applovin.AppLovinInitializer;
import com.google.ads.mediation.applovin.AppLovinInterstitialRenderer;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAd;
import com.google.android.gms.ads.mediation.MediationInterstitialAdCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAdConfiguration;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class AppLovinWaterfallInterstitialAd
extends AppLovinInterstitialRenderer
implements MediationInterstitialAd {
    @VisibleForTesting
    protected static final HashMap<String, WeakReference<AppLovinWaterfallInterstitialAd>> appLovinWaterfallInterstitialAds = new HashMap();
    private AppLovinSdk sdk;
    private Context context;
    private Bundle networkExtras;
    private boolean enableMultipleAdLoading = false;

    public AppLovinWaterfallInterstitialAd(@NonNull MediationInterstitialAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> callback, @NonNull AppLovinInitializer appLovinInitializer, @NonNull AppLovinAdFactory appLovinAdFactory) {
        super(adConfiguration, callback, appLovinInitializer, appLovinAdFactory);
    }

    @Override
    public void loadAd() {
        this.context = this.interstitialAdConfiguration.getContext();
        final Bundle serverParameters = this.interstitialAdConfiguration.getServerParameters();
        String sdkKey = serverParameters.getString("sdkKey");
        if (TextUtils.isEmpty((CharSequence)sdkKey)) {
            AdError error = new AdError(110, "Missing or invalid SDK Key.", "com.applovin.sdk");
            Log.e((String)TAG, (String)error.getMessage());
            this.interstitialAdLoadCallback.onFailure(error);
            return;
        }
        if (AppLovinUtils.isMultiAdsEnabled(serverParameters)) {
            this.enableMultipleAdLoading = true;
        }
        this.appLovinInitializer.initialize(this.context, sdkKey, new AppLovinInitializer.OnInitializeSuccessListener(){

            @Override
            public void onInitializeSuccess(@NonNull String sdkKey) {
                AppLovinWaterfallInterstitialAd.this.zoneId = AppLovinUtils.retrieveZoneId(serverParameters);
                if (appLovinWaterfallInterstitialAds.containsKey(AppLovinWaterfallInterstitialAd.this.zoneId) && appLovinWaterfallInterstitialAds.get(AppLovinWaterfallInterstitialAd.this.zoneId).get() != null) {
                    AdError error = new AdError(105, " Cannot load multiple interstitial ads with the same Zone ID. Display one ad before attempting to load another. ", "com.google.ads.mediation.applovin");
                    Log.e((String)AppLovinInterstitialRenderer.TAG, (String)error.getMessage());
                    AppLovinWaterfallInterstitialAd.this.interstitialAdLoadCallback.onFailure(error);
                    return;
                }
                appLovinWaterfallInterstitialAds.put(AppLovinWaterfallInterstitialAd.this.zoneId, new WeakReference<AppLovinWaterfallInterstitialAd>(AppLovinWaterfallInterstitialAd.this));
                AppLovinWaterfallInterstitialAd.this.sdk = AppLovinWaterfallInterstitialAd.this.appLovinInitializer.retrieveSdk(serverParameters, AppLovinWaterfallInterstitialAd.this.context);
                AppLovinWaterfallInterstitialAd.this.networkExtras = AppLovinWaterfallInterstitialAd.this.networkExtras;
                Log.d((String)AppLovinInterstitialRenderer.TAG, (String)("Requesting interstitial for zone: " + AppLovinWaterfallInterstitialAd.this.zoneId));
                if (!TextUtils.isEmpty((CharSequence)AppLovinWaterfallInterstitialAd.this.zoneId)) {
                    AppLovinWaterfallInterstitialAd.this.sdk.getAdService().loadNextAdForZoneId(AppLovinWaterfallInterstitialAd.this.zoneId, (AppLovinAdLoadListener)AppLovinWaterfallInterstitialAd.this);
                } else {
                    AppLovinWaterfallInterstitialAd.this.sdk.getAdService().loadNextAd(AppLovinAdSize.INTERSTITIAL, (AppLovinAdLoadListener)AppLovinWaterfallInterstitialAd.this);
                }
            }
        });
    }

    public void showAd(Context context) {
        this.sdk.getSettings().setMuted(AppLovinUtils.shouldMuteAudio(this.networkExtras));
        AppLovinInterstitialAdDialog interstitialAdDialog = this.appLovinAdFactory.createInterstitialAdDialog(this.sdk, context);
        interstitialAdDialog.setAdDisplayListener((AppLovinAdDisplayListener)this);
        interstitialAdDialog.setAdClickListener((AppLovinAdClickListener)this);
        interstitialAdDialog.setAdVideoPlaybackListener((AppLovinAdVideoPlaybackListener)this);
        if (this.appLovinInterstitialAd == null) {
            Log.d((String)TAG, (String)"Attempting to show interstitial before one was loaded.");
            if (TextUtils.isEmpty((CharSequence)this.zoneId)) {
                Log.d((String)TAG, (String)"Showing interstitial preloaded by SDK.");
                interstitialAdDialog.show();
            }
            return;
        }
        Log.d((String)TAG, (String)("Showing interstitial for zone: " + this.zoneId));
        interstitialAdDialog.showAndRender(this.appLovinInterstitialAd);
    }

    @Override
    public void adReceived(AppLovinAd ad) {
        if (this.enableMultipleAdLoading) {
            this.unregister();
        }
        super.adReceived(ad);
    }

    @Override
    public void failedToReceiveAd(int code) {
        this.unregister();
        super.failedToReceiveAd(code);
    }

    @Override
    public void adHidden(AppLovinAd ad) {
        this.unregister();
        super.adHidden(ad);
    }

    void unregister() {
        if (!TextUtils.isEmpty((CharSequence)this.zoneId) && appLovinWaterfallInterstitialAds.containsKey(this.zoneId) && this.equals(appLovinWaterfallInterstitialAds.get(this.zoneId).get())) {
            appLovinWaterfallInterstitialAds.remove(this.zoneId);
        }
    }
}

