/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.applovin;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.applovin.mediation.rtb.AppLovinRtbInterstitialRenderer;
import com.applovin.mediation.rtb.AppLovinRtbRewardedRenderer;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkSettings;
import com.google.ads.mediation.applovin.AppLovinAdFactory;
import com.google.ads.mediation.applovin.AppLovinBannerAd;
import com.google.ads.mediation.applovin.AppLovinInitializer;
import com.google.ads.mediation.applovin.AppLovinSdkUtilsWrapper;
import com.google.ads.mediation.applovin.AppLovinSdkWrapper;
import com.google.ads.mediation.applovin.AppLovinWaterfallInterstitialAd;
import com.google.ads.mediation.applovin.AppLovinWaterfallRewardedRenderer;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdFormat;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.mediation.InitializationCompleteCallback;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationBannerAd;
import com.google.android.gms.ads.mediation.MediationBannerAdCallback;
import com.google.android.gms.ads.mediation.MediationBannerAdConfiguration;
import com.google.android.gms.ads.mediation.MediationConfiguration;
import com.google.android.gms.ads.mediation.MediationInterstitialAd;
import com.google.android.gms.ads.mediation.MediationInterstitialAdCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAdConfiguration;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;
import com.google.android.gms.ads.mediation.rtb.RtbAdapter;
import com.google.android.gms.ads.mediation.rtb.RtbSignalData;
import com.google.android.gms.ads.mediation.rtb.SignalCallbacks;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashSet;
import java.util.List;

public class AppLovinMediationAdapter
extends RtbAdapter {
    @Nullable
    public static AppLovinSdkSettings appLovinSdkSettings;
    private AppLovinBannerAd bannerAd;
    private AppLovinWaterfallInterstitialAd waterfallInterstitialAd;
    private AppLovinRtbInterstitialRenderer rtbInterstitialRenderer;
    private AppLovinRtbRewardedRenderer rtbRewardedRenderer;
    private AppLovinWaterfallRewardedRenderer rewardedRenderer;
    private final AppLovinInitializer appLovinInitializer;
    private final AppLovinAdFactory appLovinAdFactory;
    private final AppLovinSdkWrapper appLovinSdkWrapper;
    private final AppLovinSdkUtilsWrapper appLovinSdkUtilsWrapper;
    public static final String ERROR_DOMAIN = "com.google.ads.mediation.applovin";
    public static final String APPLOVIN_SDK_ERROR_DOMAIN = "com.applovin.sdk";
    private static final String TAG;
    public static final int ERROR_BANNER_SIZE_MISMATCH = 101;
    public static final int ERROR_EMPTY_BID_TOKEN = 104;
    public static final int ERROR_AD_ALREADY_REQUESTED = 105;
    public static final int ERROR_PRESENTATON_AD_NOT_READY = 106;
    public static final int ERROR_AD_FORMAT_UNSUPPORTED = 108;
    public static final int ERROR_INVALID_SERVER_PARAMETERS = 110;
    @VisibleForTesting
    static final String ERROR_MSG_MISSING_SDK = "Missing or invalid SDK Key.";
    @VisibleForTesting
    static final String ERROR_MSG_BANNER_SIZE_MISMATCH = "Failed to request banner with unsupported size.";

    public AppLovinMediationAdapter() {
        this.appLovinInitializer = AppLovinInitializer.getInstance();
        this.appLovinAdFactory = new AppLovinAdFactory();
        this.appLovinSdkWrapper = new AppLovinSdkWrapper();
        this.appLovinSdkUtilsWrapper = new AppLovinSdkUtilsWrapper();
    }

    @VisibleForTesting
    AppLovinMediationAdapter(AppLovinInitializer appLovinInitializer, AppLovinAdFactory appLovinAdFactory, AppLovinSdkWrapper appLovinSdkWrapper, AppLovinSdkUtilsWrapper appLovinSdkUtilsWrapper) {
        this.appLovinInitializer = appLovinInitializer;
        this.appLovinAdFactory = appLovinAdFactory;
        this.appLovinSdkWrapper = appLovinSdkWrapper;
        this.appLovinSdkUtilsWrapper = appLovinSdkUtilsWrapper;
    }

    @NonNull
    public static AppLovinSdkSettings getSdkSettings(@NonNull Context context) {
        if (appLovinSdkSettings == null) {
            appLovinSdkSettings = new AppLovinSdkSettings(context);
        }
        return appLovinSdkSettings;
    }

    public void initialize(@NonNull Context context, final @NonNull InitializationCompleteCallback initializationCompleteCallback, @NonNull List<MediationConfiguration> mediationConfigurations) {
        final HashSet<String> sdkKeys = new HashSet<String>();
        for (MediationConfiguration configuration : mediationConfigurations) {
            String sdkKey = configuration.getServerParameters().getString("sdkKey");
            if (TextUtils.isEmpty((CharSequence)sdkKey)) continue;
            sdkKeys.add(sdkKey);
        }
        if (sdkKeys.isEmpty()) {
            AdError error = new AdError(110, ERROR_MSG_MISSING_SDK, ERROR_DOMAIN);
            Log.w((String)TAG, (String)error.getMessage());
            initializationCompleteCallback.onInitializationFailed(error.getMessage());
            return;
        }
        final HashSet initializedSdkKeys = new HashSet();
        for (String sdkKey : sdkKeys) {
            this.appLovinInitializer.initialize(context, sdkKey, new AppLovinInitializer.OnInitializeSuccessListener(){

                @Override
                public void onInitializeSuccess(@NonNull String sdkKey) {
                    initializedSdkKeys.add(sdkKey);
                    if (initializedSdkKeys.equals(sdkKeys)) {
                        initializationCompleteCallback.onInitializationSucceeded();
                    }
                }
            });
        }
    }

    @NonNull
    public VersionInfo getVersionInfo() {
        return this.getVersionInfo("12.6.1.0");
    }

    @NonNull
    @VisibleForTesting
    VersionInfo getVersionInfo(String versionString) {
        String[] splits = versionString.split("\\.");
        if (splits.length >= 4) {
            int major = Integer.parseInt(splits[0]);
            int minor = Integer.parseInt(splits[1]);
            int micro = Integer.parseInt(splits[2]) * 100 + Integer.parseInt(splits[3]);
            return new VersionInfo(major, minor, micro);
        }
        String logMessage = String.format("Unexpected adapter version format: %s. Returning 0.0.0 for adapter version.", versionString);
        Log.w((String)TAG, (String)logMessage);
        return new VersionInfo(0, 0, 0);
    }

    @NonNull
    public VersionInfo getSDKVersionInfo() {
        String versionString = this.appLovinSdkWrapper.getSdkVersion();
        String[] splits = versionString.split("\\.");
        if (splits.length >= 3) {
            int major = Integer.parseInt(splits[0]);
            int minor = Integer.parseInt(splits[1]);
            int patch = Integer.parseInt(splits[2]);
            return new VersionInfo(major, minor, patch);
        }
        String logMessage = String.format("Unexpected SDK version format: %s. Returning 0.0.0 for SDK version.", versionString);
        Log.w((String)TAG, (String)logMessage);
        return new VersionInfo(0, 0, 0);
    }

    public void collectSignals(@NonNull RtbSignalData rtbSignalData, @NonNull SignalCallbacks signalCallbacks) {
        MediationConfiguration config = rtbSignalData.getConfiguration();
        if (config.getFormat() == AdFormat.NATIVE) {
            AdError error = new AdError(108, "Requested to collect signal for unsupported native ad format. Ignoring...", ERROR_DOMAIN);
            Log.e((String)TAG, (String)error.getMessage());
            signalCallbacks.onFailure(error);
            return;
        }
        Log.i((String)TAG, (String)("Extras for signal collection: " + rtbSignalData.getNetworkExtras()));
        AppLovinSdk sdk = this.appLovinInitializer.retrieveSdk(config.getServerParameters(), rtbSignalData.getContext());
        String bidToken = sdk.getAdService().getBidToken();
        if (TextUtils.isEmpty((CharSequence)bidToken)) {
            AdError error = new AdError(104, "Failed to generate bid token.", ERROR_DOMAIN);
            Log.e((String)TAG, (String)error.getMessage());
            signalCallbacks.onFailure(error);
            return;
        }
        Log.i((String)TAG, (String)("Generated bid token: " + bidToken));
        signalCallbacks.onSuccess(bidToken);
    }

    public void loadBannerAd(@NonNull MediationBannerAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> callback) {
        this.bannerAd = AppLovinBannerAd.newInstance(adConfiguration, callback, this.appLovinInitializer, this.appLovinAdFactory);
        this.bannerAd.loadAd();
    }

    public void loadInterstitialAd(@NonNull MediationInterstitialAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> callback) {
        this.waterfallInterstitialAd = new AppLovinWaterfallInterstitialAd(adConfiguration, callback, this.appLovinInitializer, this.appLovinAdFactory);
        this.waterfallInterstitialAd.loadAd();
    }

    public void loadRtbInterstitialAd(@NonNull MediationInterstitialAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> callback) {
        this.rtbInterstitialRenderer = new AppLovinRtbInterstitialRenderer(adConfiguration, callback, this.appLovinInitializer, this.appLovinAdFactory);
        this.rtbInterstitialRenderer.loadAd();
    }

    public void loadRewardedAd(@NonNull MediationRewardedAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> callback) {
        this.rewardedRenderer = new AppLovinWaterfallRewardedRenderer(adConfiguration, callback, this.appLovinInitializer, this.appLovinAdFactory, this.appLovinSdkUtilsWrapper);
        this.rewardedRenderer.loadAd();
    }

    public void loadRtbRewardedAd(@NonNull MediationRewardedAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> callback) {
        this.rtbRewardedRenderer = new AppLovinRtbRewardedRenderer(adConfiguration, callback, this.appLovinInitializer, this.appLovinAdFactory, this.appLovinSdkUtilsWrapper);
        this.rtbRewardedRenderer.loadAd();
    }

    static {
        TAG = AppLovinMediationAdapter.class.getSimpleName();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AdapterError {
    }
}

