/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.vungle;

import android.content.Context;
import androidx.annotation.NonNull;
import com.google.ads.mediation.vungle.VungleMediationAdapter;
import com.google.ads.mediation.vungle.VungleSdkWrapper;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.MobileAds;
import com.vungle.ads.InitializationListener;
import com.vungle.ads.VungleAds;
import com.vungle.ads.VungleError;
import com.vungle.ads.VunglePrivacySettings;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class VungleInitializer
implements InitializationListener {
    private static final VungleInitializer instance = new VungleInitializer();
    private final AtomicBoolean isInitializing = new AtomicBoolean(false);
    private final ArrayList<VungleInitializationListener> initListeners = new ArrayList();

    @NonNull
    public static VungleInitializer getInstance() {
        return instance;
    }

    private VungleInitializer() {
        VungleAds.setIntegrationName((VungleAds.WrapperFramework)VungleAds.WrapperFramework.admob, (String)"7.3.2.0".replace('.', '_'));
    }

    public void initialize(@NonNull String appId, @NonNull Context context, @NonNull VungleInitializationListener listener) {
        if (VungleSdkWrapper.delegate.isInitialized()) {
            listener.onInitializeSuccess();
            return;
        }
        if (this.isInitializing.getAndSet(true)) {
            this.initListeners.add(listener);
            return;
        }
        this.updateCoppaStatus(MobileAds.getRequestConfiguration().getTagForChildDirectedTreatment());
        VungleSdkWrapper.delegate.init(context, appId, this);
        this.initListeners.add(listener);
    }

    public void onSuccess() {
        for (VungleInitializationListener listener : this.initListeners) {
            listener.onInitializeSuccess();
        }
        this.initListeners.clear();
        this.isInitializing.set(false);
    }

    public void onError(@NonNull VungleError vungleError) {
        AdError error = VungleMediationAdapter.getAdError(vungleError);
        for (VungleInitializationListener listener : this.initListeners) {
            listener.onInitializeError(error);
        }
        this.initListeners.clear();
        this.isInitializing.set(false);
    }

    public void updateCoppaStatus(int configuration) {
        switch (configuration) {
            case 1: {
                VunglePrivacySettings.setCOPPAStatus((boolean)true);
                break;
            }
            case 0: {
                VunglePrivacySettings.setCOPPAStatus((boolean)false);
                break;
            }
        }
    }

    public static interface VungleInitializationListener {
        public void onInitializeSuccess();

        public void onInitializeError(AdError var1);
    }
}

