/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.mediation;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.ads.mediation.vungle.VungleInitializer;
import com.google.ads.mediation.vungle.VungleMediationAdapter;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.MediationUtils;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.vungle.ads.AdConfig;
import com.vungle.ads.BannerAd;
import com.vungle.ads.BannerAdListener;
import com.vungle.ads.BannerAdSize;
import com.vungle.ads.BannerView;
import com.vungle.ads.BaseAd;
import com.vungle.ads.BaseAdListener;
import com.vungle.ads.InterstitialAd;
import com.vungle.ads.InterstitialAdListener;
import com.vungle.ads.VungleError;
import java.util.ArrayList;

@Keep
public class VungleInterstitialAdapter
implements MediationInterstitialAdapter,
MediationBannerAdapter {
    private MediationInterstitialListener mediationInterstitialListener;
    private InterstitialAd interstitialAd;
    private MediationBannerListener mediationBannerListener;
    private BannerAd bannerAd;
    private RelativeLayout bannerLayout;

    public void requestInterstitialAd(final @NonNull Context context, final @NonNull MediationInterstitialListener interstitialListener, @NonNull Bundle serverParameters, @NonNull MediationAdRequest mediationAdRequest, @Nullable Bundle mediationExtras) {
        this.mediationInterstitialListener = interstitialListener;
        String appID = serverParameters.getString("appid");
        if (TextUtils.isEmpty((CharSequence)appID)) {
            AdError error = new AdError(101, "Failed to load waterfall interstitial ad from Liftoff Monetize. Missing or invalid App ID configured for this ad source instance in the AdMob or Ad Manager UI.", "com.google.ads.mediation.vungle");
            Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
            interstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)this, error);
            return;
        }
        final String placement = serverParameters.getString("placementID");
        if (TextUtils.isEmpty((CharSequence)placement)) {
            AdError error = new AdError(101, "Failed to load waterfall interstitial ad from Liftoff Monetize. Missing or invalid Placement ID configured for this ad source instance in the AdMob or Ad Manager UI.", "com.google.ads.mediation.vungle");
            Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
            interstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)this, error);
            return;
        }
        VungleInitializer.getInstance().updateCoppaStatus(mediationAdRequest.taggedForChildDirectedTreatment());
        final AdConfig adConfig = new AdConfig();
        if (mediationExtras != null && mediationExtras.containsKey("adOrientation")) {
            adConfig.setAdOrientation(mediationExtras.getInt("adOrientation", 2));
        }
        VungleInitializer.getInstance().initialize(appID, context, new VungleInitializer.VungleInitializationListener(){

            @Override
            public void onInitializeSuccess() {
                VungleInterstitialAdapter.this.interstitialAd = new InterstitialAd(context, placement, adConfig);
                VungleInterstitialAdapter.this.interstitialAd.setAdListener((BaseAdListener)new VungleInterstitialListener());
                VungleInterstitialAdapter.this.interstitialAd.load(null);
            }

            @Override
            public void onInitializeError(AdError error) {
                interstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)VungleInterstitialAdapter.this, error);
                Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
            }
        });
    }

    public void showInterstitial() {
        if (this.interstitialAd != null) {
            this.interstitialAd.play(null);
        }
    }

    public void onDestroy() {
        Log.d((String)VungleMediationAdapter.TAG, (String)("onDestroy: " + this.hashCode()));
        if (this.bannerAd != null) {
            this.bannerLayout.removeAllViews();
            this.bannerAd.finishAd();
            this.bannerAd = null;
        }
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void requestBannerAd(final @NonNull Context context, @NonNull MediationBannerListener bannerListener, @NonNull Bundle serverParameters, final @NonNull AdSize adSize, @NonNull MediationAdRequest mediationAdRequest, @Nullable Bundle mediationExtras) {
        this.mediationBannerListener = bannerListener;
        String appID = serverParameters.getString("appid");
        if (TextUtils.isEmpty((CharSequence)appID)) {
            AdError error = new AdError(101, "Failed to load waterfall banner ad from Liftoff Monetize. Missing or invalid App ID configured for this ad source instance in the AdMob or Ad Manager UI.", "com.google.ads.mediation.vungle");
            Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
            bannerListener.onAdFailedToLoad((MediationBannerAdapter)this, error);
            return;
        }
        VungleInitializer.getInstance().updateCoppaStatus(mediationAdRequest.taggedForChildDirectedTreatment());
        final String placement = serverParameters.getString("placementID");
        if (TextUtils.isEmpty((CharSequence)placement)) {
            AdError error = new AdError(101, "Failed to load waterfall banner ad from Liftoff Monetize. Missing or invalid Placement ID configured for this ad source instance in the AdMob or Ad Manager UI.", "com.google.ads.mediation.vungle");
            Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
            bannerListener.onAdFailedToLoad((MediationBannerAdapter)this, error);
            return;
        }
        final BannerAdSize bannerAdSize = VungleInterstitialAdapter.getVungleBannerAdSizeFromGoogleAdSize(context, adSize);
        if (bannerAdSize == null) {
            AdError error = new AdError(102, "Failed to load waterfall banner ad from Liftoff Monetize. Invalid banner size.", "com.google.ads.mediation.vungle");
            Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
            bannerListener.onAdFailedToLoad((MediationBannerAdapter)this, error);
            return;
        }
        Log.d((String)VungleMediationAdapter.TAG, (String)("requestBannerAd for Placement: " + placement + " ### Adapter instance: " + this.hashCode()));
        VungleInitializer.getInstance().initialize(appID, context, new VungleInitializer.VungleInitializationListener(){

            @Override
            public void onInitializeSuccess() {
                VungleInterstitialAdapter.this.bannerLayout = new RelativeLayout(context);
                int adLayoutHeight = adSize.getHeightInPixels(context);
                if (adLayoutHeight <= 0) {
                    float density = context.getResources().getDisplayMetrics().density;
                    adLayoutHeight = Math.round((float)bannerAdSize.getHeight() * density);
                }
                RelativeLayout.LayoutParams adViewLayoutParams = new RelativeLayout.LayoutParams(adSize.getWidthInPixels(context), adLayoutHeight);
                VungleInterstitialAdapter.this.bannerLayout.setLayoutParams((ViewGroup.LayoutParams)adViewLayoutParams);
                VungleInterstitialAdapter.this.bannerAd = new BannerAd(context, placement, bannerAdSize);
                VungleInterstitialAdapter.this.bannerAd.setAdListener((BaseAdListener)new VungleBannerListener());
                VungleInterstitialAdapter.this.bannerAd.load(null);
            }

            @Override
            public void onInitializeError(AdError error) {
                Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
                if (VungleInterstitialAdapter.this.mediationBannerListener != null) {
                    VungleInterstitialAdapter.this.mediationBannerListener.onAdFailedToLoad((MediationBannerAdapter)VungleInterstitialAdapter.this, error);
                }
            }
        });
    }

    private void createBanner() {
        if (this.bannerAd == null) {
            AdError error = new AdError(106, "Try to play banner ad but the Vungle BannerAd instance not created.", "com.google.ads.mediation.vungle");
            Log.d((String)VungleMediationAdapter.TAG, (String)error.toString());
            if (this.mediationBannerListener != null) {
                this.mediationBannerListener.onAdFailedToLoad((MediationBannerAdapter)this, error);
            }
            return;
        }
        BannerView bannerView = this.bannerAd.getBannerView();
        if (bannerView == null) {
            AdError error = new AdError(106, "Vungle SDK returned a successful load callback, but getBannerView() returned null.", "com.google.ads.mediation.vungle");
            Log.d((String)VungleMediationAdapter.TAG, (String)error.toString());
            if (this.mediationBannerListener != null) {
                this.mediationBannerListener.onAdFailedToLoad((MediationBannerAdapter)this, error);
            }
            return;
        }
        RelativeLayout.LayoutParams adParams = new RelativeLayout.LayoutParams(-2, -2);
        adParams.addRule(14, -1);
        adParams.addRule(15, -1);
        bannerView.setLayoutParams((ViewGroup.LayoutParams)adParams);
        this.bannerLayout.addView((View)bannerView);
        if (this.mediationBannerListener != null) {
            this.mediationBannerListener.onAdLoaded((MediationBannerAdapter)this);
        }
    }

    @NonNull
    public View getBannerView() {
        Log.d((String)VungleMediationAdapter.TAG, (String)("getBannerView # instance: " + this.hashCode()));
        return this.bannerLayout;
    }

    public static BannerAdSize getVungleBannerAdSizeFromGoogleAdSize(Context context, AdSize adSize) {
        ArrayList<AdSize> potentials = new ArrayList<AdSize>();
        potentials.add(new AdSize(BannerAdSize.BANNER_SHORT.getWidth(), BannerAdSize.BANNER_SHORT.getHeight()));
        potentials.add(new AdSize(BannerAdSize.BANNER.getWidth(), BannerAdSize.BANNER.getHeight()));
        potentials.add(new AdSize(BannerAdSize.BANNER_LEADERBOARD.getWidth(), BannerAdSize.BANNER_LEADERBOARD.getHeight()));
        potentials.add(new AdSize(BannerAdSize.VUNGLE_MREC.getWidth(), BannerAdSize.VUNGLE_MREC.getHeight()));
        AdSize closestSize = MediationUtils.findClosestSize((Context)context, (AdSize)adSize, potentials);
        if (closestSize == null) {
            return null;
        }
        Log.d((String)VungleMediationAdapter.TAG, (String)("Found closest Liftoff Monetize banner ad size: " + closestSize + " for requested ad size: " + adSize));
        if (closestSize.getWidth() == BannerAdSize.BANNER_SHORT.getWidth() && closestSize.getHeight() == BannerAdSize.BANNER_SHORT.getHeight()) {
            return BannerAdSize.BANNER_SHORT;
        }
        if (closestSize.getWidth() == BannerAdSize.BANNER.getWidth() && closestSize.getHeight() == BannerAdSize.BANNER.getHeight()) {
            return BannerAdSize.BANNER;
        }
        if (closestSize.getWidth() == BannerAdSize.BANNER_LEADERBOARD.getWidth() && closestSize.getHeight() == BannerAdSize.BANNER_LEADERBOARD.getHeight()) {
            return BannerAdSize.BANNER_LEADERBOARD;
        }
        if (closestSize.getWidth() == BannerAdSize.VUNGLE_MREC.getWidth() && closestSize.getHeight() == BannerAdSize.VUNGLE_MREC.getHeight()) {
            return BannerAdSize.VUNGLE_MREC;
        }
        return null;
    }

    private class VungleBannerListener
    implements BannerAdListener {
        private VungleBannerListener() {
        }

        public void onAdClicked(@NonNull BaseAd baseAd) {
            if (VungleInterstitialAdapter.this.mediationBannerListener != null) {
                VungleInterstitialAdapter.this.mediationBannerListener.onAdClicked((MediationBannerAdapter)VungleInterstitialAdapter.this);
                VungleInterstitialAdapter.this.mediationBannerListener.onAdOpened((MediationBannerAdapter)VungleInterstitialAdapter.this);
            }
        }

        public void onAdEnd(@NonNull BaseAd baseAd) {
        }

        public void onAdImpression(@NonNull BaseAd baseAd) {
        }

        public void onAdLoaded(@NonNull BaseAd baseAd) {
            VungleInterstitialAdapter.this.createBanner();
        }

        public void onAdStart(@NonNull BaseAd baseAd) {
        }

        public void onAdFailedToPlay(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
            AdError error = VungleMediationAdapter.getAdError(vungleError);
            Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
        }

        public void onAdFailedToLoad(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
            AdError error = VungleMediationAdapter.getAdError(vungleError);
            Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
            if (VungleInterstitialAdapter.this.mediationBannerListener != null) {
                VungleInterstitialAdapter.this.mediationBannerListener.onAdFailedToLoad((MediationBannerAdapter)VungleInterstitialAdapter.this, error);
            }
        }

        public void onAdLeftApplication(@NonNull BaseAd baseAd) {
            if (VungleInterstitialAdapter.this.mediationBannerListener != null) {
                VungleInterstitialAdapter.this.mediationBannerListener.onAdLeftApplication((MediationBannerAdapter)VungleInterstitialAdapter.this);
            }
        }
    }

    private class VungleInterstitialListener
    implements InterstitialAdListener {
        private VungleInterstitialListener() {
        }

        public void onAdLoaded(@NonNull BaseAd baseAd) {
            if (VungleInterstitialAdapter.this.mediationInterstitialListener != null) {
                VungleInterstitialAdapter.this.mediationInterstitialListener.onAdLoaded((MediationInterstitialAdapter)VungleInterstitialAdapter.this);
            }
        }

        public void onAdStart(@NonNull BaseAd baseAd) {
            if (VungleInterstitialAdapter.this.mediationInterstitialListener != null) {
                VungleInterstitialAdapter.this.mediationInterstitialListener.onAdOpened((MediationInterstitialAdapter)VungleInterstitialAdapter.this);
            }
        }

        public void onAdEnd(@NonNull BaseAd baseAd) {
            if (VungleInterstitialAdapter.this.mediationInterstitialListener != null) {
                VungleInterstitialAdapter.this.mediationInterstitialListener.onAdClosed((MediationInterstitialAdapter)VungleInterstitialAdapter.this);
            }
        }

        public void onAdClicked(@NonNull BaseAd baseAd) {
            if (VungleInterstitialAdapter.this.mediationInterstitialListener != null) {
                VungleInterstitialAdapter.this.mediationInterstitialListener.onAdClicked((MediationInterstitialAdapter)VungleInterstitialAdapter.this);
            }
        }

        public void onAdLeftApplication(@NonNull BaseAd baseAd) {
            if (VungleInterstitialAdapter.this.mediationInterstitialListener != null) {
                VungleInterstitialAdapter.this.mediationInterstitialListener.onAdLeftApplication((MediationInterstitialAdapter)VungleInterstitialAdapter.this);
            }
        }

        public void onAdFailedToPlay(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
            AdError error = VungleMediationAdapter.getAdError(vungleError);
            Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
        }

        public void onAdFailedToLoad(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
            AdError error = VungleMediationAdapter.getAdError(vungleError);
            Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
            if (VungleInterstitialAdapter.this.mediationInterstitialListener != null) {
                VungleInterstitialAdapter.this.mediationInterstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)VungleInterstitialAdapter.this, error);
            }
        }

        public void onAdImpression(@NonNull BaseAd baseAd) {
        }
    }
}

