/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.vungle;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.ads.mediation.vungle.VungleFactory;
import com.google.ads.mediation.vungle.VungleInitializer;
import com.google.ads.mediation.vungle.VungleSdkWrapper;
import com.google.ads.mediation.vungle.rtb.VungleRtbAppOpenAd;
import com.google.ads.mediation.vungle.rtb.VungleRtbBannerAd;
import com.google.ads.mediation.vungle.rtb.VungleRtbInterstitialAd;
import com.google.ads.mediation.vungle.rtb.VungleRtbNativeAd;
import com.google.ads.mediation.vungle.rtb.VungleRtbRewardedAd;
import com.google.ads.mediation.vungle.waterfall.VungleWaterfallAppOpenAd;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.mediation.InitializationCompleteCallback;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationAppOpenAd;
import com.google.android.gms.ads.mediation.MediationAppOpenAdCallback;
import com.google.android.gms.ads.mediation.MediationAppOpenAdConfiguration;
import com.google.android.gms.ads.mediation.MediationBannerAd;
import com.google.android.gms.ads.mediation.MediationBannerAdCallback;
import com.google.android.gms.ads.mediation.MediationBannerAdConfiguration;
import com.google.android.gms.ads.mediation.MediationConfiguration;
import com.google.android.gms.ads.mediation.MediationInterstitialAd;
import com.google.android.gms.ads.mediation.MediationInterstitialAdCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAdConfiguration;
import com.google.android.gms.ads.mediation.MediationNativeAdCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdConfiguration;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.ads.mediation.rtb.RtbAdapter;
import com.google.android.gms.ads.mediation.rtb.RtbSignalData;
import com.google.android.gms.ads.mediation.rtb.SignalCallbacks;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.vungle.ads.AdConfig;
import com.vungle.ads.BaseAd;
import com.vungle.ads.BaseAdListener;
import com.vungle.ads.RewardedAd;
import com.vungle.ads.RewardedAdListener;
import com.vungle.ads.VungleError;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashSet;
import java.util.List;

public class VungleMediationAdapter
extends RtbAdapter
implements MediationRewardedAd,
RewardedAdListener {
    public static final String TAG = VungleMediationAdapter.class.getSimpleName();
    private VungleWaterfallAppOpenAd waterfallAppOpenAd;
    private VungleRtbBannerAd rtbBannerAd;
    private VungleRtbInterstitialAd rtbInterstitialAd;
    private VungleRtbRewardedAd rtbRewardedAd;
    private VungleRtbRewardedAd rtbRewardedInterstitialAd;
    private VungleRtbNativeAd rtbNativeAd;
    private VungleRtbAppOpenAd rtbAppOpenAd;
    private AdConfig adConfig;
    private String userId;
    private RewardedAd rewardedAd;
    private MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> mediationAdLoadCallback;
    private MediationRewardedAdCallback mediationRewardedAdCallback;
    private final VungleFactory vungleFactory;
    public static final String ERROR_DOMAIN = "com.google.ads.mediation.vungle";
    public static final String VUNGLE_SDK_ERROR_DOMAIN = "com.vungle.ads";
    public static final int ERROR_INVALID_SERVER_PARAMETERS = 101;
    public static final int ERROR_BANNER_SIZE_MISMATCH = 102;
    public static final int ERROR_REQUIRES_ACTIVITY_CONTEXT = 103;
    public static final int ERROR_INITIALIZATION_FAILURE = 105;
    public static final int ERROR_VUNGLE_BANNER_NULL = 106;
    public static final int ERROR_CANNOT_PLAY_AD = 107;
    public static final int ERROR_CANNOT_GET_BID_TOKEN = 108;

    public VungleMediationAdapter() {
        this.vungleFactory = new VungleFactory();
    }

    @VisibleForTesting
    VungleMediationAdapter(VungleFactory vungleFactory) {
        this.vungleFactory = vungleFactory;
    }

    @NonNull
    public static AdError getAdError(@NonNull VungleError vungleError) {
        return new AdError(vungleError.getCode(), vungleError.getErrorMessage(), VUNGLE_SDK_ERROR_DOMAIN);
    }

    @NonNull
    public VersionInfo getVersionInfo() {
        String versionString = VungleMediationAdapter.getAdapterVersion();
        String[] splits = versionString.split("\\.");
        if (splits.length >= 4) {
            int major = Integer.parseInt(splits[0]);
            int minor = Integer.parseInt(splits[1]);
            int micro = Integer.parseInt(splits[2]) * 100 + Integer.parseInt(splits[3]);
            return new VersionInfo(major, minor, micro);
        }
        String logMessage = String.format("Unexpected adapter version format: %s. Returning 0.0.0 for adapter version.", versionString);
        Log.w((String)TAG, (String)logMessage);
        return new VersionInfo(0, 0, 0);
    }

    @NonNull
    public VersionInfo getSDKVersionInfo() {
        String versionString = VungleSdkWrapper.delegate.getSdkVersion();
        String[] splits = versionString.split("\\.");
        if (splits.length >= 3) {
            int major = Integer.parseInt(splits[0]);
            int minor = Integer.parseInt(splits[1]);
            int micro = Integer.parseInt(splits[2]);
            return new VersionInfo(major, minor, micro);
        }
        String logMessage = String.format("Unexpected SDK version format: %s. Returning 0.0.0 for SDK version.", versionString);
        Log.w((String)TAG, (String)logMessage);
        return new VersionInfo(0, 0, 0);
    }

    public void collectSignals(@NonNull RtbSignalData rtbSignalData, @NonNull SignalCallbacks signalCallbacks) {
        String token = VungleSdkWrapper.delegate.getBiddingToken(rtbSignalData.getContext());
        if (TextUtils.isEmpty((CharSequence)token)) {
            AdError error = new AdError(108, "Liftoff Monetize returned an empty bid token.", ERROR_DOMAIN);
            Log.w((String)TAG, (String)error.toString());
            signalCallbacks.onFailure(error);
        } else {
            Log.d((String)TAG, (String)("Liftoff Monetize bidding token=" + token));
            signalCallbacks.onSuccess(token);
        }
    }

    public void initialize(@NonNull Context context, final @NonNull InitializationCompleteCallback initializationCompleteCallback, @NonNull List<MediationConfiguration> mediationConfigurations) {
        if (VungleSdkWrapper.delegate.isInitialized()) {
            initializationCompleteCallback.onInitializationSucceeded();
            return;
        }
        HashSet<String> appIDs = new HashSet<String>();
        for (MediationConfiguration configuration : mediationConfigurations) {
            Bundle serverParameters = configuration.getServerParameters();
            String appIDFromServer = serverParameters.getString("appid");
            if (TextUtils.isEmpty((CharSequence)appIDFromServer)) continue;
            appIDs.add(appIDFromServer);
        }
        int count = appIDs.size();
        if (count <= 0) {
            if (initializationCompleteCallback != null) {
                AdError error = new AdError(101, "Missing or Invalid App ID.", ERROR_DOMAIN);
                Log.w((String)TAG, (String)error.toString());
                initializationCompleteCallback.onInitializationFailed(error.toString());
            }
            return;
        }
        String appID = (String)appIDs.iterator().next();
        if (count > 1) {
            String logMessage = String.format("Multiple '%s' entries found: %s. Using '%s' to initialize the Vungle SDK.", "appid", appIDs, appID);
            Log.w((String)TAG, (String)logMessage);
        }
        VungleInitializer.getInstance().initialize(appID, context, new VungleInitializer.VungleInitializationListener(){

            @Override
            public void onInitializeSuccess() {
                initializationCompleteCallback.onInitializationSucceeded();
            }

            @Override
            public void onInitializeError(AdError error) {
                Log.w((String)TAG, (String)error.toString());
                initializationCompleteCallback.onInitializationFailed(error.toString());
            }
        });
    }

    public void loadRewardedAd(@NonNull MediationRewardedAdConfiguration mediationRewardedAdConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> mediationAdLoadCallback) {
        String appID;
        this.mediationAdLoadCallback = mediationAdLoadCallback;
        Bundle mediationExtras = mediationRewardedAdConfiguration.getMediationExtras();
        Bundle serverParameters = mediationRewardedAdConfiguration.getServerParameters();
        if (mediationExtras != null) {
            this.userId = mediationExtras.getString("userId");
        }
        if (TextUtils.isEmpty((CharSequence)(appID = serverParameters.getString("appid")))) {
            AdError error = new AdError(101, "Failed to load waterfall rewarded ad from Liftoff Monetize. Missing or invalid App ID configured for this ad source instance in the AdMob or Ad Manager UI.", ERROR_DOMAIN);
            Log.w((String)TAG, (String)error.toString());
            mediationAdLoadCallback.onFailure(error);
            return;
        }
        final String placement = serverParameters.getString("placementID");
        if (TextUtils.isEmpty((CharSequence)placement)) {
            AdError error = new AdError(101, "Failed to load waterfall rewarded ad from Liftoff Monetize. Missing or Invalid Placement ID configured for this ad source instance in the AdMob or Ad Manager UI.", ERROR_DOMAIN);
            Log.w((String)TAG, (String)error.toString());
            mediationAdLoadCallback.onFailure(error);
            return;
        }
        this.adConfig = this.vungleFactory.createAdConfig();
        if (mediationExtras != null && mediationExtras.containsKey("adOrientation")) {
            this.adConfig.setAdOrientation(mediationExtras.getInt("adOrientation", 2));
        }
        VungleInitializer.getInstance().updateCoppaStatus(mediationRewardedAdConfiguration.taggedForChildDirectedTreatment());
        final Context context = mediationRewardedAdConfiguration.getContext();
        VungleInitializer.getInstance().initialize(appID, context, new VungleInitializer.VungleInitializationListener(){

            @Override
            public void onInitializeSuccess() {
                VungleMediationAdapter.this.rewardedAd = VungleMediationAdapter.this.vungleFactory.createRewardedAd(context, placement, VungleMediationAdapter.this.adConfig);
                VungleMediationAdapter.this.rewardedAd.setAdListener((BaseAdListener)VungleMediationAdapter.this);
                if (!TextUtils.isEmpty((CharSequence)VungleMediationAdapter.this.userId)) {
                    VungleMediationAdapter.this.rewardedAd.setUserId(VungleMediationAdapter.this.userId);
                }
                VungleMediationAdapter.this.rewardedAd.load(null);
            }

            @Override
            public void onInitializeError(AdError error) {
                Log.w((String)TAG, (String)error.toString());
                VungleMediationAdapter.this.mediationAdLoadCallback.onFailure(error);
            }
        });
    }

    public void showAd(@NonNull Context context) {
        if (this.rewardedAd != null) {
            this.rewardedAd.play(context);
        } else if (this.mediationRewardedAdCallback != null) {
            AdError error = new AdError(107, "Failed to show waterfall rewarded ad from Liftoff Monetize.", ERROR_DOMAIN);
            Log.w((String)TAG, (String)error.toString());
            this.mediationRewardedAdCallback.onAdFailedToShow(error);
        }
    }

    public void onAdLoaded(@NonNull BaseAd baseAd) {
        Log.d((String)TAG, (String)"Loaded waterfall rewarded ad from Liftoff Monetize.");
        if (this.mediationAdLoadCallback != null) {
            this.mediationRewardedAdCallback = (MediationRewardedAdCallback)this.mediationAdLoadCallback.onSuccess((Object)this);
        }
    }

    public void onAdStart(@NonNull BaseAd baseAd) {
        Log.d((String)TAG, (String)"Liftoff Monetize waterfall rewarded ad has started.");
        if (this.mediationRewardedAdCallback != null) {
            this.mediationRewardedAdCallback.onAdOpened();
        }
    }

    public void onAdEnd(@NonNull BaseAd baseAd) {
        Log.d((String)TAG, (String)"Liftoff Monetize waterfall rewarded ad has ended.");
        if (this.mediationRewardedAdCallback != null) {
            this.mediationRewardedAdCallback.onAdClosed();
        }
    }

    public void onAdClicked(@NonNull BaseAd baseAd) {
        Log.d((String)TAG, (String)"Liftoff Monetize waterfall rewarded ad was clicked.");
        if (this.mediationRewardedAdCallback != null) {
            this.mediationRewardedAdCallback.reportAdClicked();
        }
    }

    public void onAdRewarded(@NonNull BaseAd baseAd) {
        Log.d((String)TAG, (String)"Received reward from Liftoff Monetize waterfall rewarded ad.");
        if (this.mediationRewardedAdCallback != null) {
            this.mediationRewardedAdCallback.onVideoComplete();
            this.mediationRewardedAdCallback.onUserEarnedReward((RewardItem)new VungleReward("vungle", 1));
        }
    }

    public void onAdLeftApplication(@NonNull BaseAd baseAd) {
    }

    public void onAdFailedToPlay(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
        AdError error = VungleMediationAdapter.getAdError(vungleError);
        Log.w((String)TAG, (String)("Failed to play waterfall rewarded ad from Liftoff Monetize with error: " + error.toString()));
        if (this.mediationRewardedAdCallback != null) {
            this.mediationRewardedAdCallback.onAdFailedToShow(error);
        }
    }

    public void onAdFailedToLoad(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
        AdError error = VungleMediationAdapter.getAdError(vungleError);
        Log.w((String)TAG, (String)("Failed to load waterfall rewarded ad from Liftoff Monetize with error: " + error.toString()));
        if (this.mediationAdLoadCallback != null) {
            this.mediationAdLoadCallback.onFailure(error);
        }
    }

    public void onAdImpression(@NonNull BaseAd baseAd) {
        this.mediationRewardedAdCallback.onVideoStart();
        this.mediationRewardedAdCallback.reportAdImpression();
    }

    public void loadNativeAd(@NonNull MediationNativeAdConfiguration mediationNativeAdConfiguration, @NonNull MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> callback) {
        Log.d((String)TAG, (String)"loadNativeAd()...");
        VungleInitializer.getInstance().updateCoppaStatus(mediationNativeAdConfiguration.taggedForChildDirectedTreatment());
        this.rtbNativeAd = new VungleRtbNativeAd(mediationNativeAdConfiguration, callback, this.vungleFactory);
        this.rtbNativeAd.render();
    }

    public void loadRewardedInterstitialAd(@NonNull MediationRewardedAdConfiguration mediationRewardedAdConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> callback) {
        Log.d((String)TAG, (String)"loadRewardedInterstitialAd()...");
        Log.d((String)TAG, (String)"Liftoff Monetize adapter was asked to load a rewarded interstitial ad. Using the rewarded ad request flow to load the ad to attempt to load a rewarded interstitial ad from Liftoff Monetize.");
        this.loadRewardedAd(mediationRewardedAdConfiguration, callback);
    }

    public void loadAppOpenAd(@NonNull MediationAppOpenAdConfiguration mediationAppOpenAdConfiguration, @NonNull MediationAdLoadCallback<MediationAppOpenAd, MediationAppOpenAdCallback> callback) {
        VungleInitializer.getInstance().updateCoppaStatus(mediationAppOpenAdConfiguration.taggedForChildDirectedTreatment());
        this.waterfallAppOpenAd = new VungleWaterfallAppOpenAd(mediationAppOpenAdConfiguration, callback, this.vungleFactory);
        this.waterfallAppOpenAd.render();
    }

    public void loadRtbRewardedAd(@NonNull MediationRewardedAdConfiguration mediationRewardedAdConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> mediationAdLoadCallback) {
        Log.d((String)TAG, (String)"loadRtbRewardedAd()...");
        VungleInitializer.getInstance().updateCoppaStatus(mediationRewardedAdConfiguration.taggedForChildDirectedTreatment());
        this.rtbRewardedAd = new VungleRtbRewardedAd(mediationRewardedAdConfiguration, mediationAdLoadCallback, this.vungleFactory);
        this.rtbRewardedAd.render();
    }

    public void loadRtbBannerAd(@NonNull MediationBannerAdConfiguration mediationBannerAdConfiguration, @NonNull MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> mediationAdLoadCallback) {
        Log.d((String)TAG, (String)"loadRtbBannerAd()...");
        VungleInitializer.getInstance().updateCoppaStatus(mediationBannerAdConfiguration.taggedForChildDirectedTreatment());
        this.rtbBannerAd = new VungleRtbBannerAd(mediationBannerAdConfiguration, mediationAdLoadCallback, this.vungleFactory);
        this.rtbBannerAd.render();
    }

    public void loadRtbInterstitialAd(@NonNull MediationInterstitialAdConfiguration mediationInterstitialAdConfiguration, @NonNull MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> mediationAdLoadCallback) {
        Log.d((String)TAG, (String)"loadRtbInterstitialAd()...");
        VungleInitializer.getInstance().updateCoppaStatus(mediationInterstitialAdConfiguration.taggedForChildDirectedTreatment());
        this.rtbInterstitialAd = new VungleRtbInterstitialAd(mediationInterstitialAdConfiguration, mediationAdLoadCallback, this.vungleFactory);
        this.rtbInterstitialAd.render();
    }

    public void loadRtbNativeAd(@NonNull MediationNativeAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> callback) {
        Log.d((String)TAG, (String)"loadRtbNativeAd()...");
        VungleInitializer.getInstance().updateCoppaStatus(adConfiguration.taggedForChildDirectedTreatment());
        this.rtbNativeAd = new VungleRtbNativeAd(adConfiguration, callback, this.vungleFactory);
        this.rtbNativeAd.render();
    }

    public void loadRtbRewardedInterstitialAd(@NonNull MediationRewardedAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> callback) {
        Log.d((String)TAG, (String)"loadRtbRewardedInterstitialAd()...");
        Log.d((String)TAG, (String)"Liftoff Monetize adapter was asked to load a rewarded interstitial ad. Using the rewarded ad request flow to load the ad to attempt to load a rewarded interstitial ad from Liftoff Monetize.");
        VungleInitializer.getInstance().updateCoppaStatus(adConfiguration.taggedForChildDirectedTreatment());
        this.rtbRewardedInterstitialAd = new VungleRtbRewardedAd(adConfiguration, callback, this.vungleFactory);
        this.rtbRewardedInterstitialAd.render();
    }

    public void loadRtbAppOpenAd(@NonNull MediationAppOpenAdConfiguration mediationAppOpenAdConfiguration, @NonNull MediationAdLoadCallback<MediationAppOpenAd, MediationAppOpenAdCallback> callback) {
        VungleInitializer.getInstance().updateCoppaStatus(mediationAppOpenAdConfiguration.taggedForChildDirectedTreatment());
        this.rtbAppOpenAd = new VungleRtbAppOpenAd(mediationAppOpenAdConfiguration, callback, this.vungleFactory);
        this.rtbAppOpenAd.render();
    }

    static String getAdapterVersion() {
        return "7.3.2.0";
    }

    public static class VungleReward
    implements RewardItem {
        private final String type;
        private final int amount;

        public VungleReward(String type, int amount) {
            this.type = type;
            this.amount = amount;
        }

        public int getAmount() {
            return this.amount;
        }

        @NonNull
        public String getType() {
            return this.type;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AdapterError {
    }
}

