/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.vungle.rtb;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import com.google.ads.mediation.vungle.VungleFactory;
import com.google.ads.mediation.vungle.VungleInitializer;
import com.google.ads.mediation.vungle.VungleMediationAdapter;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationBannerAd;
import com.google.android.gms.ads.mediation.MediationBannerAdCallback;
import com.google.android.gms.ads.mediation.MediationBannerAdConfiguration;
import com.vungle.ads.BannerAd;
import com.vungle.ads.BannerAdListener;
import com.vungle.ads.BannerAdSize;
import com.vungle.ads.BannerView;
import com.vungle.ads.BaseAd;
import com.vungle.ads.BaseAdListener;
import com.vungle.ads.VungleError;
import com.vungle.mediation.VungleInterstitialAdapter;

public class VungleRtbBannerAd
implements MediationBannerAd,
BannerAdListener {
    private final MediationBannerAdConfiguration mediationBannerAdConfiguration;
    private final MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> mediationAdLoadCallback;
    private MediationBannerAdCallback mediationBannerAdCallback;
    private BannerAd bannerAd;
    private RelativeLayout bannerLayout;
    private final VungleFactory vungleFactory;

    public VungleRtbBannerAd(@NonNull MediationBannerAdConfiguration mediationBannerAdConfiguration, @NonNull MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> mediationAdLoadCallback, VungleFactory vungleFactory) {
        this.mediationBannerAdConfiguration = mediationBannerAdConfiguration;
        this.mediationAdLoadCallback = mediationAdLoadCallback;
        this.vungleFactory = vungleFactory;
    }

    public void render() {
        AdSize adSize;
        Bundle serverParameters = this.mediationBannerAdConfiguration.getServerParameters();
        String appID = serverParameters.getString("appid");
        if (TextUtils.isEmpty((CharSequence)appID)) {
            AdError error = new AdError(101, "Failed to load bidding banner ad from Liftoff Monetize. Missing or invalid App ID configured for this ad source instance in the AdMob or Ad Manager UI.", "com.google.ads.mediation.vungle");
            Log.e((String)VungleMediationAdapter.TAG, (String)error.getMessage());
            this.mediationAdLoadCallback.onFailure(error);
            return;
        }
        final String placementForPlay = serverParameters.getString("placementID");
        if (TextUtils.isEmpty((CharSequence)placementForPlay)) {
            AdError error = new AdError(101, "Failed to load bidding banner ad from Liftoff Monetize. Missing or Invalid Placement ID configured for this ad source instance in the AdMob or Ad Manager UI.", "com.google.ads.mediation.vungle");
            Log.e((String)VungleMediationAdapter.TAG, (String)error.getMessage());
            this.mediationAdLoadCallback.onFailure(error);
            return;
        }
        final Context context = this.mediationBannerAdConfiguration.getContext();
        final BannerAdSize bannerAdSize = VungleInterstitialAdapter.getVungleBannerAdSizeFromGoogleAdSize(context, adSize = this.mediationBannerAdConfiguration.getAdSize());
        if (bannerAdSize == null) {
            AdError error = new AdError(102, String.format("The requested banner size: %s is not supported by Vungle SDK.", adSize), "com.google.ads.mediation.vungle");
            Log.e((String)VungleMediationAdapter.TAG, (String)error.getMessage());
            this.mediationAdLoadCallback.onFailure(error);
            return;
        }
        final String adMarkup = this.mediationBannerAdConfiguration.getBidResponse();
        final String watermark = this.mediationBannerAdConfiguration.getWatermark();
        VungleInitializer.getInstance().initialize(appID, context, new VungleInitializer.VungleInitializationListener(){

            @Override
            public void onInitializeSuccess() {
                VungleRtbBannerAd.this.loadBanner(context, placementForPlay, adSize, bannerAdSize, adMarkup, watermark);
            }

            @Override
            public void onInitializeError(AdError error) {
                Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
                VungleRtbBannerAd.this.mediationAdLoadCallback.onFailure(error);
            }
        });
    }

    private void loadBanner(Context context, String placementId, AdSize gAdSize, BannerAdSize bannerAdSize, String adMarkup, String watermark) {
        this.bannerLayout = new RelativeLayout(context);
        int adLayoutHeight = gAdSize.getHeightInPixels(context);
        if (adLayoutHeight <= 0) {
            float density = context.getResources().getDisplayMetrics().density;
            adLayoutHeight = Math.round((float)bannerAdSize.getHeight() * density);
        }
        RelativeLayout.LayoutParams adViewLayoutParams = new RelativeLayout.LayoutParams(gAdSize.getWidthInPixels(context), adLayoutHeight);
        this.bannerLayout.setLayoutParams((ViewGroup.LayoutParams)adViewLayoutParams);
        this.bannerAd = this.vungleFactory.createBannerAd(context, placementId, bannerAdSize);
        this.bannerAd.setAdListener((BaseAdListener)this);
        if (!TextUtils.isEmpty((CharSequence)watermark)) {
            this.bannerAd.getAdConfig().setWatermark(watermark);
        }
        this.bannerAd.load(adMarkup);
    }

    @NonNull
    public View getView() {
        return this.bannerLayout;
    }

    public void onAdClicked(@NonNull BaseAd baseAd) {
        if (this.mediationBannerAdCallback != null) {
            this.mediationBannerAdCallback.reportAdClicked();
            this.mediationBannerAdCallback.onAdOpened();
        }
    }

    public void onAdEnd(@NonNull BaseAd baseAd) {
    }

    public void onAdImpression(@NonNull BaseAd baseAd) {
        if (this.mediationBannerAdCallback != null) {
            this.mediationBannerAdCallback.reportAdImpression();
        }
    }

    public void onAdLoaded(@NonNull BaseAd baseAd) {
        this.createBanner();
    }

    public void onAdStart(@NonNull BaseAd baseAd) {
    }

    public void onAdFailedToPlay(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
        AdError error = VungleMediationAdapter.getAdError(vungleError);
        Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
    }

    public void onAdFailedToLoad(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
        AdError error = VungleMediationAdapter.getAdError(vungleError);
        Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
        this.mediationAdLoadCallback.onFailure(error);
    }

    public void onAdLeftApplication(@NonNull BaseAd baseAd) {
        if (this.mediationBannerAdCallback != null) {
            this.mediationBannerAdCallback.onAdLeftApplication();
        }
    }

    private void createBanner() {
        BannerView bannerView = this.bannerAd.getBannerView();
        if (bannerView == null) {
            AdError error = new AdError(106, "Vungle SDK returned a successful load callback, but getBannerView() returned null.", "com.google.ads.mediation.vungle");
            Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
            this.mediationAdLoadCallback.onFailure(error);
            return;
        }
        RelativeLayout.LayoutParams adParams = new RelativeLayout.LayoutParams(-2, -2);
        adParams.addRule(14, -1);
        adParams.addRule(15, -1);
        bannerView.setLayoutParams((ViewGroup.LayoutParams)adParams);
        this.bannerLayout.addView((View)bannerView);
        this.mediationBannerAdCallback = (MediationBannerAdCallback)this.mediationAdLoadCallback.onSuccess((Object)this);
    }
}

