/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.vungle.renderers;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.google.ads.mediation.vungle.VungleFactory;
import com.google.ads.mediation.vungle.VungleInitializer;
import com.google.ads.mediation.vungle.VungleMediationAdapter;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationAppOpenAd;
import com.google.android.gms.ads.mediation.MediationAppOpenAdCallback;
import com.google.android.gms.ads.mediation.MediationAppOpenAdConfiguration;
import com.vungle.ads.AdConfig;
import com.vungle.ads.BaseAd;
import com.vungle.ads.BaseAdListener;
import com.vungle.ads.InterstitialAd;
import com.vungle.ads.InterstitialAdListener;
import com.vungle.ads.VungleError;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0003\u001a\u00020\u0004H&J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u0004H&J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010 \u001a\u00020\u0011J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/google/ads/mediation/vungle/renderers/VungleAppOpenAd;", "Lcom/google/android/gms/ads/mediation/MediationAppOpenAd;", "Lcom/vungle/ads/InterstitialAdListener;", "mediationAppOpenAdConfiguration", "Lcom/google/android/gms/ads/mediation/MediationAppOpenAdConfiguration;", "mediationAdLoadCallback", "Lcom/google/android/gms/ads/mediation/MediationAdLoadCallback;", "Lcom/google/android/gms/ads/mediation/MediationAppOpenAdCallback;", "vungleFactory", "Lcom/google/ads/mediation/vungle/VungleFactory;", "(Lcom/google/android/gms/ads/mediation/MediationAppOpenAdConfiguration;Lcom/google/android/gms/ads/mediation/MediationAdLoadCallback;Lcom/google/ads/mediation/vungle/VungleFactory;)V", "appOpenAd", "Lcom/vungle/ads/InterstitialAd;", "mediationAppOpenAdCallback", "getAdMarkup", "", "maybeAddWatermarkToVungleAdConfig", "", "adConfig", "Lcom/vungle/ads/AdConfig;", "onAdClicked", "baseAd", "Lcom/vungle/ads/BaseAd;", "onAdEnd", "onAdFailedToLoad", "adError", "Lcom/vungle/ads/VungleError;", "onAdFailedToPlay", "onAdImpression", "onAdLeftApplication", "onAdLoaded", "onAdStart", "render", "showAd", "context", "Landroid/content/Context;", "liftoffmonetize_release"})
public abstract class VungleAppOpenAd
implements MediationAppOpenAd,
InterstitialAdListener {
    @NotNull
    private final MediationAppOpenAdConfiguration mediationAppOpenAdConfiguration;
    @NotNull
    private final MediationAdLoadCallback<MediationAppOpenAd, MediationAppOpenAdCallback> mediationAdLoadCallback;
    @NotNull
    private final VungleFactory vungleFactory;
    private InterstitialAd appOpenAd;
    @Nullable
    private MediationAppOpenAdCallback mediationAppOpenAdCallback;

    public VungleAppOpenAd(@NotNull MediationAppOpenAdConfiguration mediationAppOpenAdConfiguration, @NotNull MediationAdLoadCallback<MediationAppOpenAd, MediationAppOpenAdCallback> mediationAdLoadCallback, @NotNull VungleFactory vungleFactory) {
        Intrinsics.checkNotNullParameter((Object)mediationAppOpenAdConfiguration, (String)"mediationAppOpenAdConfiguration");
        Intrinsics.checkNotNullParameter(mediationAdLoadCallback, (String)"mediationAdLoadCallback");
        Intrinsics.checkNotNullParameter((Object)vungleFactory, (String)"vungleFactory");
        this.mediationAppOpenAdConfiguration = mediationAppOpenAdConfiguration;
        this.mediationAdLoadCallback = mediationAdLoadCallback;
        this.vungleFactory = vungleFactory;
    }

    public final void render() {
        Bundle bundle = this.mediationAppOpenAdConfiguration.getMediationExtras();
        Intrinsics.checkNotNullExpressionValue((Object)bundle, (String)"mediationAppOpenAdConfiguration.mediationExtras");
        Bundle mediationExtras = bundle;
        Bundle bundle2 = this.mediationAppOpenAdConfiguration.getServerParameters();
        Intrinsics.checkNotNullExpressionValue((Object)bundle2, (String)"mediationAppOpenAdConfiguration.serverParameters");
        Bundle serverParameters = bundle2;
        String appId = serverParameters.getString("appid");
        CharSequence charSequence = appId;
        if (charSequence == null || charSequence.length() == 0) {
            AdError error = new AdError(101, "Failed to load app open ad from Liftoff Monetize. Missing or invalid App ID configured for this ad source instance in the AdMob or Ad Manager UI.", "com.google.ads.mediation.vungle");
            Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
            this.mediationAdLoadCallback.onFailure(error);
            return;
        }
        String placement = serverParameters.getString("placementID");
        CharSequence charSequence2 = placement;
        if (charSequence2 == null || charSequence2.length() == 0) {
            AdError error = new AdError(101, "Failed to load app open ad from Liftoff Monetize. Missing or Invalid Placement ID configured for this ad source instance in the AdMob or Ad Manager UI.", "com.google.ads.mediation.vungle");
            Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
            this.mediationAdLoadCallback.onFailure(error);
            return;
        }
        Context context = this.mediationAppOpenAdConfiguration.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"mediationAppOpenAdConfiguration.context");
        Context context2 = context;
        VungleInitializer vungleInitializer = VungleInitializer.getInstance();
        String string = appId;
        Intrinsics.checkNotNull((Object)string);
        vungleInitializer.initialize(string, context2, new VungleInitializer.VungleInitializationListener(this, mediationExtras, context2, placement){
            final /* synthetic */ VungleAppOpenAd this$0;
            final /* synthetic */ Bundle $mediationExtras;
            final /* synthetic */ Context $context;
            final /* synthetic */ String $placement;
            {
                this.this$0 = $receiver;
                this.$mediationExtras = $mediationExtras;
                this.$context = $context;
                this.$placement = $placement;
            }

            public void onInitializeSuccess() {
                AdConfig adConfig = VungleAppOpenAd.access$getVungleFactory$p(this.this$0).createAdConfig();
                if (this.$mediationExtras.containsKey("adOrientation")) {
                    adConfig.setAdOrientation(this.$mediationExtras.getInt("adOrientation", 2));
                }
                this.this$0.maybeAddWatermarkToVungleAdConfig(adConfig, VungleAppOpenAd.access$getMediationAppOpenAdConfiguration$p(this.this$0));
                VungleFactory vungleFactory = VungleAppOpenAd.access$getVungleFactory$p(this.this$0);
                String string = this.$placement;
                Intrinsics.checkNotNull((Object)string);
                VungleAppOpenAd.access$setAppOpenAd$p(this.this$0, vungleFactory.createInterstitialAd(this.$context, string, adConfig));
                InterstitialAd interstitialAd = VungleAppOpenAd.access$getAppOpenAd$p(this.this$0);
                if (interstitialAd == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"appOpenAd");
                    interstitialAd = null;
                }
                interstitialAd.setAdListener((BaseAdListener)this.this$0);
                InterstitialAd interstitialAd2 = VungleAppOpenAd.access$getAppOpenAd$p(this.this$0);
                if (interstitialAd2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"appOpenAd");
                    interstitialAd2 = null;
                }
                interstitialAd2.load(this.this$0.getAdMarkup(VungleAppOpenAd.access$getMediationAppOpenAdConfiguration$p(this.this$0)));
            }

            public void onInitializeError(@NotNull AdError error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
                VungleAppOpenAd.access$getMediationAdLoadCallback$p(this.this$0).onFailure(error);
            }
        });
    }

    @Nullable
    public abstract String getAdMarkup(@NotNull MediationAppOpenAdConfiguration var1);

    public abstract void maybeAddWatermarkToVungleAdConfig(@NotNull AdConfig var1, @NotNull MediationAppOpenAdConfiguration var2);

    public void showAd(@NotNull Context context) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                InterstitialAd interstitialAd = this.appOpenAd;
                if (interstitialAd == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"appOpenAd");
                    interstitialAd = null;
                }
                if (!interstitialAd.canPlayAd().booleanValue()) break block2;
                InterstitialAd interstitialAd2 = this.appOpenAd;
                if (interstitialAd2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"appOpenAd");
                    interstitialAd2 = null;
                }
                interstitialAd2.play(context);
                break block3;
            }
            AdError error = new AdError(107, "Failed to show app open ad from Liftoff Monetize.", "com.google.ads.mediation.vungle");
            Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
            MediationAppOpenAdCallback mediationAppOpenAdCallback = this.mediationAppOpenAdCallback;
            if (mediationAppOpenAdCallback == null) break block3;
            mediationAppOpenAdCallback.onAdFailedToShow(error);
        }
    }

    public void onAdLoaded(@NotNull BaseAd baseAd) {
        Intrinsics.checkNotNullParameter((Object)baseAd, (String)"baseAd");
        this.mediationAppOpenAdCallback = (MediationAppOpenAdCallback)this.mediationAdLoadCallback.onSuccess((Object)this);
    }

    public void onAdStart(@NotNull BaseAd baseAd) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)baseAd, (String)"baseAd");
            if (this.mediationAppOpenAdCallback == null) break block1;
            MediationAppOpenAdCallback mediationAppOpenAdCallback = this.mediationAppOpenAdCallback;
            if (mediationAppOpenAdCallback != null) {
                mediationAppOpenAdCallback.onAdOpened();
            }
        }
    }

    public void onAdEnd(@NotNull BaseAd baseAd) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)baseAd, (String)"baseAd");
            if (this.mediationAppOpenAdCallback == null) break block1;
            MediationAppOpenAdCallback mediationAppOpenAdCallback = this.mediationAppOpenAdCallback;
            if (mediationAppOpenAdCallback != null) {
                mediationAppOpenAdCallback.onAdClosed();
            }
        }
    }

    public void onAdClicked(@NotNull BaseAd baseAd) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)baseAd, (String)"baseAd");
            if (this.mediationAppOpenAdCallback == null) break block1;
            MediationAppOpenAdCallback mediationAppOpenAdCallback = this.mediationAppOpenAdCallback;
            if (mediationAppOpenAdCallback != null) {
                mediationAppOpenAdCallback.reportAdClicked();
            }
        }
    }

    public void onAdLeftApplication(@NotNull BaseAd baseAd) {
        Intrinsics.checkNotNullParameter((Object)baseAd, (String)"baseAd");
    }

    public void onAdFailedToPlay(@NotNull BaseAd baseAd, @NotNull VungleError adError) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)baseAd, (String)"baseAd");
            Intrinsics.checkNotNullParameter((Object)adError, (String)"adError");
            AdError adError2 = VungleMediationAdapter.getAdError(adError);
            Intrinsics.checkNotNullExpressionValue((Object)adError2, (String)"getAdError(adError)");
            AdError error = adError2;
            Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
            if (this.mediationAppOpenAdCallback == null) break block1;
            MediationAppOpenAdCallback mediationAppOpenAdCallback = this.mediationAppOpenAdCallback;
            if (mediationAppOpenAdCallback != null) {
                mediationAppOpenAdCallback.onAdFailedToShow(error);
            }
        }
    }

    public void onAdFailedToLoad(@NotNull BaseAd baseAd, @NotNull VungleError adError) {
        Intrinsics.checkNotNullParameter((Object)baseAd, (String)"baseAd");
        Intrinsics.checkNotNullParameter((Object)adError, (String)"adError");
        AdError adError2 = VungleMediationAdapter.getAdError(adError);
        Intrinsics.checkNotNullExpressionValue((Object)adError2, (String)"getAdError(adError)");
        AdError error = adError2;
        Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
        this.mediationAdLoadCallback.onFailure(error);
    }

    public void onAdImpression(@NotNull BaseAd baseAd) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)baseAd, (String)"baseAd");
            if (this.mediationAppOpenAdCallback == null) break block1;
            MediationAppOpenAdCallback mediationAppOpenAdCallback = this.mediationAppOpenAdCallback;
            if (mediationAppOpenAdCallback != null) {
                mediationAppOpenAdCallback.reportAdImpression();
            }
        }
    }

    public static final /* synthetic */ VungleFactory access$getVungleFactory$p(VungleAppOpenAd $this) {
        return $this.vungleFactory;
    }

    public static final /* synthetic */ MediationAppOpenAdConfiguration access$getMediationAppOpenAdConfiguration$p(VungleAppOpenAd $this) {
        return $this.mediationAppOpenAdConfiguration;
    }

    public static final /* synthetic */ void access$setAppOpenAd$p(VungleAppOpenAd $this, InterstitialAd interstitialAd) {
        $this.appOpenAd = interstitialAd;
    }

    public static final /* synthetic */ InterstitialAd access$getAppOpenAd$p(VungleAppOpenAd $this) {
        return $this.appOpenAd;
    }

    public static final /* synthetic */ MediationAdLoadCallback access$getMediationAdLoadCallback$p(VungleAppOpenAd $this) {
        return $this.mediationAdLoadCallback;
    }
}

