/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.vungle.rtb;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.ads.mediation.vungle.VungleFactory;
import com.google.ads.mediation.vungle.VungleInitializer;
import com.google.ads.mediation.vungle.VungleMediationAdapter;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAd;
import com.google.android.gms.ads.mediation.MediationInterstitialAdCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAdConfiguration;
import com.vungle.ads.AdConfig;
import com.vungle.ads.BaseAd;
import com.vungle.ads.BaseAdListener;
import com.vungle.ads.InterstitialAd;
import com.vungle.ads.InterstitialAdListener;
import com.vungle.ads.VungleError;

public class VungleRtbInterstitialAd
implements MediationInterstitialAd,
InterstitialAdListener {
    @NonNull
    private final MediationInterstitialAdConfiguration mediationInterstitialAdConfiguration;
    @NonNull
    private final MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> mediationAdLoadCallback;
    @Nullable
    private MediationInterstitialAdCallback mediationInterstitialAdCallback;
    private InterstitialAd interstitialAd;
    private final VungleFactory vungleFactory;

    public VungleRtbInterstitialAd(@NonNull MediationInterstitialAdConfiguration mediationInterstitialAdConfiguration, @NonNull MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> mediationAdLoadCallback, VungleFactory vungleFactory) {
        this.mediationInterstitialAdConfiguration = mediationInterstitialAdConfiguration;
        this.mediationAdLoadCallback = mediationAdLoadCallback;
        this.vungleFactory = vungleFactory;
    }

    public void render() {
        String watermark;
        Bundle mediationExtras = this.mediationInterstitialAdConfiguration.getMediationExtras();
        Bundle serverParameters = this.mediationInterstitialAdConfiguration.getServerParameters();
        String appID = serverParameters.getString("appid");
        if (TextUtils.isEmpty((CharSequence)appID)) {
            AdError error = new AdError(101, "Failed to load bidding interstitial ad from Liftoff Monetize. Missing or invalid App ID configured for this ad source instance in the AdMob or Ad Manager UI.", "com.google.ads.mediation.vungle");
            Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
            this.mediationAdLoadCallback.onFailure(error);
            return;
        }
        final String placement = serverParameters.getString("placementID");
        if (TextUtils.isEmpty((CharSequence)placement)) {
            AdError error = new AdError(101, "Failed to load bidding interstitial ad from Liftoff Monetize. Missing or Invalid Placement ID configured for this ad source instance in the AdMob or Ad Manager UI.", "com.google.ads.mediation.vungle");
            Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
            this.mediationAdLoadCallback.onFailure(error);
            return;
        }
        final String adMarkup = this.mediationInterstitialAdConfiguration.getBidResponse();
        final AdConfig adConfig = this.vungleFactory.createAdConfig();
        if (mediationExtras.containsKey("adOrientation")) {
            adConfig.setAdOrientation(mediationExtras.getInt("adOrientation", 2));
        }
        if (!TextUtils.isEmpty((CharSequence)(watermark = this.mediationInterstitialAdConfiguration.getWatermark()))) {
            adConfig.setWatermark(watermark);
        }
        final Context context = this.mediationInterstitialAdConfiguration.getContext();
        VungleInitializer.getInstance().initialize(appID, context, new VungleInitializer.VungleInitializationListener(){

            @Override
            public void onInitializeSuccess() {
                VungleRtbInterstitialAd.this.interstitialAd = VungleRtbInterstitialAd.this.vungleFactory.createInterstitialAd(context, placement, adConfig);
                VungleRtbInterstitialAd.this.interstitialAd.setAdListener((BaseAdListener)VungleRtbInterstitialAd.this);
                VungleRtbInterstitialAd.this.interstitialAd.load(adMarkup);
            }

            @Override
            public void onInitializeError(AdError error) {
                Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
                VungleRtbInterstitialAd.this.mediationAdLoadCallback.onFailure(error);
            }
        });
    }

    public void showAd(@NonNull Context context) {
        if (this.interstitialAd != null) {
            this.interstitialAd.play(context);
        } else if (this.mediationInterstitialAdCallback != null) {
            AdError error = new AdError(107, "Failed to show bidding rewarded ad from Liftoff Monetize.", "com.google.ads.mediation.vungle");
            Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
            this.mediationInterstitialAdCallback.onAdFailedToShow(error);
        }
    }

    public void onAdLoaded(@NonNull BaseAd baseAd) {
        this.mediationInterstitialAdCallback = (MediationInterstitialAdCallback)this.mediationAdLoadCallback.onSuccess((Object)this);
    }

    public void onAdStart(@NonNull BaseAd baseAd) {
        if (this.mediationInterstitialAdCallback != null) {
            this.mediationInterstitialAdCallback.onAdOpened();
        }
    }

    public void onAdEnd(@NonNull BaseAd baseAd) {
        if (this.mediationInterstitialAdCallback != null) {
            this.mediationInterstitialAdCallback.onAdClosed();
        }
    }

    public void onAdClicked(@NonNull BaseAd baseAd) {
        if (this.mediationInterstitialAdCallback != null) {
            this.mediationInterstitialAdCallback.reportAdClicked();
        }
    }

    public void onAdLeftApplication(@NonNull BaseAd baseAd) {
        if (this.mediationInterstitialAdCallback != null) {
            this.mediationInterstitialAdCallback.onAdLeftApplication();
        }
    }

    public void onAdFailedToPlay(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
        AdError error = VungleMediationAdapter.getAdError(vungleError);
        Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
        if (this.mediationInterstitialAdCallback != null) {
            this.mediationInterstitialAdCallback.onAdFailedToShow(error);
        }
    }

    public void onAdFailedToLoad(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
        AdError error = VungleMediationAdapter.getAdError(vungleError);
        Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
        this.mediationAdLoadCallback.onFailure(error);
    }

    public void onAdImpression(@NonNull BaseAd baseAd) {
        if (this.mediationInterstitialAdCallback != null) {
            this.mediationInterstitialAdCallback.reportAdImpression();
        }
    }
}

