/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.vungle.rtb;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.google.ads.mediation.vungle.VungleFactory;
import com.google.ads.mediation.vungle.VungleInitializer;
import com.google.ads.mediation.vungle.VungleMediationAdapter;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdConfiguration;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.vungle.ads.BaseAd;
import com.vungle.ads.BaseAdListener;
import com.vungle.ads.NativeAd;
import com.vungle.ads.NativeAdListener;
import com.vungle.ads.VungleError;
import com.vungle.ads.internal.ui.view.MediaView;
import java.util.ArrayList;
import java.util.Map;

public class VungleRtbNativeAd
extends UnifiedNativeAdMapper
implements NativeAdListener {
    private final MediationNativeAdConfiguration adConfiguration;
    private final MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> adLoadCallback;
    private MediationNativeAdCallback nativeAdCallback;
    private NativeAd nativeAd;
    private MediaView mediaView;
    private String adMarkup;
    private final VungleFactory vungleFactory;

    public VungleRtbNativeAd(@NonNull MediationNativeAdConfiguration mediationNativeAdConfiguration, @NonNull MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> callback, VungleFactory vungleFactory) {
        this.adConfiguration = mediationNativeAdConfiguration;
        this.adLoadCallback = callback;
        this.vungleFactory = vungleFactory;
    }

    public void render() {
        int adOptionsPosition;
        Bundle serverParameters = this.adConfiguration.getServerParameters();
        NativeAdOptions nativeAdOptions = this.adConfiguration.getNativeAdOptions();
        final Context context = this.adConfiguration.getContext();
        String appID = serverParameters.getString("appid");
        if (TextUtils.isEmpty((CharSequence)appID)) {
            AdError error = new AdError(101, "Failed to load bidding native ad from Liftoff Monetize. Missing or invalid app ID configured for this ad source instance in the AdMob or Ad Manager UI.", "com.google.ads.mediation.vungle");
            Log.d((String)VungleMediationAdapter.TAG, (String)error.toString());
            this.adLoadCallback.onFailure(error);
            return;
        }
        final String placementId = serverParameters.getString("placementID");
        if (TextUtils.isEmpty((CharSequence)placementId)) {
            AdError error = new AdError(101, "Failed to load bidding native ad from Liftoff Monetize. Missing or Invalid placement ID configured for this ad source instance in the AdMob or Ad Manager UI.", "com.google.ads.mediation.vungle");
            Log.d((String)VungleMediationAdapter.TAG, (String)error.toString());
            this.adLoadCallback.onFailure(error);
            return;
        }
        this.adMarkup = this.adConfiguration.getBidResponse();
        int privacyIconPlacement = nativeAdOptions.getAdChoicesPlacement();
        switch (privacyIconPlacement) {
            case 0: {
                adOptionsPosition = 0;
                break;
            }
            case 3: {
                adOptionsPosition = 2;
                break;
            }
            case 2: {
                adOptionsPosition = 3;
                break;
            }
            default: {
                adOptionsPosition = 1;
            }
        }
        final String watermark = this.adConfiguration.getWatermark();
        VungleInitializer.getInstance().initialize(appID, context, new VungleInitializer.VungleInitializationListener(){

            @Override
            public void onInitializeSuccess() {
                VungleRtbNativeAd.this.nativeAd = VungleRtbNativeAd.this.vungleFactory.createNativeAd(context, placementId);
                VungleRtbNativeAd.this.nativeAd.setAdOptionsPosition(adOptionsPosition);
                VungleRtbNativeAd.this.nativeAd.setAdListener((BaseAdListener)VungleRtbNativeAd.this);
                VungleRtbNativeAd.this.mediaView = new MediaView(context);
                if (!TextUtils.isEmpty((CharSequence)watermark)) {
                    VungleRtbNativeAd.this.nativeAd.getAdConfig().setWatermark(watermark);
                }
                VungleRtbNativeAd.this.nativeAd.load(VungleRtbNativeAd.this.adMarkup);
            }

            @Override
            public void onInitializeError(AdError error) {
                Log.d((String)VungleMediationAdapter.TAG, (String)error.toString());
                VungleRtbNativeAd.this.adLoadCallback.onFailure(error);
            }
        });
    }

    public void onAdLoaded(@NonNull BaseAd baseAd) {
        this.mapNativeAd();
        this.nativeAdCallback = (MediationNativeAdCallback)this.adLoadCallback.onSuccess((Object)this);
    }

    public void onAdFailedToLoad(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
        AdError error = VungleMediationAdapter.getAdError(vungleError);
        this.adLoadCallback.onFailure(error);
    }

    public void onAdFailedToPlay(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
        AdError error = VungleMediationAdapter.getAdError(vungleError);
        Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
    }

    public void onAdClicked(@NonNull BaseAd baseAd) {
        if (this.nativeAdCallback != null) {
            this.nativeAdCallback.reportAdClicked();
            this.nativeAdCallback.onAdOpened();
        }
    }

    public void onAdLeftApplication(@NonNull BaseAd baseAd) {
        if (this.nativeAdCallback != null) {
            this.nativeAdCallback.onAdLeftApplication();
        }
    }

    public void onAdImpression(@NonNull BaseAd baseAd) {
        if (this.nativeAdCallback != null) {
            this.nativeAdCallback.reportAdImpression();
        }
    }

    public void onAdStart(@NonNull BaseAd baseAd) {
    }

    public void onAdEnd(@NonNull BaseAd baseAd) {
    }

    public void trackViews(@NonNull View view, @NonNull Map<String, View> clickableAssetViews, @NonNull Map<String, View> nonClickableAssetViews) {
        super.trackViews(view, clickableAssetViews, nonClickableAssetViews);
        Log.d((String)VungleMediationAdapter.TAG, (String)"trackViews()");
        if (!(view instanceof ViewGroup)) {
            return;
        }
        ViewGroup adView = (ViewGroup)view;
        if (this.nativeAd == null || !this.nativeAd.canPlayAd().booleanValue()) {
            return;
        }
        View overlayView = adView.getChildAt(adView.getChildCount() - 1);
        if (!(overlayView instanceof FrameLayout)) {
            Log.d((String)VungleMediationAdapter.TAG, (String)"Vungle requires a FrameLayout to render the native ad.");
            return;
        }
        View iconView = null;
        ArrayList<View> assetViews = new ArrayList<View>();
        for (Map.Entry<String, View> clickableAssets : clickableAssetViews.entrySet()) {
            assetViews.add(clickableAssets.getValue());
            if (!clickableAssets.getKey().equals("3003")) continue;
            iconView = clickableAssets.getValue();
        }
        ImageView iconImageView = null;
        if (iconView instanceof ImageView) {
            iconImageView = (ImageView)iconView;
        } else {
            Log.d((String)VungleMediationAdapter.TAG, (String)"The view to display a Vungle native icon image is not a type of ImageView, so it can't be registered for click events.");
        }
        this.nativeAd.registerViewForInteraction((FrameLayout)overlayView, this.mediaView, iconImageView, assetViews);
    }

    public void untrackView(@NonNull View view) {
        super.untrackView(view);
        Log.d((String)VungleMediationAdapter.TAG, (String)"untrackView()");
        if (this.nativeAd == null) {
            return;
        }
        this.nativeAd.unregisterView();
    }

    private void mapNativeAd() {
        this.setHeadline(this.nativeAd.getAdTitle());
        this.setBody(this.nativeAd.getAdBodyText());
        this.setCallToAction(this.nativeAd.getAdCallToActionText());
        Double starRating = this.nativeAd.getAdStarRating();
        if (starRating != null) {
            this.setStarRating(starRating);
        }
        this.setAdvertiser(this.nativeAd.getAdSponsoredText());
        this.setMediaView((View)this.mediaView);
        String iconUrl = this.nativeAd.getAppIcon();
        if (!TextUtils.isEmpty((CharSequence)iconUrl) && iconUrl.startsWith("file://")) {
            this.setIcon(new VungleNativeMappedImage(Uri.parse((String)iconUrl)));
        }
        if (TextUtils.isEmpty((CharSequence)this.adMarkup)) {
            this.setOverrideImpressionRecording(true);
        }
        this.setOverrideClickHandling(true);
    }

    private static class VungleNativeMappedImage
    extends NativeAd.Image {
        private Uri imageUri;

        public VungleNativeMappedImage(Uri imageUrl) {
            this.imageUri = imageUrl;
        }

        public Drawable getDrawable() {
            return null;
        }

        public Uri getUri() {
            return this.imageUri;
        }

        public double getScale() {
            return 1.0;
        }
    }
}

