/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.vungle.rtb;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.ads.mediation.vungle.VungleFactory;
import com.google.ads.mediation.vungle.VungleInitializer;
import com.google.ads.mediation.vungle.VungleMediationAdapter;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.vungle.ads.AdConfig;
import com.vungle.ads.BaseAd;
import com.vungle.ads.BaseAdListener;
import com.vungle.ads.RewardedAd;
import com.vungle.ads.RewardedAdListener;
import com.vungle.ads.VungleError;

public class VungleRtbRewardedAd
implements MediationRewardedAd,
RewardedAdListener {
    @NonNull
    private final MediationRewardedAdConfiguration mediationRewardedAdConfiguration;
    @NonNull
    private final MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> mediationAdLoadCallback;
    @Nullable
    private MediationRewardedAdCallback mediationRewardedAdCallback;
    private RewardedAd rewardedAd;
    private final VungleFactory vungleFactory;

    public VungleRtbRewardedAd(@NonNull MediationRewardedAdConfiguration mediationRewardedAdConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> mediationAdLoadCallback, VungleFactory vungleFactory) {
        this.mediationRewardedAdConfiguration = mediationRewardedAdConfiguration;
        this.mediationAdLoadCallback = mediationAdLoadCallback;
        this.vungleFactory = vungleFactory;
    }

    public void render() {
        String watermark;
        Bundle mediationExtras = this.mediationRewardedAdConfiguration.getMediationExtras();
        Bundle serverParameters = this.mediationRewardedAdConfiguration.getServerParameters();
        final String userId = mediationExtras.getString("userId");
        String appID = serverParameters.getString("appid");
        if (TextUtils.isEmpty((CharSequence)appID)) {
            AdError error = new AdError(101, "Failed to load bidding rewarded ad from Liftoff Monetize. Missing or invalid App ID configured for this ad source instance in the AdMob or Ad Manager UI.", "com.google.ads.mediation.vungle");
            Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
            this.mediationAdLoadCallback.onFailure(error);
            return;
        }
        final String placement = serverParameters.getString("placementID");
        if (TextUtils.isEmpty((CharSequence)placement)) {
            AdError error = new AdError(101, "Failed to load bidding rewarded ad from Liftoff Monetize. Missing or invalid Placement ID configured for this ad source instance in the AdMob or Ad Manager UI.", "com.google.ads.mediation.vungle");
            Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
            this.mediationAdLoadCallback.onFailure(error);
            return;
        }
        final String adMarkup = this.mediationRewardedAdConfiguration.getBidResponse();
        final AdConfig adConfig = this.vungleFactory.createAdConfig();
        if (mediationExtras.containsKey("adOrientation")) {
            adConfig.setAdOrientation(mediationExtras.getInt("adOrientation", 2));
        }
        if (!TextUtils.isEmpty((CharSequence)(watermark = this.mediationRewardedAdConfiguration.getWatermark()))) {
            adConfig.setWatermark(watermark);
        }
        final Context context = this.mediationRewardedAdConfiguration.getContext();
        VungleInitializer.getInstance().initialize(appID, context, new VungleInitializer.VungleInitializationListener(){

            @Override
            public void onInitializeSuccess() {
                VungleRtbRewardedAd.this.rewardedAd = VungleRtbRewardedAd.this.vungleFactory.createRewardedAd(context, placement, adConfig);
                VungleRtbRewardedAd.this.rewardedAd.setAdListener((BaseAdListener)VungleRtbRewardedAd.this);
                if (!TextUtils.isEmpty((CharSequence)userId)) {
                    VungleRtbRewardedAd.this.rewardedAd.setUserId(userId);
                }
                VungleRtbRewardedAd.this.rewardedAd.load(adMarkup);
            }

            @Override
            public void onInitializeError(AdError error) {
                Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
                VungleRtbRewardedAd.this.mediationAdLoadCallback.onFailure(error);
            }
        });
    }

    public void showAd(@NonNull Context context) {
        if (this.rewardedAd != null) {
            this.rewardedAd.play(context);
        } else if (this.mediationRewardedAdCallback != null) {
            AdError error = new AdError(107, "Failed to show bidding rewardedad from Liftoff Monetize.", "com.google.ads.mediation.vungle");
            Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
            this.mediationRewardedAdCallback.onAdFailedToShow(error);
        }
    }

    public void onAdLoaded(@NonNull BaseAd baseAd) {
        this.mediationRewardedAdCallback = (MediationRewardedAdCallback)this.mediationAdLoadCallback.onSuccess((Object)this);
    }

    public void onAdStart(@NonNull BaseAd baseAd) {
        if (this.mediationRewardedAdCallback != null) {
            this.mediationRewardedAdCallback.onAdOpened();
        }
    }

    public void onAdEnd(@NonNull BaseAd baseAd) {
        if (this.mediationRewardedAdCallback != null) {
            this.mediationRewardedAdCallback.onAdClosed();
        }
    }

    public void onAdClicked(@NonNull BaseAd baseAd) {
        if (this.mediationRewardedAdCallback != null) {
            this.mediationRewardedAdCallback.reportAdClicked();
        }
    }

    public void onAdRewarded(@NonNull BaseAd baseAd) {
        if (this.mediationRewardedAdCallback != null) {
            this.mediationRewardedAdCallback.onVideoComplete();
            this.mediationRewardedAdCallback.onUserEarnedReward((RewardItem)new VungleMediationAdapter.VungleReward("vungle", 1));
        }
    }

    public void onAdLeftApplication(@NonNull BaseAd baseAd) {
    }

    public void onAdFailedToPlay(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
        AdError error = VungleMediationAdapter.getAdError(vungleError);
        Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
        if (this.mediationRewardedAdCallback != null) {
            this.mediationRewardedAdCallback.onAdFailedToShow(error);
        }
    }

    public void onAdFailedToLoad(@NonNull BaseAd baseAd, @NonNull VungleError vungleError) {
        AdError error = VungleMediationAdapter.getAdError(vungleError);
        Log.w((String)VungleMediationAdapter.TAG, (String)error.toString());
        this.mediationAdLoadCallback.onFailure(error);
    }

    public void onAdImpression(@NonNull BaseAd baseAd) {
        if (this.mediationRewardedAdCallback != null) {
            this.mediationRewardedAdCallback.onVideoStart();
            this.mediationRewardedAdCallback.reportAdImpression();
        }
    }
}

