/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.mintegral;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.ads.mediation.mintegral.MintegralConstants;
import com.google.ads.mediation.mintegral.MintegralUtils;
import com.google.ads.mediation.mintegral.rtb.MintegralRtbAppOpenAd;
import com.google.ads.mediation.mintegral.rtb.MintegralRtbBannerAd;
import com.google.ads.mediation.mintegral.rtb.MintegralRtbInterstitialAd;
import com.google.ads.mediation.mintegral.rtb.MintegralRtbNativeAd;
import com.google.ads.mediation.mintegral.rtb.MintegralRtbRewardedAd;
import com.google.ads.mediation.mintegral.waterfall.MintegralWaterfallAppOpenAd;
import com.google.ads.mediation.mintegral.waterfall.MintegralWaterfallBannerAd;
import com.google.ads.mediation.mintegral.waterfall.MintegralWaterfallInterstitialAd;
import com.google.ads.mediation.mintegral.waterfall.MintegralWaterfallNativeAd;
import com.google.ads.mediation.mintegral.waterfall.MintegralWaterfallRewardedAd;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.mediation.InitializationCompleteCallback;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationAppOpenAd;
import com.google.android.gms.ads.mediation.MediationAppOpenAdCallback;
import com.google.android.gms.ads.mediation.MediationAppOpenAdConfiguration;
import com.google.android.gms.ads.mediation.MediationBannerAd;
import com.google.android.gms.ads.mediation.MediationBannerAdCallback;
import com.google.android.gms.ads.mediation.MediationBannerAdConfiguration;
import com.google.android.gms.ads.mediation.MediationConfiguration;
import com.google.android.gms.ads.mediation.MediationInterstitialAd;
import com.google.android.gms.ads.mediation.MediationInterstitialAdCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAdConfiguration;
import com.google.android.gms.ads.mediation.MediationNativeAdCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdConfiguration;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.ads.mediation.rtb.RtbAdapter;
import com.google.android.gms.ads.mediation.rtb.RtbSignalData;
import com.google.android.gms.ads.mediation.rtb.SignalCallbacks;
import com.mbridge.msdk.MBridgeSDK;
import com.mbridge.msdk.foundation.same.net.Aa;
import com.mbridge.msdk.mbbid.out.BidManager;
import com.mbridge.msdk.out.MBridgeSDKFactory;
import com.mbridge.msdk.out.SDKInitStatusListener;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MintegralMediationAdapter
extends RtbAdapter {
    public static final String TAG = MintegralMediationAdapter.class.getSimpleName();
    private static MBridgeSDK mBridgeSDK;
    private MintegralWaterfallBannerAd mintegralWaterfallBannerAd;
    private MintegralWaterfallInterstitialAd mintegralInterstitialAd;
    private MintegralWaterfallRewardedAd mintegralRewardedAd;
    private MintegralWaterfallNativeAd mintegralNativeAd;
    private MintegralWaterfallAppOpenAd mintegralWaterfallAppOpenAd;
    private MintegralRtbBannerAd mintegralRtbBannerAd;
    private MintegralRtbInterstitialAd mintegralRtbInterstitialAd;
    private MintegralRtbRewardedAd mintegralRtbRewardedAd;
    private MintegralRtbNativeAd mintegralRtbNativeAd;
    private MintegralRtbAppOpenAd mintegralRtbAppOpenAd;

    public void collectSignals(@NonNull RtbSignalData rtbSignalData, @NonNull SignalCallbacks signalCallbacks) {
        String buyerUid = BidManager.getBuyerUid((Context)rtbSignalData.getContext());
        signalCallbacks.onSuccess(buyerUid);
    }

    @NonNull
    public VersionInfo getSDKVersionInfo() {
        String[] splits;
        String versionString = MintegralUtils.getSdkVersion();
        String[] versionSplits = versionString.split("_");
        if (versionSplits.length > 1 && (splits = versionSplits[1].split("\\.")).length >= 3) {
            int major = Integer.parseInt(splits[0]);
            int minor = Integer.parseInt(splits[1]);
            int micro = Integer.parseInt(splits[2]);
            return new VersionInfo(major, minor, micro);
        }
        String logMessage = String.format("Unexpected SDK version format: %s. Returning 0.0.0 for SDK version.", versionString);
        Log.w((String)TAG, (String)logMessage);
        return new VersionInfo(0, 0, 0);
    }

    @NonNull
    public VersionInfo getVersionInfo() {
        String versionString = MintegralUtils.getAdapterVersion();
        String[] splits = versionString.split("\\.");
        if (splits.length >= 4) {
            int major = Integer.parseInt(splits[0]);
            int minor = Integer.parseInt(splits[1]);
            int micro = Integer.parseInt(splits[2]) * 100 + Integer.parseInt(splits[3]);
            return new VersionInfo(major, minor, micro);
        }
        String logMessage = String.format("Unexpected adapter version format: %s. Returning 0.0.0 for adapter version.", versionString);
        Log.w((String)TAG, (String)logMessage);
        return new VersionInfo(0, 0, 0);
    }

    public void initialize(@NonNull Context context, final @NonNull InitializationCompleteCallback initializationCompleteCallback, @NonNull List<MediationConfiguration> list) {
        String message;
        HashSet<String> appIds = new HashSet<String>();
        HashSet<String> appKeys = new HashSet<String>();
        for (MediationConfiguration mediationConfiguration : list) {
            Bundle serverParameters = mediationConfiguration.getServerParameters();
            String appId = serverParameters.getString("app_id");
            String appKey = serverParameters.getString("app_key");
            if (!TextUtils.isEmpty((CharSequence)appId)) {
                appIds.add(appId);
            }
            if (TextUtils.isEmpty((CharSequence)appKey)) continue;
            appKeys.add(appKey);
        }
        int appIdCount = appIds.size();
        int appKeyCount = appKeys.size();
        if (appIdCount <= 0 || appKeyCount <= 0) {
            AdError error = MintegralConstants.createAdapterError(101, "Missing or invalid App ID or App Key configured for this ad source instance in the AdMob or Ad Manager UI");
            Log.e((String)TAG, (String)error.toString());
            initializationCompleteCallback.onInitializationFailed(error.toString());
            return;
        }
        String appId = (String)appIds.iterator().next();
        String appKey = (String)appKeys.iterator().next();
        if (appIdCount > 1) {
            message = String.format("Found multiple app IDs in %s. Using %s to initialize Mintegral SDK.", appIds, appId);
            Log.w((String)TAG, (String)message);
        }
        if (appKeyCount > 1) {
            message = String.format("Found multiple App Keys in %s. Using %s to initialize Mintegral SDK.", appKeys, appKey);
            Log.w((String)TAG, (String)message);
        }
        mBridgeSDK = MBridgeSDKFactory.getMBridgeSDK();
        Map configurationMap = mBridgeSDK.getMBConfigurationMap(appId, appKey);
        mBridgeSDK.init(configurationMap, context, new SDKInitStatusListener(){

            public void onInitSuccess() {
                try {
                    Aa channelManagerInstance = new Aa();
                    Class<?> channelManagerClass = channelManagerInstance.getClass();
                    Method setChannelMethod = channelManagerClass.getDeclaredMethod("b", String.class);
                    setChannelMethod.setAccessible(true);
                    setChannelMethod.invoke((Object)channelManagerInstance, "Y+H6DFttYrPQYcIBiQKwJQKQYrN=");
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                initializationCompleteCallback.onInitializationSucceeded();
            }

            public void onInitFail(String errorMessage) {
                AdError initError = MintegralConstants.createSdkError(105, errorMessage);
                initializationCompleteCallback.onInitializationFailed(initError.getMessage());
                Log.w((String)TAG, (String)initError.toString());
            }
        });
    }

    public void loadRtbBannerAd(@NonNull MediationBannerAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> callback) {
        this.mintegralRtbBannerAd = new MintegralRtbBannerAd(adConfiguration, callback);
        this.mintegralRtbBannerAd.loadAd();
    }

    public void loadRtbInterstitialAd(@NonNull MediationInterstitialAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> callback) {
        this.mintegralRtbInterstitialAd = new MintegralRtbInterstitialAd(adConfiguration, callback);
        this.mintegralRtbInterstitialAd.loadAd();
    }

    public void loadRtbNativeAd(@NonNull MediationNativeAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> callback) {
        this.mintegralRtbNativeAd = new MintegralRtbNativeAd(adConfiguration, callback);
        this.mintegralRtbNativeAd.loadAd();
    }

    public void loadRtbRewardedAd(@NonNull MediationRewardedAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> callback) {
        this.mintegralRtbRewardedAd = new MintegralRtbRewardedAd(adConfiguration, callback);
        this.mintegralRtbRewardedAd.loadAd();
    }

    public void loadRtbAppOpenAd(@NonNull MediationAppOpenAdConfiguration mediationAppOpenAdConfiguration, @NonNull MediationAdLoadCallback<MediationAppOpenAd, MediationAppOpenAdCallback> callback) {
        this.mintegralRtbAppOpenAd = new MintegralRtbAppOpenAd(mediationAppOpenAdConfiguration, callback);
        this.mintegralRtbAppOpenAd.loadAd();
    }

    public void loadBannerAd(@NonNull MediationBannerAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> callback) {
        this.mintegralWaterfallBannerAd = new MintegralWaterfallBannerAd(adConfiguration, callback);
        this.mintegralWaterfallBannerAd.loadAd();
    }

    public void loadInterstitialAd(@NonNull MediationInterstitialAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> callback) {
        this.mintegralInterstitialAd = new MintegralWaterfallInterstitialAd(adConfiguration, callback);
        this.mintegralInterstitialAd.loadAd();
    }

    public void loadNativeAd(@NonNull MediationNativeAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> callback) {
        this.mintegralNativeAd = new MintegralWaterfallNativeAd(adConfiguration, callback);
        this.mintegralNativeAd.loadAd();
    }

    public void loadRewardedAd(@NonNull MediationRewardedAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> callback) {
        this.mintegralRewardedAd = new MintegralWaterfallRewardedAd(adConfiguration, callback);
        this.mintegralRewardedAd.loadAd();
    }

    public void loadAppOpenAd(@NonNull MediationAppOpenAdConfiguration mediationAppOpenAdConfiguration, @NonNull MediationAdLoadCallback<MediationAppOpenAd, MediationAppOpenAdCallback> callback) {
        this.mintegralWaterfallAppOpenAd = new MintegralWaterfallAppOpenAd(mediationAppOpenAdConfiguration, callback);
        this.mintegralWaterfallAppOpenAd.loadAd();
    }
}

