/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.mintegral;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.ads.mediation.mintegral.MintegralConstants;
import com.google.android.gms.ads.AdError;

public class MintegralUtils {
    public static final String TAG = MintegralUtils.class.getSimpleName();

    public static String getAdapterVersion() {
        return "16.7.21.0";
    }

    public static String getSdkVersion() {
        return "MAL_16.7.21";
    }

    public static boolean shouldMuteAudio(@NonNull Bundle networkExtras) {
        return networkExtras.getBoolean("mute_audio");
    }

    @Nullable
    public static AdError validateMintegralAdLoadParams(@Nullable String adUnitId, @Nullable String placementId) {
        if (TextUtils.isEmpty((CharSequence)adUnitId)) {
            AdError parameterError = MintegralConstants.createAdapterError(101, "Missing or invalid ad Unit ID configured for this ad source instance in the AdMob or Ad Manager UI.");
            Log.e((String)TAG, (String)parameterError.toString());
            return parameterError;
        }
        if (TextUtils.isEmpty((CharSequence)placementId)) {
            AdError parameterError = MintegralConstants.createAdapterError(101, "Missing or invalid Placement ID configured for this ad source instance in the AdMob or Ad Manager UI.");
            Log.e((String)TAG, (String)parameterError.toString());
            return parameterError;
        }
        return null;
    }

    @Nullable
    public static AdError validateMintegralAdLoadParams(@Nullable String adUnitId, @Nullable String placementId, @Nullable String bidToken) {
        AdError parameterError = MintegralUtils.validateMintegralAdLoadParams(adUnitId, placementId);
        if (parameterError != null) {
            return parameterError;
        }
        if (TextUtils.isEmpty((CharSequence)bidToken)) {
            parameterError = MintegralConstants.createAdapterError(103, "Missing or invalid Mintegral bidding signal in this ad request.");
            Log.w((String)TAG, (String)parameterError.toString());
            return parameterError;
        }
        return null;
    }

    public static int convertDipToPixel(@NonNull Context context, float dipValue) {
        Resources resources = context.getResources();
        if (resources == null) {
            return 0;
        }
        return (int)TypedValue.applyDimension((int)1, (float)(dipValue + 0.5f), (DisplayMetrics)resources.getDisplayMetrics());
    }
}

