/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.mintegral.mediation;

import android.app.Activity;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.ads.mediation.mintegral.MintegralConstants;
import com.google.ads.mediation.mintegral.MintegralMediationAdapter;
import com.google.ads.mediation.mintegral.MintegralSplashAdWrapper;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationAppOpenAd;
import com.google.android.gms.ads.mediation.MediationAppOpenAdCallback;
import com.google.android.gms.ads.mediation.MediationAppOpenAdConfiguration;
import com.mbridge.msdk.out.MBSplashLoadWithCodeListener;
import com.mbridge.msdk.out.MBSplashShowListener;
import com.mbridge.msdk.out.MBridgeIds;

public abstract class MintegralAppOpenAd
extends MBSplashLoadWithCodeListener
implements MediationAppOpenAd,
MBSplashShowListener {
    protected final MediationAppOpenAdConfiguration adConfiguration;
    protected final MediationAdLoadCallback<MediationAppOpenAd, MediationAppOpenAdCallback> adLoadCallback;
    protected MediationAppOpenAdCallback appOpenAdCallback;
    protected MintegralSplashAdWrapper splashAdWrapper;
    protected Activity activity;

    protected MintegralAppOpenAd(@NonNull MediationAppOpenAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationAppOpenAd, MediationAppOpenAdCallback> adLoadCallback) {
        this.adConfiguration = adConfiguration;
        this.adLoadCallback = adLoadCallback;
    }

    public abstract void loadAd();

    public void onLoadSuccessed(MBridgeIds mBridgeIds, int type) {
        this.appOpenAdCallback = (MediationAppOpenAdCallback)this.adLoadCallback.onSuccess((Object)this);
    }

    public void isSupportZoomOut(MBridgeIds mBridgeIds, boolean isSupported) {
    }

    public void onLoadFailedWithCode(MBridgeIds mBridgeIds, int code, String msg, int reqType) {
        AdError adError = MintegralConstants.createSdkError(code, msg);
        Log.d((String)MintegralMediationAdapter.TAG, (String)adError.toString());
        this.adLoadCallback.onFailure(adError);
    }

    public void onShowSuccessed(MBridgeIds mBridgeIds) {
        if (this.appOpenAdCallback != null) {
            this.appOpenAdCallback.onAdOpened();
            this.appOpenAdCallback.reportAdImpression();
        }
    }

    public void onShowFailed(MBridgeIds mBridgeIds, String msg) {
        if (this.appOpenAdCallback != null) {
            AdError error = MintegralConstants.createSdkError(100, msg);
            Log.w((String)MintegralMediationAdapter.TAG, (String)error.toString());
            this.appOpenAdCallback.onAdFailedToShow(error);
        }
    }

    public void onAdClicked(MBridgeIds mBridgeIds) {
        if (this.appOpenAdCallback != null) {
            this.appOpenAdCallback.reportAdClicked();
        }
    }

    public void onDismiss(MBridgeIds mBridgeIds, int type) {
        if (this.appOpenAdCallback != null) {
            this.appOpenAdCallback.onAdClosed();
        }
        if (this.splashAdWrapper != null) {
            this.splashAdWrapper.onDestroy();
        }
    }

    public void onAdTick(MBridgeIds mBridgeIds, long millisUntilFinished) {
    }

    public void onZoomOutPlayStart(MBridgeIds mBridgeIds) {
    }

    public void onZoomOutPlayFinish(MBridgeIds mBridgeIds) {
    }
}

