/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.mintegral.mediation;

import android.util.Log;
import androidx.annotation.NonNull;
import com.google.ads.mediation.mintegral.MintegralConstants;
import com.google.ads.mediation.mintegral.MintegralMediationAdapter;
import com.google.ads.mediation.mintegral.mediation.MintegralNativeAd;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdCallback;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.mbridge.msdk.out.Campaign;
import com.mbridge.msdk.out.Frame;
import com.mbridge.msdk.out.NativeAdWithCodeListener;
import java.util.List;

public class MintegralNativeAdListener
extends NativeAdWithCodeListener {
    protected MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> adLoadCallback;
    protected MediationNativeAdCallback nativeCallback;
    private MintegralNativeAd mintegralNativeAd;

    public MintegralNativeAdListener(@NonNull MintegralNativeAd mintegralNativeAd) {
        this.mintegralNativeAd = mintegralNativeAd;
        this.adLoadCallback = mintegralNativeAd.adLoadCallback;
    }

    public void onAdLoaded(List<Campaign> list, int template) {
        if (list == null || list.size() == 0) {
            AdError adError = MintegralConstants.createAdapterError(104, "Mintegral SDK failed to return a native ad.");
            Log.w((String)MintegralMediationAdapter.TAG, (String)adError.toString());
            this.adLoadCallback.onFailure(adError);
            return;
        }
        this.mintegralNativeAd.mapNativeAd(list.get(0));
        this.nativeCallback = (MediationNativeAdCallback)this.adLoadCallback.onSuccess((Object)this.mintegralNativeAd);
    }

    public void onAdLoadErrorWithCode(int errorCode, String errorMessage) {
        AdError adError = MintegralConstants.createSdkError(errorCode, errorMessage);
        Log.w((String)MintegralMediationAdapter.TAG, (String)adError.toString());
        this.adLoadCallback.onFailure(adError);
    }

    public void onAdClick(Campaign campaign) {
        if (this.nativeCallback != null) {
            this.nativeCallback.reportAdClicked();
            this.nativeCallback.onAdLeftApplication();
        }
    }

    public void onAdFramesLoaded(List<Frame> list) {
    }

    public void onLoggingImpression(int i) {
        if (this.nativeCallback != null) {
            this.nativeCallback.reportAdImpression();
        }
    }
}

