/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.mintegral.rtb;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.ads.mediation.mintegral.MintegralBidNewInterstitialAdWrapper;
import com.google.ads.mediation.mintegral.MintegralFactory;
import com.google.ads.mediation.mintegral.MintegralMediationAdapter;
import com.google.ads.mediation.mintegral.MintegralUtils;
import com.google.ads.mediation.mintegral.mediation.MintegralInterstitialAd;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAd;
import com.google.android.gms.ads.mediation.MediationInterstitialAdCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAdConfiguration;
import org.json.JSONException;
import org.json.JSONObject;

public class MintegralRtbInterstitialAd
extends MintegralInterstitialAd {
    private MintegralBidNewInterstitialAdWrapper mbBidNewInterstitialAdWrapper;

    public MintegralRtbInterstitialAd(@NonNull MediationInterstitialAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> callback) {
        super(adConfiguration, callback);
    }

    @Override
    public void loadAd() {
        String bidToken;
        String placementId;
        String adUnitId = this.adConfiguration.getServerParameters().getString("ad_unit_id");
        AdError error = MintegralUtils.validateMintegralAdLoadParams(adUnitId, placementId = this.adConfiguration.getServerParameters().getString("placement_id"), bidToken = this.adConfiguration.getBidResponse());
        if (error != null) {
            this.adLoadCallback.onFailure(error);
            return;
        }
        this.mbBidNewInterstitialAdWrapper = MintegralFactory.createBidInterstitialHandler();
        this.mbBidNewInterstitialAdWrapper.createAd(this.adConfiguration.getContext(), placementId, adUnitId);
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("watermark", (Object)this.adConfiguration.getWatermark());
            this.mbBidNewInterstitialAdWrapper.setExtraInfo(jsonObject);
        }
        catch (JSONException jsonException) {
            Log.w((String)MintegralMediationAdapter.TAG, (String)"Failed to apply watermark to Mintegral bidding interstitial ad.", (Throwable)jsonException);
        }
        this.mbBidNewInterstitialAdWrapper.setInterstitialVideoListener(this);
        this.mbBidNewInterstitialAdWrapper.loadFromBid(bidToken);
    }

    public void showAd(@NonNull Context context) {
        boolean muted = MintegralUtils.shouldMuteAudio(this.adConfiguration.getMediationExtras());
        this.mbBidNewInterstitialAdWrapper.playVideoMute(muted ? 1 : 2);
        this.mbBidNewInterstitialAdWrapper.showFromBid();
    }
}

