/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.mintegral.rtb;

import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import com.google.ads.mediation.mintegral.MintegralMediationAdapter;
import com.google.ads.mediation.mintegral.MintegralUtils;
import com.google.ads.mediation.mintegral.mediation.MintegralNativeAd;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdConfiguration;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.ads.nativead.MediaView;
import com.mbridge.msdk.nativex.view.MBMediaView;
import com.mbridge.msdk.out.MBBidNativeHandler;
import com.mbridge.msdk.out.NativeListener;
import com.mbridge.msdk.out.OnMBMediaViewListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class MintegralRtbNativeAd
extends MintegralNativeAd {
    private MBBidNativeHandler mbBidNativeHandler;

    public MintegralRtbNativeAd(@NonNull MediationNativeAdConfiguration mediationNativeAdConfiguration, @NonNull MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> mediationAdLoadCallback) {
        super(mediationNativeAdConfiguration, mediationAdLoadCallback);
    }

    @Override
    public void loadAd() {
        String bidToken;
        String placementId;
        String adUnitId = this.adConfiguration.getServerParameters().getString("ad_unit_id");
        AdError error = MintegralUtils.validateMintegralAdLoadParams(adUnitId, placementId = this.adConfiguration.getServerParameters().getString("placement_id"), bidToken = this.adConfiguration.getBidResponse());
        if (error != null) {
            this.adLoadCallback.onFailure(error);
            return;
        }
        Map nativeProperties = MBBidNativeHandler.getNativeProperties((String)placementId, (String)adUnitId);
        nativeProperties.put("videoSupport", true);
        nativeProperties.put("ad_num", 1);
        this.mbBidNativeHandler = new MBBidNativeHandler(nativeProperties, this.adConfiguration.getContext());
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("watermark", (Object)this.adConfiguration.getWatermark());
            this.mbBidNativeHandler.setExtraInfo(jsonObject);
        }
        catch (JSONException jsonException) {
            Log.w((String)MintegralMediationAdapter.TAG, (String)"Failed to apply watermark to Mintegral bidding native ad.", (Throwable)jsonException);
        }
        this.mbBidNativeHandler.setAdListener((NativeListener.NativeAdListener)this.mintegralNativeAdListener);
        this.mbBidNativeHandler.bidLoad(bidToken);
    }

    public void trackViews(@NonNull View view, @NonNull Map<String, View> clickableAssetViews, @NonNull Map<String, View> map1) {
        HashMap<String, View> copyClickableAssetViews = new HashMap<String, View>(clickableAssetViews);
        copyClickableAssetViews.remove("3011");
        copyClickableAssetViews.remove("3012");
        ArrayList<View> assetViews = new ArrayList<View>(copyClickableAssetViews.values());
        block0: for (int i = 0; i < assetViews.size(); ++i) {
            View clickView = assetViews.get(i);
            if (!(clickView instanceof MediaView)) continue;
            MediaView mediaView = (MediaView)clickView;
            for (int a = 0; a < mediaView.getChildCount(); ++a) {
                View childView = mediaView.getChildAt(a);
                if (!(childView instanceof MBMediaView)) continue;
                ((MBMediaView)childView).setOnMediaViewListener((OnMBMediaViewListener)this);
                break block0;
            }
            break;
        }
        if (this.mbBidNativeHandler != null) {
            this.mbBidNativeHandler.registerView(view, assetViews, this.campaign);
        }
    }

    public void untrackView(View view) {
        if (this.mbBidNativeHandler != null) {
            this.mbBidNativeHandler.unregisterView(view, this.traversalView(view), this.campaign);
        }
    }
}

