/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.mintegral.rtb;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import com.google.ads.mediation.mintegral.MintegralFactory;
import com.google.ads.mediation.mintegral.MintegralMediationAdapter;
import com.google.ads.mediation.mintegral.MintegralUtils;
import com.google.ads.mediation.mintegral.mediation.MintegralAppOpenAd;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationAppOpenAd;
import com.google.android.gms.ads.mediation.MediationAppOpenAdCallback;
import com.google.android.gms.ads.mediation.MediationAppOpenAdConfiguration;
import org.json.JSONException;
import org.json.JSONObject;

public class MintegralRtbAppOpenAd
extends MintegralAppOpenAd {
    private String bidToken;

    public MintegralRtbAppOpenAd(@NonNull MediationAppOpenAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationAppOpenAd, MediationAppOpenAdCallback> callback) {
        super(adConfiguration, callback);
    }

    @Override
    public void loadAd() {
        this.activity = (Activity)this.adConfiguration.getContext();
        Bundle serverParameters = this.adConfiguration.getServerParameters();
        String adUnitId = serverParameters.getString("ad_unit_id");
        String placementId = serverParameters.getString("placement_id");
        this.bidToken = this.adConfiguration.getBidResponse();
        AdError error = MintegralUtils.validateMintegralAdLoadParams(adUnitId, placementId, this.bidToken);
        if (error != null) {
            this.adLoadCallback.onFailure(error);
            return;
        }
        this.splashAdWrapper = MintegralFactory.createSplashAdWrapper();
        String watermark = this.adConfiguration.getWatermark();
        if (!TextUtils.isEmpty((CharSequence)watermark)) {
            this.setWatermark(watermark);
        }
        this.splashAdWrapper.createAd(placementId, adUnitId);
        this.splashAdWrapper.setSplashLoadListener(this);
        this.splashAdWrapper.setSplashShowListener(this);
        this.splashAdWrapper.preLoadByToken(this.bidToken);
    }

    public void showAd(@NonNull Context context) {
        if (this.splashAdWrapper != null) {
            RelativeLayout layout = new RelativeLayout((Context)this.activity);
            ((ViewGroup)this.activity.getWindow().getDecorView().findViewById(0x1020002)).addView((View)layout);
            this.splashAdWrapper.show((ViewGroup)layout, this.bidToken);
        }
    }

    private void setWatermark(String watermark) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("watermark", (Object)watermark);
            this.splashAdWrapper.setExtraInfo(jsonObject);
        }
        catch (JSONException jsonException) {
            Log.w((String)MintegralMediationAdapter.TAG, (String)"Failed to apply watermark to Mintegral bidding app open ad.", (Throwable)jsonException);
        }
    }
}

