/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.mintegral.mediation;

import android.util.Log;
import androidx.annotation.NonNull;
import com.google.ads.mediation.mintegral.MintegralConstants;
import com.google.ads.mediation.mintegral.MintegralMediationAdapter;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAd;
import com.google.android.gms.ads.mediation.MediationInterstitialAdCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAdConfiguration;
import com.mbridge.msdk.newinterstitial.out.NewInterstitialWithCodeListener;
import com.mbridge.msdk.out.MBridgeIds;
import com.mbridge.msdk.out.RewardInfo;

public abstract class MintegralInterstitialAd
extends NewInterstitialWithCodeListener
implements MediationInterstitialAd {
    protected final MediationInterstitialAdConfiguration adConfiguration;
    protected final MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> adLoadCallback;
    protected MediationInterstitialAdCallback interstitialAdCallback;

    public MintegralInterstitialAd(@NonNull MediationInterstitialAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> callback) {
        this.adConfiguration = adConfiguration;
        this.adLoadCallback = callback;
    }

    public abstract void loadAd();

    public void onLoadCampaignSuccess(MBridgeIds mBridgeIds) {
    }

    public void onResourceLoadSuccess(MBridgeIds mBridgeIds) {
        this.interstitialAdCallback = (MediationInterstitialAdCallback)this.adLoadCallback.onSuccess((Object)this);
    }

    public void onResourceLoadFailWithCode(MBridgeIds mBridgeIds, int errorCode, String errorMessage) {
        AdError error = MintegralConstants.createSdkError(errorCode, errorMessage);
        Log.w((String)MintegralMediationAdapter.TAG, (String)error.toString());
        this.adLoadCallback.onFailure(error);
    }

    public void onAdShow(MBridgeIds mBridgeIds) {
        if (this.interstitialAdCallback != null) {
            this.interstitialAdCallback.onAdOpened();
            this.interstitialAdCallback.reportAdImpression();
        }
    }

    public void onAdClose(MBridgeIds mBridgeIds, RewardInfo rewardInfo) {
        if (this.interstitialAdCallback != null) {
            this.interstitialAdCallback.onAdClosed();
        }
    }

    public void onShowFailWithCode(MBridgeIds mBridgeIds, int errorCode, String errorMessage) {
        AdError error = MintegralConstants.createSdkError(errorCode, errorMessage);
        Log.w((String)MintegralMediationAdapter.TAG, (String)error.toString());
        if (this.interstitialAdCallback != null) {
            this.interstitialAdCallback.onAdFailedToShow(error);
        }
    }

    public void onAdClicked(MBridgeIds mBridgeIds) {
        if (this.interstitialAdCallback != null) {
            this.interstitialAdCallback.reportAdClicked();
        }
    }

    public void onVideoComplete(MBridgeIds mBridgeIds) {
    }

    public void onAdCloseWithNIReward(MBridgeIds mBridgeIds, RewardInfo rewardInfo) {
    }

    public void onEndcardShow(MBridgeIds mBridgeIds) {
    }
}

