/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.mintegral.mediation;

import android.util.Log;
import androidx.annotation.NonNull;
import com.google.ads.mediation.mintegral.MintegralConstants;
import com.google.ads.mediation.mintegral.MintegralMediationAdapter;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.mbridge.msdk.out.MBridgeIds;
import com.mbridge.msdk.out.RewardInfo;
import com.mbridge.msdk.out.RewardVideoWithCodeListener;

public abstract class MintegralRewardedAd
extends RewardVideoWithCodeListener
implements MediationRewardedAd {
    protected final MediationRewardedAdConfiguration adConfiguration;
    protected final MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> adLoadCallback;
    protected MediationRewardedAdCallback rewardedAdCallback;

    public MintegralRewardedAd(@NonNull MediationRewardedAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> adLoadCallback) {
        this.adConfiguration = adConfiguration;
        this.adLoadCallback = adLoadCallback;
    }

    public abstract void loadAd();

    public void onVideoLoadSuccess(MBridgeIds mBridgeIds) {
        this.rewardedAdCallback = (MediationRewardedAdCallback)this.adLoadCallback.onSuccess((Object)this);
    }

    public void onLoadSuccess(MBridgeIds mBridgeIds) {
    }

    public void onVideoLoadFailWithCode(MBridgeIds mBridgeIds, int errorCode, String errorMessage) {
        AdError error = MintegralConstants.createSdkError(errorCode, errorMessage);
        Log.w((String)MintegralMediationAdapter.TAG, (String)error.toString());
        this.adLoadCallback.onFailure(error);
    }

    public void onAdShow(MBridgeIds mBridgeIds) {
        if (this.rewardedAdCallback != null) {
            this.rewardedAdCallback.onAdOpened();
            this.rewardedAdCallback.reportAdImpression();
        }
    }

    public void onAdClose(MBridgeIds mBridgeIds, final RewardInfo rewardInfo) {
        if (this.rewardedAdCallback == null) {
            return;
        }
        if (rewardInfo != null && rewardInfo.isCompleteView()) {
            RewardItem rewardItem = new RewardItem(){

                @NonNull
                public String getType() {
                    return rewardInfo.getRewardName();
                }

                public int getAmount() {
                    int amount = 0;
                    try {
                        amount = Integer.getInteger(rewardInfo.getRewardAmount());
                    }
                    catch (Exception exception) {
                        Log.w((String)MintegralMediationAdapter.TAG, (String)"Failed to get reward amount.", (Throwable)exception);
                    }
                    return amount;
                }
            };
            this.rewardedAdCallback.onUserEarnedReward(rewardItem);
        } else {
            Log.w((String)MintegralMediationAdapter.TAG, (String)"Mintegral SDK failed to reward user due to missing rewarded settings or rewarded ad playback not completed.");
        }
        this.rewardedAdCallback.onAdClosed();
    }

    public void onShowFailWithCode(MBridgeIds mBridgeIds, int errorCode, String errorMessage) {
        AdError error = MintegralConstants.createSdkError(errorCode, errorMessage);
        Log.w((String)MintegralMediationAdapter.TAG, (String)error.toString());
        if (this.rewardedAdCallback != null) {
            this.rewardedAdCallback.onAdFailedToShow(error);
        }
    }

    public void onVideoAdClicked(MBridgeIds mBridgeIds) {
        if (this.rewardedAdCallback != null) {
            this.rewardedAdCallback.reportAdClicked();
        }
    }

    public void onVideoComplete(MBridgeIds mBridgeIds) {
    }

    public void onEndcardShow(MBridgeIds mBridgeIds) {
    }
}

