/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.mintegral.waterfall;

import android.util.Log;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.google.ads.mediation.mintegral.MintegralConstants;
import com.google.ads.mediation.mintegral.MintegralMediationAdapter;
import com.google.ads.mediation.mintegral.MintegralUtils;
import com.google.ads.mediation.mintegral.mediation.MintegralBannerAd;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationBannerAd;
import com.google.android.gms.ads.mediation.MediationBannerAdCallback;
import com.google.android.gms.ads.mediation.MediationBannerAdConfiguration;
import com.mbridge.msdk.out.BannerAdListener;
import com.mbridge.msdk.out.BannerSize;
import com.mbridge.msdk.out.MBBannerView;

public class MintegralWaterfallBannerAd
extends MintegralBannerAd {
    public MintegralWaterfallBannerAd(@NonNull MediationBannerAdConfiguration mediationBannerAdConfiguration, @NonNull MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> mediationAdLoadCallback) {
        super(mediationBannerAdConfiguration, mediationAdLoadCallback);
    }

    @Override
    public void loadAd() {
        String placementId;
        BannerSize bannerSize = MintegralWaterfallBannerAd.getMintegralBannerSizeFromAdMobAdSize(this.adConfiguration.getAdSize(), this.adConfiguration.getContext());
        if (bannerSize == null) {
            AdError bannerSizeError = MintegralConstants.createAdapterError(102, String.format("The requested banner size: %s is not supported by Mintegral SDK.", this.adConfiguration.getAdSize()));
            Log.e((String)MintegralMediationAdapter.TAG, (String)bannerSizeError.toString());
            this.adLoadCallback.onFailure(bannerSizeError);
            return;
        }
        String adUnitId = this.adConfiguration.getServerParameters().getString("ad_unit_id");
        AdError error = MintegralUtils.validateMintegralAdLoadParams(adUnitId, placementId = this.adConfiguration.getServerParameters().getString("placement_id"));
        if (error != null) {
            this.adLoadCallback.onFailure(error);
            return;
        }
        this.mbBannerView = new MBBannerView(this.adConfiguration.getContext());
        this.mbBannerView.init(bannerSize, placementId, adUnitId);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(MintegralUtils.convertDipToPixel(this.adConfiguration.getContext(), bannerSize.getWidth()), MintegralUtils.convertDipToPixel(this.adConfiguration.getContext(), bannerSize.getHeight()));
        this.mbBannerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mbBannerView.setBannerAdListener((BannerAdListener)this);
        this.mbBannerView.load();
    }
}

