/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.mintegral.mediation;

import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.google.ads.mediation.mintegral.MintegralUtils;
import com.google.ads.mediation.mintegral.mediation.MintegralNativeAdListener;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdConfiguration;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.ads.nativead.MediaView;
import com.mbridge.msdk.nativex.view.MBMediaView;
import com.mbridge.msdk.out.Campaign;
import com.mbridge.msdk.out.OnMBMediaViewListener;
import com.mbridge.msdk.widget.MBAdChoice;
import java.util.ArrayList;
import java.util.List;

public abstract class MintegralNativeAd
extends UnifiedNativeAdMapper
implements OnMBMediaViewListener {
    protected Campaign campaign;
    protected final MediationNativeAdConfiguration adConfiguration;
    protected final MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> adLoadCallback;
    protected static final double MINTEGRAL_SDK_IMAGE_SCALE = 1.0;
    public MintegralNativeAdListener mintegralNativeAdListener;

    public MintegralNativeAd(@NonNull MediationNativeAdConfiguration mediationNativeAdConfiguration, @NonNull MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> mediationAdLoadCallback) {
        this.adConfiguration = mediationNativeAdConfiguration;
        this.adLoadCallback = mediationAdLoadCallback;
        this.mintegralNativeAdListener = new MintegralNativeAdListener(this);
    }

    public abstract void loadAd();

    @NonNull
    protected void mapNativeAd(@NonNull Campaign ad) {
        this.campaign = ad;
        if (this.campaign.getAppName() != null) {
            this.setHeadline(this.campaign.getAppName());
        }
        if (this.campaign.getAppDesc() != null) {
            this.setBody(this.campaign.getAppDesc());
        }
        if (this.campaign.getAdCall() != null) {
            this.setCallToAction(this.campaign.getAdCall());
        }
        this.setStarRating(this.campaign.getRating());
        if (!TextUtils.isEmpty((CharSequence)this.campaign.getIconUrl())) {
            this.setIcon(new MBridgeNativeMappedImage(null, Uri.parse((String)this.campaign.getIconUrl()), 1.0));
        }
        MBMediaView mbMediaView = new MBMediaView(this.adConfiguration.getContext());
        boolean muted = MintegralUtils.shouldMuteAudio(this.adConfiguration.getMediationExtras());
        mbMediaView.setVideoSoundOnOff(!muted);
        mbMediaView.setNativeAd(this.campaign);
        this.setMediaView((View)mbMediaView);
        MBAdChoice mbAdChoice = new MBAdChoice(this.adConfiguration.getContext());
        mbAdChoice.setCampaign(this.campaign);
        this.setAdChoicesContent((View)mbAdChoice);
        this.setOverrideClickHandling(true);
    }

    protected List traversalView(View view) {
        ArrayList<View> viewList = new ArrayList<View>();
        if (view == null) {
            return viewList;
        }
        if (view instanceof MediaView) {
            viewList.add(view);
        } else if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                if (viewGroup.getChildAt(i) instanceof ViewGroup) {
                    viewList.addAll(this.traversalView(viewGroup.getChildAt(i)));
                    continue;
                }
                viewList.add(viewGroup.getChildAt(i));
            }
        } else if (view instanceof View) {
            viewList.add(view);
        }
        return viewList;
    }

    public void onEnterFullscreen() {
        if (this.mintegralNativeAdListener.nativeCallback != null) {
            this.mintegralNativeAdListener.nativeCallback.onAdOpened();
        }
    }

    public void onExitFullscreen() {
        if (this.mintegralNativeAdListener.nativeCallback != null) {
            this.mintegralNativeAdListener.nativeCallback.onAdClosed();
        }
    }

    public void onStartRedirection(Campaign campaign, String s) {
    }

    public void onFinishRedirection(Campaign campaign, String s) {
    }

    public void onRedirectionFailed(Campaign campaign, String s) {
    }

    public void onVideoAdClicked(Campaign campaign) {
        if (this.mintegralNativeAdListener.nativeCallback != null) {
            this.mintegralNativeAdListener.nativeCallback.reportAdClicked();
        }
    }

    public void onVideoStart() {
        if (this.mintegralNativeAdListener.nativeCallback != null) {
            this.mintegralNativeAdListener.nativeCallback.onVideoPlay();
        }
    }

    public class MBridgeNativeMappedImage
    extends NativeAd.Image {
        private final Drawable drawable;
        private final Uri imageUri;
        private final double scale;

        public MBridgeNativeMappedImage(Drawable drawable, Uri imageUri, double scale) {
            this.drawable = drawable;
            this.imageUri = imageUri;
            this.scale = scale;
        }

        public Drawable getDrawable() {
            return this.drawable;
        }

        @NonNull
        public Uri getUri() {
            return this.imageUri;
        }

        public double getScale() {
            return this.scale;
        }
    }
}

