/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.mintegral.rtb;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.ads.mediation.mintegral.MintegralMediationAdapter;
import com.google.ads.mediation.mintegral.MintegralUtils;
import com.google.ads.mediation.mintegral.mediation.MintegralRewardedAd;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;
import com.mbridge.msdk.out.MBBidRewardVideoHandler;
import com.mbridge.msdk.video.bt.module.b.g;
import org.json.JSONException;
import org.json.JSONObject;

public class MintegralRtbRewardedAd
extends MintegralRewardedAd {
    private MBBidRewardVideoHandler mbBidRewardVideoHandler;

    public MintegralRtbRewardedAd(@NonNull MediationRewardedAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> adLoadCallback) {
        super(adConfiguration, adLoadCallback);
    }

    @Override
    public void loadAd() {
        String bidToken;
        String placementId;
        String adUnitId = this.adConfiguration.getServerParameters().getString("ad_unit_id");
        AdError error = MintegralUtils.validateMintegralAdLoadParams(adUnitId, placementId = this.adConfiguration.getServerParameters().getString("placement_id"), bidToken = this.adConfiguration.getBidResponse());
        if (error != null) {
            this.adLoadCallback.onFailure(error);
            return;
        }
        this.mbBidRewardVideoHandler = new MBBidRewardVideoHandler(this.adConfiguration.getContext(), placementId, adUnitId);
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("watermark", (Object)this.adConfiguration.getWatermark());
            this.mbBidRewardVideoHandler.setExtraInfo(jsonObject);
        }
        catch (JSONException jsonException) {
            Log.w((String)MintegralMediationAdapter.TAG, (String)"Failed to apply watermark to Mintegral bidding rewarded video ad.", (Throwable)jsonException);
        }
        this.mbBidRewardVideoHandler.setRewardVideoListener((g)this);
        this.mbBidRewardVideoHandler.loadFromBid(bidToken);
    }

    public void showAd(@NonNull Context context) {
        boolean muted = MintegralUtils.shouldMuteAudio(this.adConfiguration.getMediationExtras());
        this.mbBidRewardVideoHandler.playVideoMute(muted ? 1 : 2);
        this.mbBidRewardVideoHandler.showFromBid();
    }
}

