/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.mintegral.mediation;

import android.content.Context;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.ads.mediation.mintegral.MintegralConstants;
import com.google.ads.mediation.mintegral.MintegralMediationAdapter;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.MediationUtils;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationBannerAd;
import com.google.android.gms.ads.mediation.MediationBannerAdCallback;
import com.google.android.gms.ads.mediation.MediationBannerAdConfiguration;
import com.mbridge.msdk.out.BannerAdWithCodeListener;
import com.mbridge.msdk.out.BannerSize;
import com.mbridge.msdk.out.MBBannerView;
import com.mbridge.msdk.out.MBridgeIds;
import java.util.ArrayList;

public abstract class MintegralBannerAd
extends BannerAdWithCodeListener
implements MediationBannerAd {
    protected MediationBannerAdConfiguration adConfiguration;
    protected final MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> adLoadCallback;
    protected MBBannerView mbBannerView;
    protected MediationBannerAdCallback bannerAdCallback;

    public MintegralBannerAd(@NonNull MediationBannerAdConfiguration mediationBannerAdConfiguration, @NonNull MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> mediationAdLoadCallback) {
        this.adConfiguration = mediationBannerAdConfiguration;
        this.adLoadCallback = mediationAdLoadCallback;
    }

    public abstract void loadAd();

    @Nullable
    public static BannerSize getMintegralBannerSizeFromAdMobAdSize(@NonNull AdSize adSize, @NonNull Context context) {
        ArrayList<AdSize> supportedAdSizes = new ArrayList<AdSize>();
        supportedAdSizes.add(new AdSize(320, 50));
        supportedAdSizes.add(new AdSize(300, 250));
        supportedAdSizes.add(new AdSize(728, 90));
        AdSize closestSize = MediationUtils.findClosestSize((Context)context, (AdSize)adSize, supportedAdSizes);
        if (closestSize == null) {
            return null;
        }
        BannerSize bannerSize = null;
        if (closestSize.equals((Object)AdSize.BANNER)) {
            bannerSize = new BannerSize(4, 0, 0);
        }
        if (closestSize.equals((Object)AdSize.MEDIUM_RECTANGLE)) {
            bannerSize = new BannerSize(2, 0, 0);
        }
        if (closestSize.equals((Object)AdSize.LEADERBOARD)) {
            bannerSize = new BannerSize(3, closestSize.getWidth(), 0);
        }
        if (bannerSize == null) {
            bannerSize = new BannerSize(5, closestSize.getWidth(), closestSize.getHeight());
        }
        return bannerSize;
    }

    @NonNull
    public View getView() {
        return this.mbBannerView;
    }

    public void onLoadFailedWithCode(MBridgeIds mBridgeIds, int errorCode, String errorMessage) {
        AdError error = MintegralConstants.createSdkError(errorCode, errorMessage);
        Log.w((String)MintegralMediationAdapter.TAG, (String)error.toString());
        this.adLoadCallback.onFailure(error);
    }

    public void onLoadSuccessed(MBridgeIds mBridgeIds) {
        if (this.adLoadCallback != null) {
            this.bannerAdCallback = (MediationBannerAdCallback)this.adLoadCallback.onSuccess((Object)this);
        }
    }

    public void onLogImpression(MBridgeIds mBridgeIds) {
        if (this.bannerAdCallback != null) {
            this.bannerAdCallback.reportAdImpression();
        }
    }

    public void onClick(MBridgeIds mBridgeIds) {
        if (this.bannerAdCallback != null) {
            this.bannerAdCallback.reportAdClicked();
        }
    }

    public void onLeaveApp(MBridgeIds mBridgeIds) {
        if (this.bannerAdCallback != null) {
            this.bannerAdCallback.onAdLeftApplication();
        }
    }

    public void showFullScreen(MBridgeIds mBridgeIds) {
        if (this.bannerAdCallback != null) {
            this.bannerAdCallback.onAdOpened();
        }
    }

    public void closeFullScreen(MBridgeIds mBridgeIds) {
        if (this.bannerAdCallback != null) {
            this.bannerAdCallback.onAdClosed();
        }
    }

    public void onCloseBanner(MBridgeIds mBridgeIds) {
        if (this.bannerAdCallback != null) {
            this.bannerAdCallback.onAdClosed();
        }
    }
}

