/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.pangle.renderer;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.bytedance.sdk.openadsdk.api.PAGRequest;
import com.bytedance.sdk.openadsdk.api.nativeAd.PAGNativeAd;
import com.bytedance.sdk.openadsdk.api.nativeAd.PAGNativeAdData;
import com.bytedance.sdk.openadsdk.api.nativeAd.PAGNativeAdInteractionListener;
import com.bytedance.sdk.openadsdk.api.nativeAd.PAGNativeAdLoadListener;
import com.bytedance.sdk.openadsdk.api.nativeAd.PAGNativeRequest;
import com.google.ads.mediation.pangle.PangleConstants;
import com.google.ads.mediation.pangle.PangleFactory;
import com.google.ads.mediation.pangle.PangleInitializer;
import com.google.ads.mediation.pangle.PangleMediationAdapter;
import com.google.ads.mediation.pangle.PanglePrivacyConfig;
import com.google.ads.mediation.pangle.PangleRequestHelper;
import com.google.ads.mediation.pangle.PangleSdkWrapper;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.mediation.MediationAdConfiguration;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdConfiguration;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PangleNativeAd
extends UnifiedNativeAdMapper {
    @VisibleForTesting
    static final double PANGLE_SDK_IMAGE_SCALE = 1.0;
    @VisibleForTesting
    static final String ASSET_ID_ADCHOICES_TEXT_VIEW = "3012";
    private final MediationNativeAdConfiguration adConfiguration;
    private final MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> adLoadCallback;
    private final PangleInitializer pangleInitializer;
    private final PangleSdkWrapper pangleSdkWrapper;
    private final PangleFactory pangleFactory;
    private final PanglePrivacyConfig panglePrivacyConfig;
    private MediationNativeAdCallback callback;
    private PAGNativeAd pagNativeAd;

    public PangleNativeAd(@NonNull MediationNativeAdConfiguration mediationNativeAdConfiguration, @NonNull MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> mediationAdLoadCallback, @NonNull PangleInitializer pangleInitializer, @NonNull PangleSdkWrapper pangleSdkWrapper, @NonNull PangleFactory pangleFactory, @NonNull PanglePrivacyConfig panglePrivacyConfig) {
        this.adConfiguration = mediationNativeAdConfiguration;
        this.adLoadCallback = mediationAdLoadCallback;
        this.pangleInitializer = pangleInitializer;
        this.pangleSdkWrapper = pangleSdkWrapper;
        this.pangleFactory = pangleFactory;
        this.panglePrivacyConfig = panglePrivacyConfig;
    }

    public void render() {
        this.panglePrivacyConfig.setCoppa(this.adConfiguration.taggedForChildDirectedTreatment());
        Bundle serverParameters = this.adConfiguration.getServerParameters();
        final String placementId = serverParameters.getString("placementid");
        if (TextUtils.isEmpty((CharSequence)placementId)) {
            AdError error = PangleConstants.createAdapterError(101, "Failed to load native ad from Pangle. Missing or invalid Placement ID.");
            Log.e((String)PangleMediationAdapter.TAG, (String)error.toString());
            this.adLoadCallback.onFailure(error);
            return;
        }
        final String bidResponse = this.adConfiguration.getBidResponse();
        Context context = this.adConfiguration.getContext();
        String appId = serverParameters.getString("appid");
        this.pangleInitializer.initialize(context, appId, new PangleInitializer.Listener(){

            @Override
            public void onInitializeSuccess() {
                PAGNativeRequest request = PangleNativeAd.this.pangleFactory.createPagNativeRequest();
                request.setAdString(bidResponse);
                PangleRequestHelper.setWatermarkString((PAGRequest)request, bidResponse, (MediationAdConfiguration)PangleNativeAd.this.adConfiguration);
                PangleNativeAd.this.pangleSdkWrapper.loadNativeAd(placementId, request, new PAGNativeAdLoadListener(){

                    public void onError(int errorCode, String message) {
                        AdError error = PangleConstants.createSdkError(errorCode, message);
                        Log.w((String)PangleMediationAdapter.TAG, (String)error.toString());
                        PangleNativeAd.this.adLoadCallback.onFailure(error);
                    }

                    public void onAdLoaded(PAGNativeAd pagNativeAd) {
                        PangleNativeAd.this.mapNativeAd(pagNativeAd);
                        PangleNativeAd.this.callback = (MediationNativeAdCallback)PangleNativeAd.this.adLoadCallback.onSuccess((Object)PangleNativeAd.this);
                    }
                });
            }

            @Override
            public void onInitializeError(@NonNull AdError error) {
                Log.w((String)PangleMediationAdapter.TAG, (String)error.toString());
                PangleNativeAd.this.adLoadCallback.onFailure(error);
            }
        });
    }

    private void mapNativeAd(PAGNativeAd ad) {
        this.pagNativeAd = ad;
        PAGNativeAdData nativeAdData = this.pagNativeAd.getNativeAdData();
        this.setHeadline(nativeAdData.getTitle());
        this.setBody(nativeAdData.getDescription());
        this.setCallToAction(nativeAdData.getButtonText());
        if (nativeAdData.getIcon() != null) {
            this.setIcon(new PangleNativeMappedImage(null, Uri.parse((String)nativeAdData.getIcon().getImageUrl()), 1.0));
        }
        this.setOverrideClickHandling(true);
        this.setMediaView((View)nativeAdData.getMediaView());
        this.setAdChoicesContent(nativeAdData.getAdLogoView());
    }

    public void trackViews(@NonNull View containerView, @NonNull Map<String, View> clickableAssetViews, @NonNull Map<String, View> nonClickableAssetViews) {
        HashMap<String, View> copyClickableAssetViews = new HashMap<String, View>(clickableAssetViews);
        copyClickableAssetViews.remove("3011");
        copyClickableAssetViews.remove(ASSET_ID_ADCHOICES_TEXT_VIEW);
        View creativeBtn = copyClickableAssetViews.get("3002");
        ArrayList<View> creativeViews = new ArrayList<View>();
        if (creativeBtn != null) {
            creativeViews.add(creativeBtn);
        }
        ArrayList<View> assetViews = new ArrayList<View>(copyClickableAssetViews.values());
        this.pagNativeAd.registerViewForInteraction((ViewGroup)containerView, assetViews, creativeViews, null, new PAGNativeAdInteractionListener(){

            public void onAdClicked() {
                if (PangleNativeAd.this.callback != null) {
                    PangleNativeAd.this.callback.reportAdClicked();
                }
            }

            public void onAdShowed() {
                if (PangleNativeAd.this.callback != null) {
                    PangleNativeAd.this.callback.reportAdImpression();
                }
            }

            public void onAdDismissed() {
            }
        });
        this.getAdChoicesContent().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PangleNativeAd.this.pagNativeAd.showPrivacyActivity();
            }
        });
    }

    public class PangleNativeMappedImage
    extends NativeAd.Image {
        private final Drawable drawable;
        private final Uri imageUri;
        private final double scale;

        private PangleNativeMappedImage(Drawable drawable, Uri imageUri, double scale) {
            this.drawable = drawable;
            this.imageUri = imageUri;
            this.scale = scale;
        }

        @NonNull
        public Drawable getDrawable() {
            return this.drawable;
        }

        @NonNull
        public Uri getUri() {
            return this.imageUri;
        }

        public double getScale() {
            return this.scale;
        }
    }
}

