/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.pangle.renderer;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.bytedance.sdk.openadsdk.api.PAGRequest;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAd;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAdInteractionListener;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAdLoadListener;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerRequest;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerSize;
import com.google.ads.mediation.pangle.PangleConstants;
import com.google.ads.mediation.pangle.PangleFactory;
import com.google.ads.mediation.pangle.PangleInitializer;
import com.google.ads.mediation.pangle.PangleMediationAdapter;
import com.google.ads.mediation.pangle.PanglePrivacyConfig;
import com.google.ads.mediation.pangle.PangleRequestHelper;
import com.google.ads.mediation.pangle.PangleSdkWrapper;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.MediationUtils;
import com.google.android.gms.ads.mediation.MediationAdConfiguration;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationBannerAd;
import com.google.android.gms.ads.mediation.MediationBannerAdCallback;
import com.google.android.gms.ads.mediation.MediationBannerAdConfiguration;
import java.util.ArrayList;
import java.util.List;

public class PangleBannerAd
implements MediationBannerAd,
PAGBannerAdInteractionListener {
    @VisibleForTesting
    public static final String ERROR_MESSAGE_BANNER_SIZE_MISMATCH = "Failed to request banner ad from Pangle. Invalid banner size.";
    private final MediationBannerAdConfiguration adConfiguration;
    private final MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> adLoadCallback;
    private final PangleInitializer pangleInitializer;
    private final PangleSdkWrapper pangleSdkWrapper;
    private final PangleFactory pangleFactory;
    private final PanglePrivacyConfig panglePrivacyConfig;
    private MediationBannerAdCallback bannerAdCallback;
    @VisibleForTesting
    FrameLayout wrappedAdView;

    public PangleBannerAd(@NonNull MediationBannerAdConfiguration mediationBannerAdConfiguration, @NonNull MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> mediationAdLoadCallback, @NonNull PangleInitializer pangleInitializer, @NonNull PangleSdkWrapper pangleSdkWrapper, @NonNull PangleFactory pangleFactory, @NonNull PanglePrivacyConfig panglePrivacyConfig) {
        this.adConfiguration = mediationBannerAdConfiguration;
        this.adLoadCallback = mediationAdLoadCallback;
        this.pangleInitializer = pangleInitializer;
        this.pangleSdkWrapper = pangleSdkWrapper;
        this.pangleFactory = pangleFactory;
        this.panglePrivacyConfig = panglePrivacyConfig;
    }

    public void render() {
        this.panglePrivacyConfig.setCoppa(this.adConfiguration.taggedForChildDirectedTreatment());
        Bundle serverParameters = this.adConfiguration.getServerParameters();
        final String placementId = serverParameters.getString("placementid");
        if (TextUtils.isEmpty((CharSequence)placementId)) {
            AdError error = PangleConstants.createAdapterError(101, "Failed to load banner ad from Pangle. Missing or invalid Placement ID.");
            Log.e((String)PangleMediationAdapter.TAG, (String)error.toString());
            this.adLoadCallback.onFailure(error);
            return;
        }
        final String bidResponse = this.adConfiguration.getBidResponse();
        final Context context = this.adConfiguration.getContext();
        String appId = serverParameters.getString("appid");
        this.pangleInitializer.initialize(context, appId, new PangleInitializer.Listener(){

            @Override
            public void onInitializeSuccess() {
                AdSize closestSize = MediationUtils.findClosestSize((Context)context, (AdSize)PangleBannerAd.this.adConfiguration.getAdSize(), PangleBannerAd.getSupportedBannerSizes());
                if (closestSize == null) {
                    AdError error = PangleConstants.createAdapterError(102, PangleBannerAd.ERROR_MESSAGE_BANNER_SIZE_MISMATCH);
                    Log.w((String)PangleMediationAdapter.TAG, (String)error.toString());
                    PangleBannerAd.this.adLoadCallback.onFailure(error);
                    return;
                }
                PangleBannerAd.this.wrappedAdView = new FrameLayout(context);
                PAGBannerRequest request = PangleBannerAd.this.pangleFactory.createPagBannerRequest(new PAGBannerSize(closestSize.getWidth(), closestSize.getHeight()));
                request.setAdString(bidResponse);
                PangleRequestHelper.setWatermarkString((PAGRequest)request, bidResponse, (MediationAdConfiguration)PangleBannerAd.this.adConfiguration);
                PangleBannerAd.this.pangleSdkWrapper.loadBannerAd(placementId, request, new PAGBannerAdLoadListener(){

                    public void onError(int errorCode, String errorMessage) {
                        AdError error = PangleConstants.createSdkError(errorCode, errorMessage);
                        Log.w((String)PangleMediationAdapter.TAG, (String)error.toString());
                        PangleBannerAd.this.adLoadCallback.onFailure(error);
                    }

                    public void onAdLoaded(PAGBannerAd pagBannerAd) {
                        pagBannerAd.setAdInteractionListener((PAGBannerAdInteractionListener)PangleBannerAd.this);
                        PangleBannerAd.this.wrappedAdView.addView(pagBannerAd.getBannerView());
                        PangleBannerAd.this.bannerAdCallback = (MediationBannerAdCallback)PangleBannerAd.this.adLoadCallback.onSuccess((Object)PangleBannerAd.this);
                    }
                });
            }

            @Override
            public void onInitializeError(@NonNull AdError error) {
                Log.w((String)PangleMediationAdapter.TAG, (String)error.toString());
                PangleBannerAd.this.adLoadCallback.onFailure(error);
            }
        });
    }

    @NonNull
    public View getView() {
        return this.wrappedAdView;
    }

    public void onAdShowed() {
        if (this.bannerAdCallback != null) {
            this.bannerAdCallback.reportAdImpression();
        }
    }

    public void onAdClicked() {
        if (this.bannerAdCallback != null) {
            this.bannerAdCallback.reportAdClicked();
        }
    }

    public void onAdDismissed() {
    }

    @VisibleForTesting
    static List<AdSize> getSupportedBannerSizes() {
        ArrayList<AdSize> supportedSizes = new ArrayList<AdSize>(3);
        supportedSizes.add(new AdSize(320, 50));
        supportedSizes.add(new AdSize(300, 250));
        supportedSizes.add(new AdSize(728, 90));
        return supportedSizes;
    }
}

