/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.pangle;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.bytedance.sdk.openadsdk.api.PAGConstant;
import com.bytedance.sdk.openadsdk.api.init.BiddingTokenCallback;
import com.google.ads.mediation.pangle.PangleConstants;
import com.google.ads.mediation.pangle.PangleFactory;
import com.google.ads.mediation.pangle.PangleInitializer;
import com.google.ads.mediation.pangle.PanglePrivacyConfig;
import com.google.ads.mediation.pangle.PangleSdkWrapper;
import com.google.ads.mediation.pangle.renderer.PangleAppOpenAd;
import com.google.ads.mediation.pangle.renderer.PangleBannerAd;
import com.google.ads.mediation.pangle.renderer.PangleInterstitialAd;
import com.google.ads.mediation.pangle.renderer.PangleNativeAd;
import com.google.ads.mediation.pangle.renderer.PangleRewardedAd;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.mediation.InitializationCompleteCallback;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationAppOpenAd;
import com.google.android.gms.ads.mediation.MediationAppOpenAdCallback;
import com.google.android.gms.ads.mediation.MediationAppOpenAdConfiguration;
import com.google.android.gms.ads.mediation.MediationBannerAd;
import com.google.android.gms.ads.mediation.MediationBannerAdCallback;
import com.google.android.gms.ads.mediation.MediationBannerAdConfiguration;
import com.google.android.gms.ads.mediation.MediationConfiguration;
import com.google.android.gms.ads.mediation.MediationInterstitialAd;
import com.google.android.gms.ads.mediation.MediationInterstitialAdCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAdConfiguration;
import com.google.android.gms.ads.mediation.MediationNativeAdCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdConfiguration;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.ads.mediation.rtb.RtbAdapter;
import com.google.android.gms.ads.mediation.rtb.RtbSignalData;
import com.google.android.gms.ads.mediation.rtb.SignalCallbacks;
import java.util.HashSet;
import java.util.List;

public class PangleMediationAdapter
extends RtbAdapter {
    public static final String TAG = PangleMediationAdapter.class.getSimpleName();
    @VisibleForTesting
    static final String ERROR_MESSAGE_MISSING_OR_INVALID_APP_ID = "Missing or invalid App ID.";
    private final PangleInitializer pangleInitializer;
    private final PangleSdkWrapper pangleSdkWrapper;
    private final PangleFactory pangleFactory;
    private final PanglePrivacyConfig panglePrivacyConfig;
    private PangleAppOpenAd appOpenAd;
    private PangleBannerAd bannerAd;
    private PangleInterstitialAd interstitialAd;
    private PangleNativeAd nativeAd;
    private PangleRewardedAd rewardedAd;
    private static int gdpr = -1;
    private static int ccpa = -1;

    public PangleMediationAdapter() {
        this.pangleInitializer = PangleInitializer.getInstance();
        this.pangleSdkWrapper = new PangleSdkWrapper();
        this.pangleFactory = new PangleFactory();
        this.panglePrivacyConfig = new PanglePrivacyConfig(this.pangleSdkWrapper);
    }

    @VisibleForTesting
    PangleMediationAdapter(PangleInitializer pangleInitializer, PangleSdkWrapper pangleSdkWrapper, PangleFactory pangleFactory, PanglePrivacyConfig panglePrivacyConfig) {
        this.pangleInitializer = pangleInitializer;
        this.pangleSdkWrapper = pangleSdkWrapper;
        this.pangleFactory = pangleFactory;
        this.panglePrivacyConfig = panglePrivacyConfig;
    }

    public void collectSignals(@NonNull RtbSignalData rtbSignalData, final @NonNull SignalCallbacks signalCallbacks) {
        Bundle networkExtras = rtbSignalData.getNetworkExtras();
        if (networkExtras != null && networkExtras.containsKey("user_data")) {
            this.pangleSdkWrapper.setUserData(networkExtras.getString("user_data", ""));
        }
        this.pangleSdkWrapper.getBiddingToken(new BiddingTokenCallback(){

            public void onBiddingTokenCollected(String biddingToken) {
                signalCallbacks.onSuccess(biddingToken);
            }
        });
    }

    public void initialize(@NonNull Context context, final @NonNull InitializationCompleteCallback initializationCompleteCallback, @NonNull List<MediationConfiguration> list) {
        HashSet<String> appIds = new HashSet<String>();
        for (MediationConfiguration mediationConfiguration : list) {
            Bundle serverParameters = mediationConfiguration.getServerParameters();
            String appId = serverParameters.getString("appid");
            if (TextUtils.isEmpty((CharSequence)appId)) continue;
            appIds.add(appId);
        }
        int count = appIds.size();
        if (count <= 0) {
            AdError error = PangleConstants.createAdapterError(101, ERROR_MESSAGE_MISSING_OR_INVALID_APP_ID);
            Log.w((String)TAG, (String)error.toString());
            initializationCompleteCallback.onInitializationFailed(error.toString());
            return;
        }
        String appId = (String)appIds.iterator().next();
        if (count > 1) {
            String message = String.format("Found multiple app IDs in %s. Using %s to initialize Pangle SDK.", appIds, appId);
            Log.w((String)TAG, (String)message);
        }
        this.panglePrivacyConfig.setCoppa(MobileAds.getRequestConfiguration().getTagForChildDirectedTreatment());
        this.pangleInitializer.initialize(context, appId, new PangleInitializer.Listener(){

            @Override
            public void onInitializeSuccess() {
                initializationCompleteCallback.onInitializationSucceeded();
            }

            @Override
            public void onInitializeError(@NonNull AdError error) {
                Log.w((String)TAG, (String)error.toString());
                initializationCompleteCallback.onInitializationFailed(error.getMessage());
            }
        });
    }

    @NonNull
    public VersionInfo getVersionInfo() {
        return this.getVersionInfo("5.9.0.4.0");
    }

    @VisibleForTesting
    @NonNull
    VersionInfo getVersionInfo(String versionString) {
        String[] splits = versionString.split("\\.");
        if (splits.length >= 4) {
            int major = Integer.parseInt(splits[0]);
            int minor = Integer.parseInt(splits[1]);
            int micro = Integer.parseInt(splits[2]) * 100 + Integer.parseInt(splits[3]);
            if (splits.length >= 5) {
                micro = micro * 100 + Integer.parseInt(splits[4]);
            }
            return new VersionInfo(major, minor, micro);
        }
        String logMessage = String.format("Unexpected adapter version format: %s. Returning 0.0.0 for adapter version.", versionString);
        Log.w((String)TAG, (String)logMessage);
        return new VersionInfo(0, 0, 0);
    }

    @NonNull
    public VersionInfo getSDKVersionInfo() {
        String versionString = this.pangleSdkWrapper.getSdkVersion();
        String[] splits = versionString.split("\\.");
        if (splits.length >= 3) {
            int major = Integer.parseInt(splits[0]);
            int minor = Integer.parseInt(splits[1]);
            int micro = Integer.parseInt(splits[2]);
            if (splits.length >= 4) {
                micro = micro * 100 + Integer.parseInt(splits[3]);
            }
            return new VersionInfo(major, minor, micro);
        }
        String logMessage = String.format("Unexpected SDK version format: %s. Returning 0.0.0 for SDK version.", versionString);
        Log.w((String)TAG, (String)logMessage);
        return new VersionInfo(0, 0, 0);
    }

    public void loadAppOpenAd(@NonNull MediationAppOpenAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationAppOpenAd, MediationAppOpenAdCallback> callback) {
        this.appOpenAd = this.pangleFactory.createPangleAppOpenAd(adConfiguration, callback, this.pangleInitializer, this.pangleSdkWrapper, this.panglePrivacyConfig);
        this.appOpenAd.render();
    }

    public void loadBannerAd(@NonNull MediationBannerAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> callback) {
        this.bannerAd = this.pangleFactory.createPangleBannerAd(adConfiguration, callback, this.pangleInitializer, this.pangleSdkWrapper, this.panglePrivacyConfig);
        this.bannerAd.render();
    }

    public void loadInterstitialAd(@NonNull MediationInterstitialAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> callback) {
        this.interstitialAd = this.pangleFactory.createPangleInterstitialAd(adConfiguration, callback, this.pangleInitializer, this.pangleSdkWrapper, this.panglePrivacyConfig);
        this.interstitialAd.render();
    }

    public void loadNativeAd(@NonNull MediationNativeAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> callback) {
        this.nativeAd = this.pangleFactory.createPangleNativeAd(adConfiguration, callback, this.pangleInitializer, this.pangleSdkWrapper, this.panglePrivacyConfig);
        this.nativeAd.render();
    }

    public void loadRewardedAd(@NonNull MediationRewardedAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> callback) {
        this.rewardedAd = this.pangleFactory.createPangleRewardedAd(adConfiguration, callback, this.pangleInitializer, this.pangleSdkWrapper, this.panglePrivacyConfig);
        this.rewardedAd.render();
    }

    public static void setGDPRConsent(@PAGConstant.PAGGDPRConsentType int gdpr) {
        PangleMediationAdapter.setGDPRConsent(gdpr, new PangleSdkWrapper());
    }

    @VisibleForTesting
    static void setGDPRConsent(@PAGConstant.PAGGDPRConsentType int gdpr, PangleSdkWrapper pangleSdkWrapper) {
        if (gdpr != 1 && gdpr != 0 && gdpr != -1) {
            Log.w((String)TAG, (String)"Invalid GDPR value. Pangle SDK only accepts -1, 0 or 1.");
            return;
        }
        if (pangleSdkWrapper.isInitSuccess()) {
            pangleSdkWrapper.setGdprConsent(gdpr);
        }
        PangleMediationAdapter.gdpr = gdpr;
    }

    public static int getGDPRConsent() {
        return gdpr;
    }

    public static void setDoNotSell(@PAGConstant.PAGDoNotSellType int ccpa) {
        PangleMediationAdapter.setDoNotSell(ccpa, new PangleSdkWrapper());
    }

    @VisibleForTesting
    static void setDoNotSell(@PAGConstant.PAGDoNotSellType int ccpa, PangleSdkWrapper pangleSdkWrapper) {
        if (ccpa != 0 && ccpa != 1 && ccpa != -1) {
            Log.w((String)TAG, (String)"Invalid CCPA value. Pangle SDK only accepts -1, 0 or 1.");
            return;
        }
        if (pangleSdkWrapper.isInitSuccess()) {
            pangleSdkWrapper.setDoNotSell(ccpa);
        }
        PangleMediationAdapter.ccpa = ccpa;
    }

    public static int getDoNotSell() {
        return ccpa;
    }
}

