/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.pangle.renderer;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.bytedance.sdk.openadsdk.api.PAGRequest;
import com.bytedance.sdk.openadsdk.api.reward.PAGRewardItem;
import com.bytedance.sdk.openadsdk.api.reward.PAGRewardedAd;
import com.bytedance.sdk.openadsdk.api.reward.PAGRewardedAdInteractionListener;
import com.bytedance.sdk.openadsdk.api.reward.PAGRewardedAdLoadListener;
import com.bytedance.sdk.openadsdk.api.reward.PAGRewardedRequest;
import com.google.ads.mediation.pangle.PangleConstants;
import com.google.ads.mediation.pangle.PangleFactory;
import com.google.ads.mediation.pangle.PangleInitializer;
import com.google.ads.mediation.pangle.PangleMediationAdapter;
import com.google.ads.mediation.pangle.PanglePrivacyConfig;
import com.google.ads.mediation.pangle.PangleRequestHelper;
import com.google.ads.mediation.pangle.PangleSdkWrapper;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdConfiguration;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;
import com.google.android.gms.ads.rewarded.RewardItem;

public class PangleRewardedAd
implements MediationRewardedAd {
    private final MediationRewardedAdConfiguration adConfiguration;
    private final MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> adLoadCallback;
    private final PangleInitializer pangleInitializer;
    private final PangleSdkWrapper pangleSdkWrapper;
    private final PangleFactory pangleFactory;
    private final PanglePrivacyConfig panglePrivacyConfig;
    private MediationRewardedAdCallback rewardedAdCallback;
    private PAGRewardedAd pagRewardedAd;

    public PangleRewardedAd(@NonNull MediationRewardedAdConfiguration mediationRewardedAdConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> mediationAdLoadCallback, @NonNull PangleInitializer pangleInitializer, PangleSdkWrapper pangleSdkWrapper, PangleFactory pangleFactory, @NonNull PanglePrivacyConfig panglePrivacyConfig) {
        this.adConfiguration = mediationRewardedAdConfiguration;
        this.adLoadCallback = mediationAdLoadCallback;
        this.pangleInitializer = pangleInitializer;
        this.pangleSdkWrapper = pangleSdkWrapper;
        this.pangleFactory = pangleFactory;
        this.panglePrivacyConfig = panglePrivacyConfig;
    }

    public void render() {
        this.panglePrivacyConfig.setCoppa(this.adConfiguration.taggedForChildDirectedTreatment());
        Bundle serverParameters = this.adConfiguration.getServerParameters();
        final String placementId = serverParameters.getString("placementid");
        if (TextUtils.isEmpty((CharSequence)placementId)) {
            AdError error = PangleConstants.createAdapterError(101, "Failed to load rewarded ad from Pangle. Missing or invalid Placement ID.");
            Log.e((String)PangleMediationAdapter.TAG, (String)error.toString());
            this.adLoadCallback.onFailure(error);
            return;
        }
        final String bidResponse = this.adConfiguration.getBidResponse();
        Context context = this.adConfiguration.getContext();
        String appId = serverParameters.getString("appid");
        this.pangleInitializer.initialize(context, appId, new PangleInitializer.Listener(){

            @Override
            public void onInitializeSuccess() {
                PAGRewardedRequest request = PangleRewardedAd.this.pangleFactory.createPagRewardedRequest();
                request.setAdString(bidResponse);
                PangleRequestHelper.setWatermarkString((PAGRequest)request, bidResponse, (MediationAdConfiguration)PangleRewardedAd.this.adConfiguration);
                PangleRewardedAd.this.pangleSdkWrapper.loadRewardedAd(placementId, request, new PAGRewardedAdLoadListener(){

                    public void onError(int errorCode, String errorMessage) {
                        AdError error = PangleConstants.createSdkError(errorCode, errorMessage);
                        Log.w((String)PangleMediationAdapter.TAG, (String)error.toString());
                        PangleRewardedAd.this.adLoadCallback.onFailure(error);
                    }

                    public void onAdLoaded(PAGRewardedAd rewardedAd) {
                        PangleRewardedAd.this.rewardedAdCallback = (MediationRewardedAdCallback)PangleRewardedAd.this.adLoadCallback.onSuccess((Object)PangleRewardedAd.this);
                        PangleRewardedAd.this.pagRewardedAd = rewardedAd;
                    }
                });
            }

            @Override
            public void onInitializeError(@NonNull AdError error) {
                Log.w((String)PangleMediationAdapter.TAG, (String)error.toString());
                PangleRewardedAd.this.adLoadCallback.onFailure(error);
            }
        });
    }

    public void showAd(@NonNull Context context) {
        this.pagRewardedAd.setAdInteractionListener(new PAGRewardedAdInteractionListener(){

            public void onAdShowed() {
                if (PangleRewardedAd.this.rewardedAdCallback != null) {
                    PangleRewardedAd.this.rewardedAdCallback.onAdOpened();
                    PangleRewardedAd.this.rewardedAdCallback.reportAdImpression();
                }
            }

            public void onAdClicked() {
                if (PangleRewardedAd.this.rewardedAdCallback != null) {
                    PangleRewardedAd.this.rewardedAdCallback.reportAdClicked();
                }
            }

            public void onAdDismissed() {
                if (PangleRewardedAd.this.rewardedAdCallback != null) {
                    PangleRewardedAd.this.rewardedAdCallback.onAdClosed();
                }
            }

            public void onUserEarnedReward(final PAGRewardItem pagRewardItem) {
                RewardItem rewardItem = new RewardItem(){

                    @NonNull
                    public String getType() {
                        return pagRewardItem.getRewardName();
                    }

                    public int getAmount() {
                        return pagRewardItem.getRewardAmount();
                    }
                };
                if (PangleRewardedAd.this.rewardedAdCallback != null) {
                    PangleRewardedAd.this.rewardedAdCallback.onUserEarnedReward(rewardItem);
                }
            }

            public void onUserEarnedRewardFail(int errorCode, String errorMessage) {
                String rewardErrorMessage = String.format("Failed to reward user: %s", errorMessage);
                AdError error = PangleConstants.createSdkError(errorCode, rewardErrorMessage);
                Log.d((String)PangleMediationAdapter.TAG, (String)error.toString());
            }
        });
        if (context instanceof Activity) {
            this.pagRewardedAd.show((Activity)context);
            return;
        }
        this.pagRewardedAd.show(null);
    }
}

