/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.unity;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.ads.mediation.unity.UnityAdsAdapterUtils;
import com.google.ads.mediation.unity.UnityBannerAd;
import com.google.ads.mediation.unity.UnityInitializer;
import com.google.ads.mediation.unity.UnityMediationAdapter;
import com.google.ads.mediation.unity.eventadapters.UnityInterstitialEventAdapter;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.UnityAdsLoadOptions;
import com.unity3d.ads.UnityAdsShowOptions;
import java.lang.ref.WeakReference;
import java.util.UUID;

@Keep
public class UnityAdapter
extends UnityMediationAdapter
implements MediationInterstitialAdapter,
MediationBannerAdapter {
    private MediationInterstitialListener mediationInterstitialListener;
    private String placementId;
    private String objectId;
    private WeakReference<Activity> activityWeakReference;
    private UnityBannerAd bannerAd;
    private UnityInterstitialEventAdapter eventAdapter;
    private final IUnityAdsLoadListener unityLoadListener = new IUnityAdsLoadListener(){

        public void onUnityAdsAdLoaded(String placementId) {
            String logMessage = String.format("Unity Ads interstitial ad successfully loaded for placement ID: %s", placementId);
            Log.d((String)UnityMediationAdapter.TAG, (String)logMessage);
            UnityAdapter.this.placementId = placementId;
            UnityAdapter.this.eventAdapter.sendAdEvent(UnityAdsAdapterUtils.AdEvent.LOADED);
        }

        public void onUnityAdsFailedToLoad(String placementId, UnityAds.UnityAdsLoadError error, String message) {
            UnityAdapter.this.placementId = placementId;
            AdError loadError = UnityAdsAdapterUtils.createSDKError(error, message);
            Log.w((String)UnityMediationAdapter.TAG, (String)loadError.toString());
            if (UnityAdapter.this.mediationInterstitialListener != null) {
                UnityAdapter.this.mediationInterstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)UnityAdapter.this, loadError);
            }
        }
    };
    private final IUnityAdsShowListener unityShowListener = new IUnityAdsShowListener(){

        public void onUnityAdsShowStart(String placementId) {
            String logMessage = String.format("Unity Ads interstitial ad started for placement ID: %s", UnityAdapter.this.placementId);
            Log.d((String)UnityMediationAdapter.TAG, (String)logMessage);
            UnityAdapter.this.eventAdapter.sendAdEvent(UnityAdsAdapterUtils.AdEvent.OPENED);
        }

        public void onUnityAdsShowClick(String placementId) {
            String logMessage = String.format("Unity Ads interstitial ad was clicked for placement ID: %s", UnityAdapter.this.placementId);
            Log.d((String)UnityMediationAdapter.TAG, (String)logMessage);
            UnityAdapter.this.eventAdapter.sendAdEvent(UnityAdsAdapterUtils.AdEvent.CLICKED);
            UnityAdapter.this.eventAdapter.sendAdEvent(UnityAdsAdapterUtils.AdEvent.LEFT_APPLICATION);
        }

        public void onUnityAdsShowComplete(String placementId, UnityAds.UnityAdsShowCompletionState state) {
            String logMessage = String.format("Unity Ads interstitial ad finished playing for placement ID: %s", UnityAdapter.this.placementId);
            Log.d((String)UnityMediationAdapter.TAG, (String)logMessage);
            UnityAdapter.this.eventAdapter.sendAdEvent(UnityAdsAdapterUtils.AdEvent.CLOSED);
        }

        public void onUnityAdsShowFailure(String placementId, UnityAds.UnityAdsShowError error, String message) {
            AdError adError = UnityAdsAdapterUtils.createSDKError(error, message);
            Log.w((String)UnityMediationAdapter.TAG, (String)adError.toString());
            UnityAdapter.this.eventAdapter.sendAdEvent(UnityAdsAdapterUtils.AdEvent.OPENED);
            UnityAdapter.this.eventAdapter.sendAdEvent(UnityAdsAdapterUtils.AdEvent.CLOSED);
        }
    };

    public void requestInterstitialAd(@NonNull Context context, @NonNull MediationInterstitialListener mediationInterstitialListener, @NonNull Bundle serverParameters, @NonNull MediationAdRequest mediationAdRequest, @Nullable Bundle mediationExtras) {
        this.mediationInterstitialListener = mediationInterstitialListener;
        this.eventAdapter = new UnityInterstitialEventAdapter(this.mediationInterstitialListener, this);
        final String gameId = serverParameters.getString("gameId");
        this.placementId = serverParameters.getString("zoneId");
        if (!UnityAdsAdapterUtils.areValidIds(gameId, this.placementId)) {
            this.sendAdFailedToLoad(101, "Missing or invalid server parameters.");
            return;
        }
        if (!(context instanceof Activity)) {
            this.sendAdFailedToLoad(105, "Unity Ads requires an Activity context to load ads.");
            return;
        }
        Activity activity = (Activity)context;
        this.activityWeakReference = new WeakReference<Activity>(activity);
        UnityInitializer.getInstance().initializeUnityAds(context, gameId, new IUnityAdsInitializationListener(){

            public void onInitializationComplete() {
                String logMessage = String.format("Unity Ads is initialized for game ID '%s' and can now load interstitial ad with placement ID: %s", gameId, UnityAdapter.this.placementId);
                Log.d((String)UnityMediationAdapter.TAG, (String)logMessage);
            }

            public void onInitializationFailed(UnityAds.UnityAdsInitializationError unityAdsInitializationError, String errorMessage) {
                String adErrorMessage = String.format("Unity Ads initialization failed for game ID '%s' with error message: %s", gameId, errorMessage);
                AdError adError = UnityAdsAdapterUtils.createSDKError(unityAdsInitializationError, adErrorMessage);
                Log.w((String)UnityMediationAdapter.TAG, (String)adError.toString());
                if (UnityAdapter.this.mediationInterstitialListener != null) {
                    UnityAdapter.this.mediationInterstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)UnityAdapter.this, adError);
                }
            }
        });
        UnityAdsAdapterUtils.setCoppa(MobileAds.getRequestConfiguration().getTagForChildDirectedTreatment(), context);
        this.objectId = UUID.randomUUID().toString();
        UnityAdsLoadOptions unityAdsLoadOptions = new UnityAdsLoadOptions();
        unityAdsLoadOptions.setObjectId(this.objectId);
        UnityAds.load((String)this.placementId, (UnityAdsLoadOptions)unityAdsLoadOptions, (IUnityAdsLoadListener)this.unityLoadListener);
    }

    private void sendAdFailedToLoad(int errorCode, String errorDescription) {
        AdError adError = UnityAdsAdapterUtils.createAdError(errorCode, errorDescription);
        Log.w((String)TAG, (String)adError.toString());
        if (this.mediationInterstitialListener != null) {
            this.mediationInterstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)this, adError);
        }
    }

    public void showInterstitial() {
        Activity activityReference;
        Activity activity = activityReference = this.activityWeakReference == null ? null : (Activity)this.activityWeakReference.get();
        if (activityReference == null) {
            Log.w((String)TAG, (String)("Failed to show interstitial ad for placement ID '" + this.placementId + "' from Unity Ads: Activity context is null."));
            this.eventAdapter.sendAdEvent(UnityAdsAdapterUtils.AdEvent.CLOSED);
            return;
        }
        if (this.placementId == null) {
            Log.w((String)TAG, (String)"Unity Ads received call to show before successfully loading an ad.");
        }
        UnityAdsShowOptions unityAdsShowOptions = new UnityAdsShowOptions();
        unityAdsShowOptions.setObjectId(this.objectId);
        UnityAds.show((Activity)activityReference, (String)this.placementId, (UnityAdsShowOptions)unityAdsShowOptions, (IUnityAdsShowListener)this.unityShowListener);
    }

    public void requestBannerAd(@NonNull Context context, @NonNull MediationBannerListener listener, @NonNull Bundle serverParameters, @NonNull AdSize adSize, @NonNull MediationAdRequest adRequest, @Nullable Bundle mediationExtras) {
        this.bannerAd = new UnityBannerAd();
        this.bannerAd.requestBannerAd(context, listener, serverParameters, adSize, adRequest, mediationExtras);
    }

    public void onDestroy() {
        this.mediationInterstitialListener = null;
        if (this.bannerAd != null) {
            this.bannerAd.onDestroy();
        }
    }

    public void onPause() {
        if (this.bannerAd != null) {
            this.bannerAd.onPause();
        }
    }

    public void onResume() {
        if (this.bannerAd != null) {
            this.bannerAd.onResume();
        }
    }

    @NonNull
    public View getBannerView() {
        return this.bannerAd.getBannerView();
    }
}

