/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.unity;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.MediationUtils;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.metadata.MetaData;
import com.unity3d.services.banners.BannerErrorInfo;
import com.unity3d.services.banners.UnityBannerSize;
import java.util.ArrayList;

public class UnityAdsAdapterUtils {
    private UnityAdsAdapterUtils() {
    }

    @NonNull
    static AdError createSDKError(@NonNull UnityAds.UnityAdsInitializationError unityAdsError, @NonNull String description) {
        return UnityAdsAdapterUtils.createAdError(UnityAdsAdapterUtils.getMediationErrorCode(unityAdsError), description);
    }

    @NonNull
    static AdError createSDKError(@NonNull UnityAds.UnityAdsLoadError unityAdsError, @NonNull String description) {
        return UnityAdsAdapterUtils.createAdError(UnityAdsAdapterUtils.getMediationErrorCode(unityAdsError), description);
    }

    @NonNull
    static AdError createSDKError(@NonNull UnityAds.UnityAdsShowError unityAdsError, @NonNull String description) {
        return UnityAdsAdapterUtils.createAdError(UnityAdsAdapterUtils.getMediationErrorCode(unityAdsError), description);
    }

    @NonNull
    static AdError createAdError(int errorCode, @NonNull String description) {
        return new AdError(errorCode, description, "com.unity3d.ads");
    }

    static int getMediationErrorCode(@NonNull BannerErrorInfo errorInfo) {
        int errorCode = 200;
        switch (errorInfo.errorCode) {
            case UNKNOWN: {
                errorCode = 201;
                break;
            }
            case NATIVE_ERROR: {
                errorCode = 202;
                break;
            }
            case WEBVIEW_ERROR: {
                errorCode = 203;
                break;
            }
            case NO_FILL: {
                errorCode = 204;
            }
        }
        return errorCode;
    }

    static int getMediationErrorCode(@NonNull UnityAds.UnityAdsInitializationError unityAdsError) {
        switch (unityAdsError) {
            case INTERNAL_ERROR: {
                return 301;
            }
            case INVALID_ARGUMENT: {
                return 302;
            }
            case AD_BLOCKER_DETECTED: {
                return 303;
            }
        }
        return 300;
    }

    static int getMediationErrorCode(@NonNull UnityAds.UnityAdsLoadError unityAdsError) {
        switch (unityAdsError) {
            case INITIALIZE_FAILED: {
                return 401;
            }
            case INTERNAL_ERROR: {
                return 402;
            }
            case INVALID_ARGUMENT: {
                return 403;
            }
            case NO_FILL: {
                return 404;
            }
            case TIMEOUT: {
                return 405;
            }
        }
        return 400;
    }

    static int getMediationErrorCode(@NonNull UnityAds.UnityAdsShowError unityAdsError) {
        switch (unityAdsError) {
            case NOT_INITIALIZED: {
                return 501;
            }
            case NOT_READY: {
                return 502;
            }
            case VIDEO_PLAYER_ERROR: {
                return 503;
            }
            case INVALID_ARGUMENT: {
                return 504;
            }
            case NO_CONNECTION: {
                return 505;
            }
            case ALREADY_SHOWING: {
                return 506;
            }
            case INTERNAL_ERROR: {
                return 507;
            }
        }
        return 500;
    }

    @Nullable
    public static UnityBannerSize getUnityBannerSize(@NonNull Context context, @NonNull AdSize adSize) {
        ArrayList<AdSize> potentials = new ArrayList<AdSize>();
        potentials.add(AdSize.BANNER);
        potentials.add(AdSize.LEADERBOARD);
        AdSize closestSize = MediationUtils.findClosestSize((Context)context, (AdSize)adSize, potentials);
        if (closestSize != null) {
            return new UnityBannerSize(closestSize.getWidth(), closestSize.getHeight());
        }
        return null;
    }

    public static void setCoppa(int coppa, @NonNull Context context) {
        MetaData userMetaData = new MetaData(context);
        if (coppa == 0) {
            userMetaData.set("user.nonbehavioral", (Object)false);
        } else {
            userMetaData.set("user.nonbehavioral", (Object)true);
        }
        userMetaData.commit();
    }

    public static boolean areValidIds(String gameId, String placementId) {
        return !TextUtils.isEmpty((CharSequence)gameId) && !TextUtils.isEmpty((CharSequence)placementId);
    }

    public static enum AdEvent {
        LOADED,
        OPENED,
        CLICKED,
        CLOSED,
        LEFT_APPLICATION,
        IMPRESSION,
        VIDEO_START,
        REWARD,
        VIDEO_COMPLETE;

    }
}

