/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.unity;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.ads.mediation.unity.UnityAdsAdapterUtils;
import com.google.ads.mediation.unity.UnityAdsLoader;
import com.google.ads.mediation.unity.UnityBannerViewFactory;
import com.google.ads.mediation.unity.UnityInitializer;
import com.google.ads.mediation.unity.UnityInterstitialAd;
import com.google.ads.mediation.unity.UnityMediationBannerAd;
import com.google.ads.mediation.unity.UnityRewardedAd;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.mediation.InitializationCompleteCallback;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationBannerAd;
import com.google.android.gms.ads.mediation.MediationBannerAdCallback;
import com.google.android.gms.ads.mediation.MediationBannerAdConfiguration;
import com.google.android.gms.ads.mediation.MediationConfiguration;
import com.google.android.gms.ads.mediation.MediationInterstitialAd;
import com.google.android.gms.ads.mediation.MediationInterstitialAdCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAdConfiguration;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;
import com.google.android.gms.ads.mediation.rtb.RtbAdapter;
import com.google.android.gms.ads.mediation.rtb.RtbSignalData;
import com.google.android.gms.ads.mediation.rtb.SignalCallbacks;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.UnityAds;
import java.util.HashSet;
import java.util.List;

public class UnityMediationAdapter
extends RtbAdapter {
    static final String TAG = UnityMediationAdapter.class.getSimpleName();
    public static final String ADAPTER_ERROR_DOMAIN = "com.google.ads.mediation.unity";
    public static final String SDK_ERROR_DOMAIN = "com.unity3d.ads";
    static final int ERROR_INVALID_SERVER_PARAMETERS = 101;
    static final int ERROR_PLACEMENT_STATE_NO_FILL = 102;
    static final int ERROR_PLACEMENT_STATE_DISABLED = 103;
    static final int ERROR_NULL_CONTEXT = 104;
    static final int ERROR_CONTEXT_NOT_ACTIVITY = 105;
    static final int ERROR_AD_NOT_READY = 106;
    static final int ERROR_UNITY_ADS_NOT_SUPPORTED = 107;
    static final int ERROR_FINISH = 109;
    static final int ERROR_BANNER_SIZE_MISMATCH = 110;
    static final int ERROR_INITIALIZATION_FAILURE = 111;
    static final String ERROR_MSG_MISSING_PARAMETERS = "Missing or invalid server parameters.";
    static final String ERROR_MSG_NON_ACTIVITY = "Unity Ads requires an Activity context to load ads.";
    static final String ERROR_MSG_CONTEXT_NULL = "Activity context is null.";
    static final String ERROR_MSG_INITIALIZATION_FAILURE = "Unity Ads initialization failed: [%s] %s";
    static final String KEY_GAME_ID = "gameId";
    static final String KEY_PLACEMENT_ID = "zoneId";
    static final String KEY_WATERMARK = "watermark";
    private final UnityInitializer unityInitializer;
    private final UnityBannerViewFactory unityBannerViewFactory;
    private final UnityAdsLoader unityAdsLoader;
    private UnityMediationBannerAd bannerAd;
    private UnityMediationBannerAd bannerRtbAd;
    private UnityInterstitialAd interstitialAd;
    private UnityInterstitialAd interstitialRtbAd;
    private UnityRewardedAd rewardedAd;
    private UnityRewardedAd rewardedRtbAd;

    public UnityMediationAdapter() {
        this.unityInitializer = UnityInitializer.getInstance();
        this.unityBannerViewFactory = new UnityBannerViewFactory();
        this.unityAdsLoader = new UnityAdsLoader();
    }

    public void collectSignals(@NonNull RtbSignalData rtbSignalData, @NonNull SignalCallbacks signalCallbacks) {
        UnityAds.getToken(token -> {
            if (token == null) {
                token = "";
            }
            signalCallbacks.onSuccess(token);
        });
    }

    @VisibleForTesting
    UnityMediationAdapter(UnityInitializer unityInitializer, UnityBannerViewFactory unityBannerViewFactory, UnityAdsLoader unityAdsLoader) {
        this.unityInitializer = unityInitializer;
        this.unityBannerViewFactory = unityBannerViewFactory;
        this.unityAdsLoader = unityAdsLoader;
    }

    @NonNull
    public VersionInfo getVersionInfo() {
        String versionString = "4.12.1.0";
        String[] splits = versionString.split("\\.");
        if (splits.length >= 4) {
            int major = Integer.parseInt(splits[0]);
            int minor = Integer.parseInt(splits[1]);
            int micro = Integer.parseInt(splits[2]) * 100 + Integer.parseInt(splits[3]);
            return new VersionInfo(major, minor, micro);
        }
        String logMessage = String.format("Unexpected adapter version format: %s. Returning 0.0.0 for adapter version.", versionString);
        Log.w((String)TAG, (String)logMessage);
        return new VersionInfo(0, 0, 0);
    }

    @NonNull
    public VersionInfo getSDKVersionInfo() {
        String versionString = UnityAds.getVersion();
        String[] splits = versionString.split("\\.");
        if (splits.length >= 3) {
            int major = Integer.parseInt(splits[0]);
            int minor = Integer.parseInt(splits[1]);
            int micro = Integer.parseInt(splits[2]);
            return new VersionInfo(major, minor, micro);
        }
        String logMessage = String.format("Unexpected SDK version format: %s. Returning 0.0.0 for SDK version.", versionString);
        Log.w((String)TAG, (String)logMessage);
        return new VersionInfo(0, 0, 0);
    }

    public void initialize(@NonNull Context context, final @NonNull InitializationCompleteCallback initializationCompleteCallback, @NonNull List<MediationConfiguration> mediationConfigurations) {
        HashSet<String> gameIDs = new HashSet<String>();
        for (MediationConfiguration configuration : mediationConfigurations) {
            Bundle serverParameters = configuration.getServerParameters();
            String gameIDFromServer = serverParameters.getString(KEY_GAME_ID);
            if (TextUtils.isEmpty((CharSequence)gameIDFromServer)) continue;
            gameIDs.add(gameIDFromServer);
        }
        String gameID = "";
        int count = gameIDs.size();
        if (count > 0) {
            gameID = (String)gameIDs.iterator().next();
            if (count > 1) {
                String message = String.format("Multiple '%s' entries found: %s. Using '%s' to initialize the UnityAds SDK", KEY_GAME_ID, gameIDs, gameID);
                Log.w((String)TAG, (String)message);
            }
        }
        if (TextUtils.isEmpty((CharSequence)gameID)) {
            AdError initializationError = new AdError(101, "Missing or invalid Game ID.", ADAPTER_ERROR_DOMAIN);
            initializationCompleteCallback.onInitializationFailed(initializationError.toString());
            return;
        }
        this.unityInitializer.initializeUnityAds(context, gameID, new IUnityAdsInitializationListener(){

            public void onInitializationComplete() {
                Log.d((String)TAG, (String)"Unity Ads initialized successfully.");
                initializationCompleteCallback.onInitializationSucceeded();
            }

            public void onInitializationFailed(UnityAds.UnityAdsInitializationError unityAdsInitializationError, String errorMessage) {
                AdError adError = UnityAdsAdapterUtils.createSDKError(unityAdsInitializationError, String.format(UnityMediationAdapter.ERROR_MSG_INITIALIZATION_FAILURE, unityAdsInitializationError, errorMessage));
                Log.d((String)TAG, (String)adError.toString());
                initializationCompleteCallback.onInitializationFailed(adError.toString());
            }
        });
    }

    public void loadRewardedAd(@NonNull MediationRewardedAdConfiguration mediationRewardedAdConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> mediationAdLoadCallback) {
        this.rewardedAd = new UnityRewardedAd(mediationRewardedAdConfiguration, mediationAdLoadCallback, this.unityInitializer, this.unityAdsLoader);
        this.rewardedAd.loadAd();
    }

    public void loadBannerAd(@NonNull MediationBannerAdConfiguration mediationBannerAdConfiguration, @NonNull MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> callback) {
        this.bannerAd = new UnityMediationBannerAd(mediationBannerAdConfiguration, callback, this.unityInitializer, this.unityBannerViewFactory, this.unityAdsLoader);
        this.bannerAd.loadAd();
    }

    public void loadRtbBannerAd(@NonNull MediationBannerAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> callback) {
        this.bannerRtbAd = new UnityMediationBannerAd(adConfiguration, callback, this.unityInitializer, this.unityBannerViewFactory, this.unityAdsLoader);
        this.bannerRtbAd.loadAd();
    }

    public void loadInterstitialAd(MediationInterstitialAdConfiguration adConfiguration, MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> callback) {
        this.interstitialAd = new UnityInterstitialAd(adConfiguration, callback, this.unityInitializer, this.unityAdsLoader);
        this.interstitialAd.loadAd();
    }

    public final void loadRtbInterstitialAd(@NonNull MediationInterstitialAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> callback) {
        this.interstitialRtbAd = new UnityInterstitialAd(adConfiguration, callback, this.unityInitializer, this.unityAdsLoader);
        this.interstitialRtbAd.loadAd();
    }

    public void loadRtbRewardedAd(@NonNull MediationRewardedAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> callback) {
        this.rewardedRtbAd = new UnityRewardedAd(adConfiguration, callback, this.unityInitializer, this.unityAdsLoader);
        this.rewardedRtbAd.loadAd();
    }
}

