/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.unity;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.ads.mediation.unity.UnityAdsAdapterUtils;
import com.google.ads.mediation.unity.UnityInitializer;
import com.google.ads.mediation.unity.UnityMediationAdapter;
import com.google.ads.mediation.unity.eventadapters.UnityBannerEventAdapter;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.banners.BannerErrorInfo;
import com.unity3d.services.banners.BannerView;
import com.unity3d.services.banners.UnityBannerSize;

@Keep
public class UnityBannerAd
extends UnityMediationAdapter
implements MediationBannerAdapter {
    private String bannerPlacementId;
    private String gameId;
    private BannerView bannerView;
    private MediationBannerListener mediationBannerListener;
    private UnityBannerEventAdapter eventAdapter;
    private BannerView.IListener unityBannerListener = new BannerView.Listener(){

        public void onBannerLoaded(BannerView bannerView) {
            this.logBannerMessage("Unity Ads finished loading banner ad for placement ID: %s", bannerView);
            UnityBannerAd.this.eventAdapter.sendAdEvent(UnityAdsAdapterUtils.AdEvent.LOADED);
        }

        public void onBannerClick(BannerView bannerView) {
            this.logBannerMessage("Unity Ads banner ad was clicked for placement ID: %s", bannerView);
            UnityBannerAd.this.eventAdapter.sendAdEvent(UnityAdsAdapterUtils.AdEvent.CLICKED);
            UnityBannerAd.this.eventAdapter.sendAdEvent(UnityAdsAdapterUtils.AdEvent.OPENED);
        }

        public void onBannerFailedToLoad(BannerView bannerView, BannerErrorInfo bannerErrorInfo) {
            UnityBannerAd.this.sendBannerFailedToLoad(UnityAdsAdapterUtils.getMediationErrorCode(bannerErrorInfo), bannerErrorInfo.errorMessage);
        }

        public void onBannerLeftApplication(BannerView bannerView) {
            this.logBannerMessage("Unity Ads banner ad left application for placement ID: %s", bannerView);
            UnityBannerAd.this.eventAdapter.sendAdEvent(UnityAdsAdapterUtils.AdEvent.LEFT_APPLICATION);
        }

        public void onBannerShown(BannerView bannerView) {
            this.logBannerMessage("Unity Ads banner ad was shown for placement ID: %s", bannerView);
            UnityBannerAd.this.eventAdapter.sendAdEvent(UnityAdsAdapterUtils.AdEvent.IMPRESSION);
        }

        private void logBannerMessage(String message, BannerView bannerView) {
            if (bannerView != null) {
                String logMessage = String.format(message, bannerView.getPlacementId());
                Log.d((String)UnityMediationAdapter.TAG, (String)logMessage);
            }
        }
    };

    public void onDestroy() {
        if (this.bannerView != null) {
            this.bannerView.destroy();
        }
        this.bannerView = null;
        this.mediationBannerListener = null;
        this.unityBannerListener = null;
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void requestBannerAd(final @NonNull Context context, @NonNull MediationBannerListener listener, @NonNull Bundle serverParameters, @NonNull AdSize adSize, @NonNull MediationAdRequest adRequest, @Nullable Bundle mediationExtras) {
        this.mediationBannerListener = listener;
        this.eventAdapter = new UnityBannerEventAdapter(this.mediationBannerListener, this);
        this.gameId = serverParameters.getString("gameId");
        this.bannerPlacementId = serverParameters.getString("zoneId");
        if (!UnityAdsAdapterUtils.areValidIds(this.gameId, this.bannerPlacementId)) {
            this.sendBannerFailedToLoad(101, "Missing or invalid server parameters.");
            return;
        }
        if (!(context instanceof Activity)) {
            this.sendBannerFailedToLoad(105, "Unity Ads requires an Activity context to load ads.");
            return;
        }
        final Activity activity = (Activity)context;
        final UnityBannerSize unityBannerSize = UnityAdsAdapterUtils.getUnityBannerSize(context, adSize);
        if (unityBannerSize == null) {
            String errorMessage = String.format("There is no matching Unity Ads ad size for Google ad size: %s", adSize);
            this.sendBannerFailedToLoad(110, errorMessage);
            return;
        }
        UnityInitializer.getInstance().initializeUnityAds(context, this.gameId, new IUnityAdsInitializationListener(){

            public void onInitializationComplete() {
                String logMessage = String.format("Unity Ads is initialized for game ID '%s' and can now load banner ad with placement ID: %s", UnityBannerAd.this.gameId, UnityBannerAd.this.bannerPlacementId);
                Log.d((String)UnityMediationAdapter.TAG, (String)logMessage);
                if (UnityBannerAd.this.bannerView == null) {
                    UnityBannerAd.this.bannerView = new BannerView(activity, UnityBannerAd.this.bannerPlacementId, unityBannerSize);
                }
                UnityAdsAdapterUtils.setCoppa(MobileAds.getRequestConfiguration().getTagForChildDirectedTreatment(), context);
                UnityBannerAd.this.bannerView.setListener(UnityBannerAd.this.unityBannerListener);
                UnityBannerAd.this.bannerView.load();
            }

            public void onInitializationFailed(UnityAds.UnityAdsInitializationError unityAdsInitializationError, String errorMessage) {
                String adErrorMessage = String.format("Unity Ads initialization failed for game ID '%s' with error message: %s", UnityBannerAd.this.gameId, errorMessage);
                AdError adError = UnityAdsAdapterUtils.createSDKError(unityAdsInitializationError, adErrorMessage);
                Log.w((String)UnityMediationAdapter.TAG, (String)adError.toString());
                if (UnityBannerAd.this.mediationBannerListener != null) {
                    UnityBannerAd.this.mediationBannerListener.onAdFailedToLoad((MediationBannerAdapter)UnityBannerAd.this, adError);
                }
            }
        });
    }

    @NonNull
    public View getBannerView() {
        return this.bannerView;
    }

    private void sendBannerFailedToLoad(int errorCode, String errorDescription) {
        AdError loadError = UnityAdsAdapterUtils.createAdError(errorCode, errorDescription);
        Log.w((String)TAG, (String)loadError.toString());
        if (this.mediationBannerListener != null) {
            this.mediationBannerListener.onAdFailedToLoad((MediationBannerAdapter)this, loadError);
        }
    }
}

