/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.unity;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.ads.mediation.unity.UnityAdsAdapterUtils;
import com.google.ads.mediation.unity.UnityAdsLoader;
import com.google.ads.mediation.unity.UnityInitializer;
import com.google.ads.mediation.unity.UnityMediationAdapter;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAd;
import com.google.android.gms.ads.mediation.MediationInterstitialAdCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAdConfiguration;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.UnityAdsLoadOptions;
import com.unity3d.ads.UnityAdsShowOptions;
import java.lang.ref.WeakReference;
import java.util.UUID;

public class UnityInterstitialAd
implements MediationInterstitialAd,
IUnityAdsLoadListener,
IUnityAdsShowListener {
    static final String ERROR_MSG_INTERSTITIAL_INITIALIZATION_FAILED = "Unity Ads initialization failed for game ID '%s' with error message: %s";
    private WeakReference<Activity> activityWeakReference;
    private String objectId;
    private final MediationInterstitialAdConfiguration adConfiguration;
    private final MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> adLoadCallback;
    private final UnityInitializer unityInitializer;
    private final UnityAdsLoader unityAdsLoader;
    @Nullable
    private MediationInterstitialAdCallback interstitialAdCallback;
    private String placementId;

    public UnityInterstitialAd(@NonNull MediationInterstitialAdConfiguration adConfiguration, @NonNull MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> adLoadCallback, @NonNull UnityInitializer unityInitializer, @NonNull UnityAdsLoader unityAdsLoader) {
        this.adConfiguration = adConfiguration;
        this.adLoadCallback = adLoadCallback;
        this.unityInitializer = unityInitializer;
        this.unityAdsLoader = unityAdsLoader;
    }

    public void onUnityAdsAdLoaded(String placementId) {
        String logMessage = String.format("Unity Ads interstitial ad successfully loaded for placement ID: %s", placementId);
        Log.d((String)UnityMediationAdapter.TAG, (String)logMessage);
        this.placementId = placementId;
        this.interstitialAdCallback = (MediationInterstitialAdCallback)this.adLoadCallback.onSuccess((Object)this);
    }

    public void onUnityAdsFailedToLoad(String placementId, UnityAds.UnityAdsLoadError error, String message) {
        this.placementId = placementId;
        AdError loadError = UnityAdsAdapterUtils.createSDKError(error, message);
        Log.w((String)UnityMediationAdapter.TAG, (String)loadError.toString());
        this.adLoadCallback.onFailure(loadError);
    }

    public void onUnityAdsShowStart(String placementId) {
        String logMessage = String.format("Unity Ads interstitial ad started for placement ID: %s", placementId);
        Log.d((String)UnityMediationAdapter.TAG, (String)logMessage);
        if (this.interstitialAdCallback != null) {
            this.interstitialAdCallback.onAdOpened();
        }
    }

    public void onUnityAdsShowClick(String placementId) {
        String logMessage = String.format("Unity Ads interstitial ad was clicked for placement ID: %s", placementId);
        Log.d((String)UnityMediationAdapter.TAG, (String)logMessage);
        if (this.interstitialAdCallback == null) {
            return;
        }
        this.interstitialAdCallback.reportAdClicked();
        this.interstitialAdCallback.onAdLeftApplication();
    }

    public void onUnityAdsShowComplete(String placementId, UnityAds.UnityAdsShowCompletionState state) {
        String logMessage = String.format("Unity Ads interstitial ad finished playing for placement ID: %s", placementId);
        Log.d((String)UnityMediationAdapter.TAG, (String)logMessage);
        if (this.interstitialAdCallback != null) {
            this.interstitialAdCallback.onAdClosed();
        }
    }

    public void onUnityAdsShowFailure(String placementId, UnityAds.UnityAdsShowError error, String message) {
        AdError adError = UnityAdsAdapterUtils.createSDKError(error, message);
        Log.w((String)UnityMediationAdapter.TAG, (String)adError.toString());
        if (this.interstitialAdCallback != null) {
            this.interstitialAdCallback.onAdFailedToShow(adError);
        }
    }

    public void loadAd() {
        final Context context = this.adConfiguration.getContext();
        Bundle serverParameters = this.adConfiguration.getServerParameters();
        final String gameId = serverParameters.getString("gameId");
        this.placementId = serverParameters.getString("zoneId");
        if (!UnityAdsAdapterUtils.areValidIds(gameId, this.placementId)) {
            AdError adError = new AdError(101, "Missing or invalid server parameters.", "com.google.ads.mediation.unity");
            this.adLoadCallback.onFailure(adError);
            return;
        }
        if (!(context instanceof Activity)) {
            AdError adError = new AdError(105, "Unity Ads requires an Activity context to load ads.", "com.google.ads.mediation.unity");
            this.adLoadCallback.onFailure(adError);
            return;
        }
        Activity activity = (Activity)context;
        this.activityWeakReference = new WeakReference<Activity>(activity);
        final String adMarkup = this.adConfiguration.getBidResponse();
        this.unityInitializer.initializeUnityAds(context, gameId, new IUnityAdsInitializationListener(){

            public void onInitializationComplete() {
                String logMessage = String.format("Unity Ads is initialized for game ID '%s' and can now load interstitial ad with placement ID: %s", gameId, UnityInterstitialAd.this.placementId);
                Log.d((String)UnityMediationAdapter.TAG, (String)logMessage);
                UnityAdsAdapterUtils.setCoppa(MobileAds.getRequestConfiguration().getTagForChildDirectedTreatment(), context);
                UnityInterstitialAd.this.objectId = UUID.randomUUID().toString();
                UnityAdsLoadOptions unityAdsLoadOptions = UnityInterstitialAd.this.unityAdsLoader.createUnityAdsLoadOptionsWithId(UnityInterstitialAd.this.objectId);
                if (adMarkup != null) {
                    unityAdsLoadOptions.setAdMarkup(adMarkup);
                }
                UnityInterstitialAd.this.unityAdsLoader.load(UnityInterstitialAd.this.placementId, unityAdsLoadOptions, UnityInterstitialAd.this);
            }

            public void onInitializationFailed(UnityAds.UnityAdsInitializationError unityAdsInitializationError, String errorMessage) {
                String adErrorMessage = String.format(UnityInterstitialAd.ERROR_MSG_INTERSTITIAL_INITIALIZATION_FAILED, gameId, errorMessage);
                AdError adError = UnityAdsAdapterUtils.createSDKError(unityAdsInitializationError, adErrorMessage);
                Log.w((String)UnityMediationAdapter.TAG, (String)adError.toString());
                UnityInterstitialAd.this.adLoadCallback.onFailure(adError);
            }
        });
    }

    public void showAd(Context context) {
        Activity activityReference;
        Activity activity = activityReference = this.activityWeakReference == null ? null : (Activity)this.activityWeakReference.get();
        if (activityReference == null) {
            Log.w((String)UnityMediationAdapter.TAG, (String)("Failed to show interstitial ad for placement ID '" + this.placementId + "' from Unity Ads: Activity context is null."));
            if (this.interstitialAdCallback != null) {
                AdError adError = new AdError(104, "Activity context is null.", "com.google.ads.mediation.unity");
                this.interstitialAdCallback.onAdFailedToShow(adError);
            }
            return;
        }
        if (this.placementId == null) {
            Log.w((String)UnityMediationAdapter.TAG, (String)"Unity Ads received call to show before successfully loading an ad.");
        }
        UnityAdsShowOptions unityAdsShowOptions = this.unityAdsLoader.createUnityAdsShowOptionsWithId(this.objectId);
        unityAdsShowOptions.set("watermark", this.adConfiguration.getWatermark());
        this.unityAdsLoader.show(activityReference, this.placementId, unityAdsShowOptions, this);
    }
}

