/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.unity;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.ads.mediation.unity.UnityAdsAdapterUtils;
import com.google.ads.mediation.unity.UnityAdsLoader;
import com.google.ads.mediation.unity.UnityInitializer;
import com.google.ads.mediation.unity.UnityMediationAdapter;
import com.google.ads.mediation.unity.UnityReward;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.UnityAdsLoadOptions;
import com.unity3d.ads.UnityAdsShowOptions;
import java.util.UUID;

public class UnityRewardedAd
implements MediationRewardedAd {
    private final MediationRewardedAdConfiguration mediationRewardedAdConfiguration;
    private final MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> mediationAdLoadCallback;
    private final UnityInitializer unityInitializer;
    private final UnityAdsLoader unityAdsLoader;
    @Nullable
    private MediationRewardedAdCallback mediationRewardedAdCallback;
    @Nullable
    private String placementId;
    @Nullable
    private String objectId;
    @VisibleForTesting
    final IUnityAdsLoadListener unityLoadListener = new IUnityAdsLoadListener(){

        public void onUnityAdsAdLoaded(String placementId) {
            String logMessage = String.format("Unity Ads rewarded ad successfully loaded placement ID: %s", placementId);
            Log.d((String)UnityMediationAdapter.TAG, (String)logMessage);
            UnityRewardedAd.this.placementId = placementId;
            UnityRewardedAd.this.mediationRewardedAdCallback = (MediationRewardedAdCallback)UnityRewardedAd.this.mediationAdLoadCallback.onSuccess((Object)UnityRewardedAd.this);
        }

        public void onUnityAdsFailedToLoad(String placementId, UnityAds.UnityAdsLoadError error, String message) {
            UnityRewardedAd.this.placementId = placementId;
            AdError adError = UnityAdsAdapterUtils.createSDKError(error, message);
            Log.w((String)UnityMediationAdapter.TAG, (String)adError.toString());
            UnityRewardedAd.this.mediationAdLoadCallback.onFailure(adError);
        }
    };
    @VisibleForTesting
    final IUnityAdsShowListener unityShowListener = new IUnityAdsShowListener(){

        public void onUnityAdsShowStart(String placementId) {
            if (UnityRewardedAd.this.mediationRewardedAdCallback == null) {
                return;
            }
            UnityRewardedAd.this.mediationRewardedAdCallback.onAdOpened();
            UnityRewardedAd.this.mediationRewardedAdCallback.reportAdImpression();
            UnityRewardedAd.this.mediationRewardedAdCallback.onVideoStart();
        }

        public void onUnityAdsShowClick(String placementId) {
            if (UnityRewardedAd.this.mediationRewardedAdCallback != null) {
                UnityRewardedAd.this.mediationRewardedAdCallback.reportAdClicked();
            }
        }

        public void onUnityAdsShowComplete(String placementId, UnityAds.UnityAdsShowCompletionState state) {
            if (UnityRewardedAd.this.mediationRewardedAdCallback == null) {
                return;
            }
            if (state == UnityAds.UnityAdsShowCompletionState.COMPLETED) {
                UnityRewardedAd.this.mediationRewardedAdCallback.onVideoComplete();
                UnityRewardedAd.this.mediationRewardedAdCallback.onUserEarnedReward((RewardItem)new UnityReward());
            }
            UnityRewardedAd.this.mediationRewardedAdCallback.onAdClosed();
        }

        public void onUnityAdsShowFailure(String placementId, UnityAds.UnityAdsShowError error, String message) {
            if (UnityRewardedAd.this.mediationRewardedAdCallback != null) {
                AdError adError = UnityAdsAdapterUtils.createSDKError(error, message);
                UnityRewardedAd.this.mediationRewardedAdCallback.onAdFailedToShow(adError);
            }
        }
    };

    public UnityRewardedAd(@NonNull MediationRewardedAdConfiguration mediationRewardedAdConfiguration, @NonNull MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> callback, @NonNull UnityInitializer unityInitializer, @NonNull UnityAdsLoader unityAdsLoader) {
        this.mediationRewardedAdConfiguration = mediationRewardedAdConfiguration;
        this.mediationAdLoadCallback = callback;
        this.unityInitializer = unityInitializer;
        this.unityAdsLoader = unityAdsLoader;
    }

    public void loadAd() {
        String placementId;
        Context context = this.mediationRewardedAdConfiguration.getContext();
        if (!(context instanceof Activity)) {
            AdError adError = new AdError(105, "Unity Ads requires an Activity context to load ads.", "com.google.ads.mediation.unity");
            Log.w((String)UnityMediationAdapter.TAG, (String)adError.toString());
            this.mediationAdLoadCallback.onFailure(adError);
            return;
        }
        Bundle serverParameters = this.mediationRewardedAdConfiguration.getServerParameters();
        String gameId = serverParameters.getString("gameId");
        if (!UnityAdsAdapterUtils.areValidIds(gameId, placementId = serverParameters.getString("zoneId"))) {
            AdError adError = new AdError(101, "Missing or invalid server parameters.", "com.google.ads.mediation.unity");
            Log.w((String)UnityMediationAdapter.TAG, (String)adError.toString());
            this.mediationAdLoadCallback.onFailure(adError);
            return;
        }
        String adMarkup = this.mediationRewardedAdConfiguration.getBidResponse();
        this.unityInitializer.initializeUnityAds(context, gameId, new UnityAdsInitializationListener(context, gameId, placementId, adMarkup));
    }

    public void showAd(@NonNull Context context) {
        if (!(context instanceof Activity)) {
            AdError showError = new AdError(105, "Unity Ads requires an Activity context to load ads.", "com.google.ads.mediation.unity");
            Log.e((String)UnityMediationAdapter.TAG, (String)showError.toString());
            if (this.mediationRewardedAdCallback != null) {
                this.mediationRewardedAdCallback.onAdFailedToShow(showError);
            }
            return;
        }
        Activity activity = (Activity)context;
        if (this.placementId == null) {
            Log.w((String)UnityMediationAdapter.TAG, (String)"Unity Ads received call to show before successfully loading an ad.");
        }
        UnityAdsShowOptions unityAdsShowOptions = this.unityAdsLoader.createUnityAdsShowOptionsWithId(this.objectId);
        unityAdsShowOptions.set("watermark", this.mediationRewardedAdConfiguration.getWatermark());
        this.unityAdsLoader.show(activity, this.placementId, unityAdsShowOptions, this.unityShowListener);
    }

    private class UnityAdsInitializationListener
    implements IUnityAdsInitializationListener {
        private final Context context;
        private final String gameId;
        private final String placementId;
        @Nullable
        private final String adMarkup;

        UnityAdsInitializationListener(Context context, String gameId, @Nullable String placementId, String adMarkup) {
            this.context = context;
            this.gameId = gameId;
            this.placementId = placementId;
            this.adMarkup = adMarkup;
        }

        public void onInitializationComplete() {
            String logMessage = String.format("Unity Ads is initialized for game ID '%s' and can now load rewarded ad with placement ID: %s", this.gameId, this.placementId);
            Log.d((String)UnityMediationAdapter.TAG, (String)logMessage);
            UnityAdsAdapterUtils.setCoppa(UnityRewardedAd.this.mediationRewardedAdConfiguration.taggedForChildDirectedTreatment(), this.context);
            UnityRewardedAd.this.objectId = UUID.randomUUID().toString();
            UnityAdsLoadOptions unityAdsLoadOptions = UnityRewardedAd.this.unityAdsLoader.createUnityAdsLoadOptionsWithId(UnityRewardedAd.this.objectId);
            if (this.adMarkup != null) {
                unityAdsLoadOptions.setAdMarkup(this.adMarkup);
            }
            UnityRewardedAd.this.unityAdsLoader.load(this.placementId, unityAdsLoadOptions, UnityRewardedAd.this.unityLoadListener);
        }

        public void onInitializationFailed(UnityAds.UnityAdsInitializationError unityAdsInitializationError, String errorMessage) {
            String adErrorMessage = String.format("Unity Ads initialization failed for game ID '%s' with error message: %s", this.gameId, errorMessage);
            AdError adError = UnityAdsAdapterUtils.createSDKError(unityAdsInitializationError, adErrorMessage);
            Log.w((String)UnityMediationAdapter.TAG, (String)adError.toString());
            UnityRewardedAd.this.mediationAdLoadCallback.onFailure(adError);
        }
    }
}

